/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioListener;
import ddf.minim.Recordable;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;

public class SignalSplitter
implements Recordable,
AudioListener {
    private Vector<AudioListener> listeners;
    private AudioFormat f;
    private int bs;

    public SignalSplitter(AudioFormat audioFormat, int n) {
        this.f = audioFormat;
        this.bs = n;
        this.listeners = new Vector(5);
    }

    @Override
    public int bufferSize() {
        return this.bs;
    }

    @Override
    public AudioFormat getFormat() {
        return this.f;
    }

    @Override
    public int type() {
        return this.f.getChannels();
    }

    @Override
    public synchronized void addListener(AudioListener audioListener) {
        if (!this.listeners.contains(audioListener)) {
            this.listeners.add(audioListener);
        }
    }

    @Override
    public synchronized void removeListener(AudioListener audioListener) {
        this.listeners.remove(audioListener);
    }

    @Override
    public synchronized void samples(float[] fArray) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            AudioListener audioListener = this.listeners.get(i);
            float[] fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            audioListener.samples(fArray2);
        }
    }

    @Override
    public synchronized void samples(float[] fArray, float[] fArray2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            AudioListener audioListener = this.listeners.get(i);
            float[] fArray3 = new float[fArray.length];
            float[] fArray4 = new float[fArray2.length];
            System.arraycopy(fArray, 0, fArray3, 0, fArray3.length);
            System.arraycopy(fArray2, 0, fArray4, 0, fArray4.length);
            audioListener.samples(fArray3, fArray4);
        }
    }

    @Override
    public float sampleRate() {
        return this.f.getSampleRate();
    }
}

