/*
 * Decompiled with CFR 0.152.
 */
package toxi.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public static final String timeStamp() {
        return DateUtils.timeStamp(new Date(), null);
    }

    public static final String timeStamp(Date date) {
        return DateUtils.timeStamp(date, null);
    }

    public static final String timeStamp(Date date, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        FORMAT.setTimeZone(timeZone);
        return FORMAT.format(date);
    }

    public static final String timeStamp(long l) {
        return DateUtils.timeStamp(new Date(l), null);
    }

    public static final String timeStampForZone(String string, Date date) {
        return DateUtils.timeStamp(date, TimeZone.getTimeZone(string));
    }

    public static final String timeStampGMT() {
        return DateUtils.timeStamp(new Date(), GMT);
    }

    public static final String timeStampGMT(Date date) {
        return DateUtils.timeStamp(date, GMT);
    }

    public static final String timeStampGMT(long l) {
        return DateUtils.timeStamp(new Date(l), GMT);
    }
}

