/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import toxi.geom.Vec3D;

public class OBJWriter {
    public final String VERSION = "0.3";
    protected OutputStream objStream;
    protected PrintWriter objWriter;
    protected int numVerticesWritten = 0;
    protected int numNormalsWritten = 0;

    public void beginSave(OutputStream outputStream) {
        try {
            this.objStream = outputStream;
            this.handleBeginSave();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void beginSave(String string) {
        try {
            this.objStream = new FileOutputStream(string);
            this.handleBeginSave();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void endSave() {
        try {
            this.objWriter.flush();
            this.objWriter.close();
            this.objStream.flush();
            this.objStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void face(int n, int n2, int n3) {
        this.objWriter.println("f " + n + " " + n2 + " " + n3);
    }

    public void faceList() {
        this.objWriter.println("s off");
    }

    public void faceWithNormals(int n, int n2, int n3, int n4, int n5, int n6) {
        this.objWriter.println("f " + n + "//" + n4 + " " + n2 + "//" + n5 + " " + n3 + "//" + n6);
    }

    public int getCurrNormalOffset() {
        return this.numNormalsWritten;
    }

    public int getCurrVertexOffset() {
        return this.numVerticesWritten;
    }

    protected void handleBeginSave() {
        this.objWriter = new PrintWriter(this.objStream);
        this.objWriter.println("# generated by OBJExport v0.3");
        this.numVerticesWritten = 0;
        this.numNormalsWritten = 0;
    }

    public void newObject(String string) {
        this.objWriter.println("o " + string);
    }

    public void normal(Vec3D vec3D) {
        this.objWriter.println("vn " + vec3D.x + " " + vec3D.y + " " + vec3D.z);
        ++this.numNormalsWritten;
    }

    public void vertex(Vec3D vec3D) {
        this.objWriter.println("v " + vec3D.x + " " + vec3D.y + " " + vec3D.z);
        ++this.numVerticesWritten;
    }
}

