/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.ArrayList;
import processing.core.PApplet;

public class demo
extends PApplet {
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int SONG_SKIP_MILLISECONDS = 5000;
    Minim minim;
    AudioPlayer song;
    float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
    int time;
    ArrayList<SnowFlake> snowFlakes = new ArrayList();
    IceTunnel tunnel = new IceTunnel();
    ArrayList<Beam> beams = new ArrayList();
    ArrayList<Shard> shards = new ArrayList();
    Rose rose;
    int[] snowFlakeStartSync = new int[]{381, 1031, 1213, 1565, 2374, 2992, 3482, 3917, 4335, 5446, 5824, 6594, 6786, 7271, 8146, 8621, 9108, 9516, 10021};
    int[] snowFlakeEndSync = new int[]{11656, 12376, 12794, 13908, 14349, 14837, 15232, 15696, 16764, 17136, 17949, 18134, 18552, 19667, 19992, 20456, 20921, 21408, 21408, 21408};
    int[] shardStartSync = new int[]{54565, 56353, 58261, 60234, 62045, 64010, 66084};
    int[] shardEndSync = new int[]{79202, 77507, 75696, 73792, 71795, 69961, 68173};
    int phase1Time = 23000;
    int phase2Time = 28500;
    int phase3Time = 31000;
    int pulseTime = 34200;
    int phase4Time = 43000;
    int phase5Time = 47000;
    int phase6Time = 79700;
    int phase7Time = 97200;
    int beam1EnterTime = 51000;
    int beam1SteadyTime = 53500;
    int beam1EndTime = 69300;
    int beam2EnterTime = 61500;
    int beam2SteadyTime = 58000;
    int beam2EndTime = 81500;
    int songEndTime = 104322;
    int songSilenceTime = 3000;

    public void setup() {
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.CANVAS_WIDTH = this.displayWidth;
        this.CANVAS_HEIGHT = this.displayHeight;
        this.ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
        this.fill(255.0f, 255.0f, 200.0f);
        this.frameRate(30.0f);
        this.stroke(200.0f, 200.0f, 255.0f);
        this.setupAudio();
        this.perspective();
        this.setupObjects();
    }

    public void setupAudio() {
        this.minim = new Minim((Object)this);
        this.song = this.minim.loadFile("Atomic_cat_-_Lost_Dreams.mp3");
        this.song.play();
    }

    public void setupObjects() {
        int n = 0;
        while (n < this.snowFlakeStartSync.length) {
            this.snowFlakes.add(new SnowFlake(demo.sin((float)((float)n * ((float)Math.PI * 2) / 21.0f)) * 30.0f + demo.sin((float)(this.snowFlakeStartSync[n] % 231)) * 10.0f, demo.cos((float)((float)n * ((float)Math.PI * 2) / 18.0f)) * 30.0f + demo.cos((float)(this.snowFlakeStartSync[n] % 162)) * 10.0f, 0.0f, this.snowFlakeStartSync[n], this.snowFlakeEndSync[n]));
            ++n;
        }
        this.beams.add(new Beam(this.color(170, 180, 255), this.beam1EnterTime, this.beam1SteadyTime, this.beam1EndTime, 1));
        this.beams.add(new Beam(this.color(255, 100, 100), this.beam2EnterTime, this.beam2SteadyTime, this.beam2EndTime, -1));
        n = 0;
        while (n < this.shardStartSync.length) {
            float f = (float)(this.shardStartSync[n] - this.beam1SteadyTime) * 0.001f;
            this.shards.add(new Shard(demo.sin((float)((f - 0.6f) * ((float)Math.PI * 2) / 21.0f)) * 15.0f + demo.cos((float)((f - 0.6f) * 10.0f * ((float)Math.PI * 2) / 21.0f)) * 5.0f, demo.cos((float)((f - 0.6f) * ((float)Math.PI * 2) / 21.0f)) * 15.0f + demo.sin((float)((f - 0.6f) * 10.0f * ((float)Math.PI * 2) / 21.0f)) * 5.0f, this.shardStartSync[n], this.shardEndSync[n]));
            ++n;
        }
        this.rose = new Rose(0.0f, 0.0f, 0.0f, this.phase6Time, this.phase7Time);
    }

    public void draw() {
        this.time = this.song.position();
        if (this.time < this.songEndTime) {
            this.background(0.0f, 0.0f, 50.0f);
            if (this.time > this.phase4Time) {
                this.background(0.0f, 0.0f, demo.constrain((int)(50 - demo.floor((float)((float)(this.time - this.phase4Time) * 0.1f))), (int)0, (int)50));
            }
            this.lights();
            this.translate((float)this.CANVAS_WIDTH / 2.0f, (float)this.CANVAS_HEIGHT / 2.0f, 10.0f);
            this.scale((float)this.CANVAS_WIDTH / 2.0f / this.ASPECT_RATIO * 0.02f, (float)(-this.CANVAS_HEIGHT) / 2.0f * 0.02f);
            this.drawDemo();
        } else if (this.time < this.songEndTime + this.songSilenceTime) {
            this.song.mute();
        } else {
            this.exit();
        }
    }

    public void drawDemo() {
        int n;
        this.pushMatrix();
        if (this.time > this.phase1Time && this.time < this.phase6Time) {
            this.rotateZ((float)(this.time - this.phase1Time) * -0.001f);
        }
        if (this.time > this.phase4Time && this.time < this.phase6Time) {
            this.translate(0.0f, 0.0f, (float)(this.time - this.phase4Time) * 0.2f);
        }
        if (this.time < this.phase5Time) {
            n = 0;
            while (n < this.snowFlakes.size()) {
                this.snowFlakes.get(n).display();
                ++n;
            }
        }
        if (this.time > this.phase5Time && this.time < this.phase6Time) {
            this.tunnel.display();
        }
        this.popMatrix();
        if (this.time > this.beam1EnterTime) {
            this.pushMatrix();
            n = 0;
            while (n < this.beams.size()) {
                this.beams.get(n).display();
                ++n;
            }
            this.popMatrix();
            this.pushMatrix();
            n = 0;
            while (n < this.shards.size()) {
                this.shards.get(n).display();
                ++n;
            }
            this.popMatrix();
        }
        if (this.time > this.phase6Time) {
            this.rose.display();
        }
    }

    public void moveCamera() {
        this.rotateY(((float)this.mouseX / PApplet.parseFloat((int)this.width) - 0.5f) * (float)Math.PI);
        this.rotateX((float)this.mouseY / PApplet.parseFloat((int)this.height) * (float)Math.PI);
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.song.skip(-this.SONG_SKIP_MILLISECONDS);
            } else if (this.keyCode == 39) {
                this.song.skip(this.SONG_SKIP_MILLISECONDS);
            }
        } else if (this.key == ' ') {
            if (this.song.isPlaying()) {
                this.song.pause();
            } else {
                this.song.play();
            }
        } else if (this.key == '\n') {
            demo.print((String)(String.valueOf(this.song.position()) + ", "));
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Beam {
        int col;
        int steadyTime;
        int enterTime;
        int endTime;
        int growTime;
        int direction;
        float _length;

        Beam(int n, int n2, int n3, int n4, int n5) {
            this.col = n;
            this.steadyTime = n3;
            this.enterTime = n2;
            this.endTime = n4;
            this.direction = n5;
            this.growTime = 2000;
        }

        public void display() {
            if (demo.this.time > this.enterTime && demo.this.time < this.endTime) {
                demo.this.noFill();
                demo.this.stroke(this.col);
                this._length = 1.0f;
                if (demo.this.time < this.enterTime + this.growTime) {
                    this._length = (float)(demo.this.time - this.enterTime) / (float)this.growTime;
                }
                if (demo.this.time > this.endTime - 2000) {
                    this._length = (float)(this.endTime - demo.this.time) / 2000.0f;
                }
                float f = 0.0f;
                while (f < 1.0f) {
                    demo.this.strokeWeight(1.0f + f * 10.0f);
                    demo.this.stroke(this.col, 20.0f);
                    this.drawCurve();
                    f += 0.1f;
                }
                demo.this.strokeWeight(1.0f);
                demo.this.stroke(this.col);
                this.drawCurve();
            }
        }

        public void drawCurve() {
            demo.this.beginShape();
            float f = (float)(demo.this.time - this.steadyTime) * 0.001f * (float)this.direction;
            int n = 0;
            while (n < 4) {
                demo.this.curveVertex(demo.sin((float)((f - 0.6f * (float)n * (float)this.direction * this._length) * ((float)Math.PI * 2) / 21.0f)) * 15.0f + demo.cos((float)((f - 0.6f * (float)n * (float)this.direction * this._length) * 10.0f * ((float)Math.PI * 2) / 21.0f)) * 5.0f, demo.cos((float)((f - 0.6f * (float)n * (float)this.direction * this._length) * ((float)Math.PI * 2) / 21.0f)) * 15.0f + demo.sin((float)((f - 0.6f * (float)n * (float)this.direction * this._length) * 10.0f * ((float)Math.PI * 2) / 21.0f)) * 5.0f);
                ++n;
            }
            demo.this.endShape();
        }
    }

    class IceTunnel {
        int segmentCount = 1200;
        float angle = 0.97389376f;

        IceTunnel() {
        }

        public void display() {
            demo.this.pushMatrix();
            float f = (float)(demo.this.time - demo.this.phase5Time) * 0.01f;
            f = demo.constrain((float)f, (float)0.0f, (float)120.0f);
            demo.this.fill(150.0f, 150.0f, 200.0f, f);
            demo.this.stroke(220.0f, 180.0f, 240.0f, f);
            demo.this.strokeWeight(4.0f);
            demo.this.rotateZ((float)(demo.this.time - demo.this.phase5Time) * 0.001f);
            int n = 0;
            while (n < this.segmentCount) {
                demo.this.translate(0.0f, 0.0f, -6.0f);
                demo.this.rotateZ(this.angle);
                demo.this.pushMatrix();
                demo.this.translate(0.0f, 30.0f, 0.0f);
                demo.this.rotateY(0.62831855f);
                demo.this.box(10.0f, 2.0f, 2.0f);
                demo.this.popMatrix();
                ++n;
            }
            demo.this.strokeWeight(1.0f);
            demo.this.popMatrix();
        }
    }

    class Rose {
        float positionX;
        float positionY;
        float positionZ;
        int startTime;
        int endTime;
        int lifeTime;
        int branches;
        int phase;
        float phaseWeight;
        float scale;
        int col;
        int strokeCol;
        float angleWeight;
        int timer;
        int fallTimer;

        Rose(float f, float f2, float f3, int n, int n2) {
            this.positionX = f;
            this.positionY = f2;
            this.positionZ = f3;
            this.startTime = n;
            this.endTime = n2;
            this.timer = this.startTime + 8000;
            this.branches = 27;
            this.lifeTime = this.endTime - this.startTime;
            this.scale = 1.0f;
            this.col = demo.this.color(100, 100, 200);
            this.strokeCol = demo.this.color(200, 255, 255);
            this.fallTimer = demo.this.songEndTime - this.endTime - 500;
        }

        public void display() {
            float f;
            demo.this.noStroke();
            this.col = demo.this.color(100, 100, 200);
            this.scale = 1.0f;
            this.angleWeight = 1.0f;
            if (demo.this.time < this.startTime + 6000) {
                this.scale = (float)(demo.this.time - this.startTime) / 6000.0f;
            }
            if (demo.this.time < this.startTime + 8000) {
                this.angleWeight = (float)(demo.this.time - this.startTime) / 8000.0f;
            } else {
                this.angleWeight = demo.sin((float)((float)(demo.this.time - this.timer) * 0.001f * 0.1f * (float)Math.PI + 1.5707964f)) * 0.3f + 0.7f;
                this.col = demo.this.color(100.0f + 20.0f * (float)(demo.this.time - this.timer) / 3000.0f, 100.0f - 100.0f * (float)(demo.this.time - this.timer) / 3000.0f, 200.0f - 200.0f * (float)(demo.this.time - this.timer) / 3000.0f);
                this.strokeCol = demo.this.color(200.0f + 55.0f * (float)(demo.this.time - this.timer) / 3000.0f, 255.0f - 50.0f * (float)(demo.this.time - this.timer) / 3000.0f, 255.0f - 30.0f * (float)(demo.this.time - this.timer) / 3000.0f);
            }
            this.phase = 30;
            this.phaseWeight = 0.0f;
            if (demo.this.time > this.endTime) {
                f = (float)(demo.this.time - this.endTime) / (float)this.fallTimer * (float)(this.branches + 1);
                this.phase = demo.floor((float)f);
                this.phaseWeight = f - (float)this.phase;
                this.phase = this.branches - this.phase;
            }
            demo.this.fill(this.col);
            f = (float)(demo.this.time - this.startTime) * 0.001f;
            demo.this.pushMatrix();
            demo.this.scale(2.0f);
            demo.this.scale(this.scale);
            demo.this.rotateX(0.62831855f);
            demo.this.rotateY(f * 0.02f * ((float)Math.PI * 2));
            int n = 0;
            while (n < this.branches) {
                float f2 = 1.0f;
                float f3 = 0.0f;
                if (n == this.phase) {
                    f2 = 1.0f - this.phaseWeight;
                    f3 = -40.0f * this.phaseWeight;
                }
                if (n <= this.phase) {
                    demo.this.pushMatrix();
                    demo.this.rotateY(1.3194689f * (float)n);
                    demo.this.translate(0.0f, -0.5f * (float)n + f3, 0.1f * (float)n);
                    demo.this.rotateX(0.0439823f * (0.25f + this.angleWeight * 0.75f) * (float)n * f2);
                    demo.this.scale(0.3f + 0.07f * (float)n);
                    this.drawPetal();
                    demo.this.popMatrix();
                }
                ++n;
            }
            demo.this.popMatrix();
        }

        public void drawPetal() {
            demo.this.noStroke();
            demo.this.beginShape(17);
            demo.this.vertex(0.0f, 0.0f, 0.0f);
            demo.this.vertex(-5.0f, 3.0f, 2.0f);
            demo.this.vertex(0.0f, 3.0f, 3.0f);
            demo.this.vertex(0.0f, 0.0f, 0.0f);
            demo.this.vertex(-5.0f, 3.0f, 2.0f);
            demo.this.vertex(-6.0f, 6.0f, 3.0f);
            demo.this.vertex(0.0f, 6.0f, 4.0f);
            demo.this.vertex(0.0f, 3.0f, 3.0f);
            demo.this.vertex(-6.0f, 6.0f, 3.0f);
            demo.this.vertex(-6.0f, 10.0f, 3.0f);
            demo.this.vertex(0.0f, 10.0f, 4.0f);
            demo.this.vertex(0.0f, 6.0f, 4.0f);
            demo.this.vertex(-6.0f, 10.0f, 3.0f);
            demo.this.vertex(-4.0f, 12.0f, 1.0f);
            demo.this.vertex(0.0f, 12.0f, 2.0f);
            demo.this.vertex(0.0f, 10.0f, 4.0f);
            demo.this.vertex(0.0f, 0.0f, 0.0f);
            demo.this.vertex(0.0f, 3.0f, 3.0f);
            demo.this.vertex(5.0f, 3.0f, 2.0f);
            demo.this.vertex(0.0f, 0.0f, 0.0f);
            demo.this.vertex(0.0f, 3.0f, 3.0f);
            demo.this.vertex(0.0f, 6.0f, 4.0f);
            demo.this.vertex(6.0f, 6.0f, 3.0f);
            demo.this.vertex(5.0f, 3.0f, 2.0f);
            demo.this.vertex(0.0f, 6.0f, 4.0f);
            demo.this.vertex(0.0f, 10.0f, 4.0f);
            demo.this.vertex(6.0f, 10.0f, 3.0f);
            demo.this.vertex(6.0f, 6.0f, 3.0f);
            demo.this.vertex(0.0f, 10.0f, 4.0f);
            demo.this.vertex(0.0f, 12.0f, 2.0f);
            demo.this.vertex(4.0f, 12.0f, 1.0f);
            demo.this.vertex(6.0f, 10.0f, 3.0f);
            demo.this.endShape();
            demo.this.stroke(this.strokeCol);
            demo.this.line(-6.0f, 10.0f, 3.0f, -4.0f, 12.0f, 1.0f);
            demo.this.line(-4.0f, 12.0f, 1.0f, 0.0f, 12.0f, 2.0f);
            demo.this.line(0.0f, 12.0f, 2.0f, 4.0f, 12.0f, 1.0f);
            demo.this.line(4.0f, 12.0f, 1.0f, 6.0f, 10.0f, 3.0f);
        }
    }

    class Shard {
        float positionX;
        float positionY;
        int startTime;
        int endTime;
        int lifeTime;
        int vanishTime;
        float angle;
        float startLength;
        float phaseWeight;
        int phase;
        float scale;
        int branches;
        float endingWeight;

        Shard(float f, float f2, int n, int n2) {
            this.positionX = f;
            this.positionY = f2;
            this.startTime = n;
            this.endTime = n2;
            this.vanishTime = this.endTime + 2000;
            this.angle = (float)this.startTime % 623.0f / 623.0f * 1.5707964f + 0.31415927f;
            this.branches = this.startTime % 3 + 7;
            this.startLength = 5.0f;
            this.lifeTime = 2000;
            this.scale = (float)this.startTime % 391.0f / 391.0f * 0.1f + 0.2f;
        }

        public void display() {
            if (demo.this.time > this.startTime && demo.this.time < this.vanishTime) {
                float f = (float)(demo.this.time - this.startTime) / (float)this.lifeTime * (float)(this.branches + 1);
                this.phase = demo.floor((float)f);
                this.phaseWeight = f - (float)this.phase;
                this.endingWeight = 1.0f;
                if (demo.this.time > this.endTime) {
                    this.endingWeight = 1.0f - (float)(demo.this.time - this.endTime) / 2000.0f;
                }
                float f2 = this.startLength * this.phaseWeight * this.endingWeight;
                demo.this.pushMatrix();
                demo.this.translate(this.positionX, this.positionY);
                demo.this.rotateX(this.angle * this.scale * (float)(demo.this.time - demo.this.phase2Time) * 2.0E-4f);
                demo.this.rotateY(this.angle * (float)this.branches * (float)(demo.this.time - demo.this.phase2Time) * 2.0E-4f);
                demo.this.scale(this.scale);
                demo.this.fill(100.0f, 100.0f, 155.0f, 150.0f);
                demo.this.stroke(200.0f + (1.0f - this.endingWeight) * 55.0f, 210.0f - (1.0f - this.endingWeight) * 200.0f, 255.0f - (1.0f - this.endingWeight) * 200.0f, 200.0f);
                demo.this.strokeWeight(1.0f);
                int n = 0;
                while (n < this.branches) {
                    demo.this.pushMatrix();
                    demo.this.rotateY((float)Math.PI * 2 * (float)n / (float)this.branches * 2.61f);
                    demo.this.rotateZ((float)Math.PI * (0.3f + 0.3f * (float)n));
                    demo.this.translate(0.0f, (1.0f - this.endingWeight) * -40.0f, 0.0f);
                    if (this.phase == n) {
                        this.drawCrystal(f2 / ((float)n * 0.1f + 1.0f));
                    } else if (this.phase > n) {
                        this.drawCrystal(this.startLength * this.endingWeight / ((float)n * 0.1f + 1.0f));
                    }
                    demo.this.popMatrix();
                    ++n;
                }
                demo.this.popMatrix();
            }
        }

        public void drawCrystal(float f) {
            demo.this.pushMatrix();
            demo.this.scale(f);
            demo.this.beginShape(9);
            int n = 0;
            while (n < 4) {
                demo.this.vertex(0.0f, 0.0f, 0.0f);
                demo.this.vertex(demo.sin((float)((float)n * 0.25f * ((float)Math.PI * 2))), -3.0f, demo.cos((float)((float)n * 0.25f * ((float)Math.PI * 2))));
                demo.this.vertex(demo.sin((float)((float)(n + 1) * 0.25f * ((float)Math.PI * 2))), -3.0f, demo.cos((float)((float)(n + 1) * 0.25f * ((float)Math.PI * 2))));
                demo.this.vertex(0.0f, -6.0f, 0.0f);
                demo.this.vertex(demo.sin((float)((float)n * 0.25f * ((float)Math.PI * 2))), -3.0f, demo.cos((float)((float)n * 0.25f * ((float)Math.PI * 2))));
                demo.this.vertex(demo.sin((float)((float)(n + 1) * 0.25f * ((float)Math.PI * 2))), -3.0f, demo.cos((float)((float)(n + 1) * 0.25f * ((float)Math.PI * 2))));
                ++n;
            }
            demo.this.endShape();
            demo.this.popMatrix();
        }
    }

    class SnowFlake {
        float positionX;
        float positionY;
        float positionZ;
        int startTime;
        int endTime;
        int lifeTime;
        float angle;
        int branches;
        int maxDepth;
        float startLength;
        int phase;
        float phaseWeight;
        float scale;

        SnowFlake(float f, float f2, float f3, int n, int n2) {
            this.positionX = f;
            this.positionY = f2;
            this.positionZ = f3;
            this.startTime = n;
            this.endTime = n2;
            this.angle = (float)this.startTime % 623.0f / 623.0f * 1.5707964f + 0.31415927f;
            this.branches = this.startTime % 3 + 4;
            this.maxDepth = this.startTime % 2 + 2;
            this.startLength = 5.0f;
            this.lifeTime = this.endTime - this.startTime;
            this.scale = (float)this.startTime % 391.0f / 391.0f * 0.5f + 0.5f;
        }

        public void display() {
            if (demo.this.time > this.startTime) {
                float f = (float)(demo.this.time - this.startTime) / (float)this.lifeTime * (float)(this.maxDepth + 1);
                this.phase = demo.floor((float)f);
                this.phaseWeight = f - (float)this.phase;
                float f2 = this.startLength;
                if (this.phase < 1) {
                    f2 *= this.phaseWeight;
                }
                demo.this.pushMatrix();
                if (demo.this.time > demo.this.phase2Time) {
                    demo.this.rotateX(this.angle * (float)this.maxDepth * (float)(demo.this.time - demo.this.phase2Time) * 2.0E-4f);
                    demo.this.rotateY(this.angle * (float)this.branches * (float)(demo.this.time - demo.this.phase2Time) * 2.0E-4f);
                }
                demo.this.translate(this.positionX, this.positionY, this.positionZ);
                demo.this.scale(this.scale, this.scale, this.scale);
                if (demo.this.time > this.endTime) {
                    demo.this.rotateZ(this.angle * (float)(demo.this.time - this.endTime) * 0.001f);
                }
                demo.this.fill(200.0f, 210.0f, 255.0f);
                demo.this.stroke(200.0f, 210.0f, 255.0f);
                demo.this.ellipse(0.0f, 0.0f, 1.0f, 1.0f);
                this.drawFlake(f2);
                if (demo.this.time > demo.this.pulseTime) {
                    demo.this.noFill();
                    float f3 = (float)(demo.this.time - this.startTime) * 0.001f;
                    float f4 = 0.0f;
                    while (f4 < demo.sin((float)(f3 * (float)Math.PI)) * 2.0f) {
                        demo.this.strokeWeight(1.0f + f4 * 10.0f);
                        demo.this.stroke(200.0f, 210.0f, 255.0f, 40.0f);
                        demo.this.ellipse(0.0f, 0.0f, 1.0f + f4 * 10.0f, 1.0f + f4 * 10.0f);
                        this.drawFlake(f2);
                        f4 += 0.2f;
                    }
                    demo.this.strokeWeight(1.0f);
                }
                demo.this.popMatrix();
            }
        }

        public void drawFlake(float f) {
            demo.this.pushMatrix();
            int n = 0;
            while (n < this.branches) {
                demo.this.line(0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f);
                demo.this.pushMatrix();
                demo.this.translate(this.startLength, 0.0f, 0.0f);
                this.drawBranch(0, this.startLength * 0.6f);
                demo.this.popMatrix();
                demo.this.rotateZ((float)Math.PI * 2 / (float)this.branches);
                ++n;
            }
            demo.this.popMatrix();
        }

        public void drawBranch(int n, float f) {
            float f2 = f;
            if (this.phase == n + 1) {
                f2 *= this.phaseWeight;
            }
            if (n < this.maxDepth && this.phase > n) {
                demo.this.pushMatrix();
                demo.this.rotateZ(this.angle);
                int n2 = 0;
                while (n2 < 3) {
                    demo.this.line(0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f);
                    demo.this.pushMatrix();
                    demo.this.translate(f, 0.0f, 0.0f);
                    this.drawBranch(n + 1, f * 0.6f);
                    demo.this.popMatrix();
                    demo.this.rotateZ(-this.angle);
                    ++n2;
                }
                demo.this.popMatrix();
            }
        }
    }
}

