/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class TTCHeader {
    public static final int ttcf = 1953784678;
    private int ttcTag;
    private int version;
    private int directoryCount;
    private int[] tableDirectory;
    private int dsigTag;
    private int dsigLength;
    private int dsigOffset;

    public TTCHeader(DataInput dataInput) throws IOException {
        this.ttcTag = dataInput.readInt();
        this.version = dataInput.readInt();
        this.directoryCount = dataInput.readInt();
        this.tableDirectory = new int[this.directoryCount];
        for (int i = 0; i < this.directoryCount; ++i) {
            this.tableDirectory[i] = dataInput.readInt();
        }
        if (this.version == 65536) {
            this.dsigTag = dataInput.readInt();
        }
        this.dsigLength = dataInput.readInt();
        this.dsigOffset = dataInput.readInt();
    }

    public int getDirectoryCount() {
        return this.directoryCount;
    }

    public int getTableDirectory(int n) {
        return this.tableDirectory[n];
    }

    public static boolean isTTC(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        return n == 1953784678;
    }
}

