/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import java.util.Arrays;

public class MoogFilter
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput frequency = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput resonance = new UGen.UGenInput(UGen.InputType.CONTROL);
    public Type type;
    private float[][] coeff;

    public MoogFilter(float f, float f2) {
        this(f, f2, Type.LP);
    }

    public MoogFilter(float f, float f2, Type type) {
        this.type = type;
        this.frequency.setLastValue(f);
        this.resonance.setLastValue(this.constrain(f2, 0.0f, 1.0f));
        this.coeff = new float[this.channelCount()][5];
    }

    @Override
    protected void channelCountChanged() {
        if (this.coeff == null || this.coeff.length != this.channelCount()) {
            this.coeff = new float[this.channelCount()][5];
        }
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float f = this.frequency.getLastValue() / (this.sampleRate() * 0.5f);
        float f2 = this.constrain(this.resonance.getLastValue(), 0.0f, 1.0f);
        float f3 = 1.0f - f;
        float f4 = f + 0.8f * f * f3;
        float f5 = f4 + f4 - 1.0f;
        f3 = f2 * (1.0f + 0.5f * f3 * (1.0f - f3 + 5.6f * f3 * f3));
        float[] fArray2 = this.audio.getLastValues();
        block5: for (int i = 0; i < this.channelCount(); ++i) {
            float[] fArray3 = this.coeff[i];
            float f6 = this.constrain(fArray2[i], -1.0f, 1.0f);
            float f7 = fArray3[1];
            fArray3[1] = ((f6 -= f3 * fArray3[4]) + fArray3[0]) * f4 - fArray3[1] * f5;
            float f8 = fArray3[2];
            fArray3[2] = (fArray3[1] + f7) * f4 - fArray3[2] * f5;
            f7 = fArray3[3];
            fArray3[3] = (fArray3[2] + f8) * f4 - fArray3[3] * f5;
            fArray3[4] = (fArray3[3] + f7) * f4 - fArray3[4] * f5;
            fArray3[4] = fArray3[4] - fArray3[4] * fArray3[4] * fArray3[4] * 0.166667f;
            if (Float.isNaN(fArray3[4])) {
                Arrays.fill(fArray3, 0.0f);
            }
            fArray3[0] = f6;
            switch (this.type) {
                case HP: {
                    fArray[i] = f6 - fArray3[4];
                    continue block5;
                }
                case LP: {
                    fArray[i] = fArray3[4];
                    continue block5;
                }
                case BP: {
                    fArray[i] = 3.0f * (fArray3[3] - fArray3[4]);
                }
            }
        }
    }

    private float constrain(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static enum Type {
        HP,
        LP,
        BP;

    }
}

