/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import ddf.minim.UGen;

public abstract class IIRFilter
extends UGen
implements AudioEffect {
    public final UGen.UGenInput audio;
    public final UGen.UGenInput cutoff;
    protected float[] a;
    protected float[] b;
    private float[][] in;
    private float[][] out;
    private float prevCutoff;

    public IIRFilter(float f, float f2) {
        this.setSampleRate(f2);
        this.audio = new UGen.UGenInput(UGen.InputType.AUDIO);
        this.cutoff = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.cutoff.setLastValue(f);
        this.prevCutoff = -1.0f;
    }

    private final void initArrays(int n) {
        int n2 = this.a.length >= this.b.length ? this.a.length : this.b.length;
        this.in = new float[n][n2];
        this.out = new float[n][n2];
    }

    @Override
    public final synchronized void uGenerate(float[] fArray) {
        if (this.cutoff.getLastValue() != this.prevCutoff) {
            this.calcCoeff();
            this.prevCutoff = this.cutoff.getLastValue();
        }
        if (this.in == null || this.in.length < fArray.length || this.in[0].length < this.a.length && this.in[0].length < this.b.length) {
            this.initArrays(fArray.length);
        }
        for (int i = 0; i < fArray.length; ++i) {
            int n;
            System.arraycopy(this.in[i], 0, this.in[i], 1, this.in[i].length - 1);
            this.in[i][0] = this.audio.getLastValues()[i];
            float f = 0.0f;
            for (n = 0; n < this.a.length; ++n) {
                f += this.a[n] * this.in[i][n];
            }
            for (n = 0; n < this.b.length; ++n) {
                f += this.b[n] * this.out[i][n];
            }
            System.arraycopy(this.out[i], 0, this.out[i], 1, this.out[i].length - 1);
            this.out[i][0] = f;
            fArray[i] = f;
        }
    }

    @Override
    public final synchronized void process(float[] fArray) {
        this.setChannelCount(1);
        float[] fArray2 = new float[1];
        for (int i = 0; i < fArray.length; ++i) {
            this.audio.setLastValue(fArray[i]);
            this.uGenerate(fArray2);
            fArray[i] = fArray2[0];
        }
    }

    @Override
    public final synchronized void process(float[] fArray, float[] fArray2) {
        this.setChannelCount(2);
        float[] fArray3 = new float[2];
        for (int i = 0; i < fArray.length; ++i) {
            this.audio.getLastValues()[0] = fArray[i];
            this.audio.getLastValues()[1] = fArray2[i];
            this.uGenerate(fArray3);
            fArray[i] = fArray3[0];
            fArray2[i] = fArray3[1];
        }
    }

    public final void setFreq(float f) {
        if (this.validFreq(f) && f != this.cutoff.getLastValue()) {
            this.prevCutoff = f;
            this.cutoff.setLastValue(f);
            this.calcCoeff();
        }
    }

    public boolean validFreq(float f) {
        return f > 0.0f;
    }

    public final float frequency() {
        return this.cutoff.getLastValue();
    }

    protected abstract void calcCoeff();

    public final void printCoeff() {
        int n;
        System.out.println("Filter coefficients: ");
        if (this.a != null) {
            for (n = 0; n < this.a.length; ++n) {
                System.out.print("  A" + n + ": " + this.a[n]);
            }
        }
        System.out.println();
        if (this.b != null) {
            for (n = 0; n < this.b.length; ++n) {
                System.out.print("  B" + (n + 1) + ": " + this.b[n]);
            }
            System.out.println();
        }
    }
}

