//text mode framework by musk
//
//use 8x8 fonts for console (that looks the BEST)
//all gfx routines are UNSAFE
//MyGfx.h - gfx routines on a 320x200 32-bit framebuffer (putpixel, line)
//you are to write your own gfx routines, only the basics are provided.
//ConsoleScreen.h - is responsible for textmode output
//TmdcGfx.h - is responsible for conversion from RGB to TextMode
//Effects.h - we have the graphics effects here
//conversion is doe using a Look Up Table
//the LUT takes time to calculate
//however it's set to create a 64kb cache file


//these constants are taken from windows
#define VK_ESCAPE         0x1B
#define VK_LEFT           0x25
#define VK_UP             0x26
#define VK_RIGHT          0x27
#define VK_DOWN           0x28

//functions for keyboard check in cosole
#include <conio.h>
//standard input output
#include <stdio.h>
//standard math functions
#include <math.h>
//functions used for timing, clock()
#include <time.h>
//our little converter
#include "TmdcGfx.h"
//our audio playback module
#include "Music.h"
//our demo effects
#include "Effects.h"

void dbp(int x, int y, int s, TmdcGfx* gfx);
void dscroller(int x, int y, TmdcGfx* gfx);

int main() //win32 console project
{
	//this is your gfx class, it's a mess...
	//your project needs to be "console project"
	//and this class can only work on that single console
	TmdcGfx gfx;

	gfx.SetConsoleWindowTitle("text mode Gfx framework");

  //the init function will start the precalc for the look-up-table
  //the conversion can be done in realtime because of the look-up-table
	//it's a bruteforce algorithm and might take some time
	gfx.Init();
	gfx.bAntiAlias=true;
	gfx.bDither=true;

	//some post processing parameters
	//use them sparingly, like spice (or go crazy!)

	//a negative sharpening factor does a blur
	gfx.SetSharpen(+0.80);

	//color correction rgb curves
	// put 0 everywhere for the standard colors
	gfx.SetRed  (-0.0,+0.0,-0.0,+0.0,-0.0);
	gfx.SetGreen(-0.0,0.05,+0.1,+0.2,-0.0);
	gfx.SetBlue (-0.0,+0.0,-0.0,+0.0,-0.0);
	
	//color brightnessness AMPLIFY!
	gfx.SetBrighten(+0.3);
	//darkens stuff, makes more black appear
	gfx.SetDarken(+0.1);

  //notify the viewer to enter fullscreen
  printf("set character mode to 8x8 for windowed\npress alt+enter for fullscreen (if <= winXP)\npress enter to continue\n");
  getch();

  //start the music
  MusicInit("../Data/mu6k-chipjet_final.it");
  MusicPlay();

	//okay, here comes the main loop	                      
	bool bFinished=0;
	while (!bFinished)
	{
		//simple esc keycheck using functions from conio.h
		if (kbhit())
		{
			char Key = getch();
			if (Key == VK_ESCAPE) bFinished=true;
      //we also need a way to switch position during debug

      //enable the following 2 lines for debug
      //if (Key == 0x4b) MusicSetModOrder(MusicGetModOrder()-1);
      //if (Key == 0x4d) MusicSetModOrder(MusicGetModOrder()+1);
		}

    char* message0 = "hello function 2014\nI'm musk / brainstorm\n     awesome party isn't it?\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\
this is an open source textmode framework\nand I unofficially invite you to TMDC\n\n\
the source contains comments and is easy to understand!\n\
                         so there is no reason to wait!!!";

    //I'm using a switch statement to implement different parts of the demo
    //each part is an effect and is implemented in effects.cpp
    switch (MusicGetModOrder())
    {
    case 0:
      FXfadeIn(gfx);
		  gfx.DoBuildIntermediate(); // downscale 320x200 to 80x50
      gfx.DoPostProcess();       // apply post processing
      gfx.DoConvertToText();     // convert to textmode
      FXintroMessage(gfx,10,10,message0); //we show text messages after the conversion to textmode has been done
      gfx.DoOutputToConsole(); //sends the framebuffer to the console
      break;
    case 1:
      FXfadeIn(gfx);
		  gfx.DoBuildIntermediate();
      gfx.DoPostProcess();
      FXtitleBitmap(-1,15,1,gfx); // draw the colorful textmode logo
		  gfx.DoConvertToText();       
      FXintroMessage(gfx,10,10,message0);
      gfx.DoOutputToConsole();	
      break;
    case 2:
      FXpzoomer(gfx,false);
		  gfx.DoBuildIntermediate();
      gfx.DoPostProcess();
      FXtitleBitmap(19,0,0,gfx); // draw the colorful textmode logo
		  gfx.DoConvertToText();                              
      FXintroMessage(gfx,10,46,"now you can convert RGB to TextMode!! without any effort!!\nand play music without effort!!"); //the text scroller
      //gfx.PutCharConsole(0,MusicGetModOrder(),MusicGetModOrder()+'0',0xf0);
	    gfx.DoOutputToConsole();	
      break;    
    case 3:
      FXpzoomer(gfx,true);
      gfx.DoTheMagic();
      break;
    case 4:      
    case 5:
      FXrectangles(gfx,MusicGetModRow());
      gfx.DoTheMagic();
      break;

    case 6:
      FXspheres(gfx);
      gfx.DoTheMagic();
      break;
      
    case 7:
      FXspheres(gfx);    
		  gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      FXintroMessage(gfx,10,10,"Raymarching LOL!\n                 \n          \n         \
                               \n\n\n\n\n\n\n\n                          \n\n\n\n  \nCRAAAaaaaaaaaASH!!");
	    gfx.DoOutputToConsole();	
      break;

    case 8:
    case 9:     
      FXinterference(gfx);
      gfx.DoTheMagic();
      break;
    case 10:
    case 11:
      FXcube(gfx);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      FXintroMessage(gfx,2,2,"rubber cube challenge accepted!!!");
	    gfx.DoOutputToConsole();	
      break;
    case 12:
    case 13:
      FXtunnel(gfx);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      FXintroMessage(gfx,32,24,"    good demo\nneeds good tunnel!");
	    gfx.DoOutputToConsole();	
      break;
    case 14:
      FXtunnel(gfx);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      FXintroMessage(gfx,32,24,"    a long one,\na very long tunnel!");
	    gfx.DoOutputToConsole();	
      break;
    case 15:
      FXtunnel(gfx);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      FXintroMessage(gfx,31,24,"a tunnel longer than\n the revision tunnel!");
	    gfx.DoOutputToConsole();	
      break;     
    case 16:
    case 17:
      FXzoom(gfx);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      gfx.DoOutputToConsole();	
      break;    
    case 18:    
    case 19:
      FXrectangles(gfx,MusicGetModRow());                              
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                                                                      
      FXintroMessage(gfx,2,2,"24bit RGB in Textmode!");
      gfx.DoOutputToConsole();	
		  break;
    case 20:
    case 21:
    case 22:
      FXsphere(gfx,false);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
	    gfx.DoConvertToText();                                                                      
      gfx.DoOutputToConsole();	
      break;
    default:
       FXsphere(gfx,true);
      gfx.DoBuildIntermediate();
      gfx.DoPostProcess();    
		  gfx.DoConvertToText();                    
      FXintroMessage(gfx,2,2,"So yeah!, this is our new textmode demo\n\n\
this is O P E N   S O U R C E ! ! !\n\n\
if you're a coder, you can download this and edit it\n\n\
there are plenty of comments and it's easy to understand\n\n\n\
I hope to see more entries in the upcoming TMDC compo!\n\n\n\
This demo was 100% party coded!     \n\n\
As you can see not as awesome towards the end \n\n\
I was starting to get tired...               \n\n\n\
Anyways, enjoy the rest of the demoparty!               \n\n\
Hey organizers! You can turn this off now and put on a lamer demo!\n\n\
Forcing system reboot in                    \n\n\
 5                                \n\n\
 4                                \n\n\
 3                                \n\n\
 2                                \n\n\
 1                                \n\n\
Oh yeah!, Credits!                   \n\n\
Everything dome by musk/brainstorm! \n\n\
No AMIGAs were harmed during the making of this demo!",0x0f); //the text scroller                                                         
      gfx.DoOutputToConsole();
    }

	}
	//done? enable compiler optimisations, compile... enjoy!
}

