/*

--------
|SKRUZD|
--------

The MIT License

Copyright (c) 2006 Inko Illarramendi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


#include <crystalspace.h>

#include <physicallayer/entity.h>
#include <physicallayer/propclas.h>
#include <propclass/linmove.h>
#include <propclass/prop.h>
#include <propclass/trigger.h>
#include <propclass/region.h>

#include <propclass/tooltip.h>
#include <propclass/timer.h>
#include <propclass/move.h>
#include <propclass/input.h>
#include <propclass/solid.h>
#include <propclass/colldet.h>

#include "behave.h"
#include "bweapon.h"
#include "bspawner.h"
#include "bshoot.h"
#include "blevel.h"
#include "bplayer.h"
#include "bbad.h"


SCF_IMPLEMENT_IBASE (BehaviourLayer)
SCF_IMPLEMENTS_INTERFACE (iCelBlLayer)
SCF_IMPLEMENT_IBASE_END


///This is the common superclass for the behaviours. It will be
///responsible to  create the independent behaviours for the entities.
BehaviourLayer::BehaviourLayer (iCelPlLayer* pl)
{
    SCF_CONSTRUCT_IBASE (0);
    BehaviourLayer::pl = pl;
}

BehaviourLayer::~BehaviourLayer ()
{
    SCF_DESTRUCT_IBASE ();
}

iCelBehaviour* BehaviourLayer::CreateBehaviour (iCelEntity* entity,
        const char* name)
{/// We create the classes depending of the behaviour we want.
    iCelBehaviour* behave = 0;
    if (!strcmp (name, "level_behave"))
        behave = new BehaviourLevel (entity, this, pl);
    else if (!strcmp (name, "player_behave"))
        behave = new BehaviourPlayer (entity, this, pl);
    else if (!strcmp (name, "bad_behave"))
        behave = new BehaviourBad (entity, this, pl);
    else if (!strcmp (name, "weapon_behave"))
        behave = new BehaviourWeapon (entity, this, pl);
    else if (!strcmp (name, "shoot_behave"))
        behave = new BehaviourShoot (entity, this, pl);
    else if (!strcmp (name, "spawn_behave"))
        behave = new BehaviourSpawner (entity, this, pl);

    if (behave)
    {
        entity->SetBehaviour (behave);
        // There is now a reference in the entity. We destroy
        // our own reference here.
        behave->DecRef ();
    }
    return behave;
}

SCF_IMPLEMENT_IBASE (BehaviourCommon)
SCF_IMPLEMENTS_INTERFACE (iCelBehaviour)
SCF_IMPLEMENT_IBASE_END

BehaviourCommon::BehaviourCommon (iCelEntity* entity, BehaviourLayer* bl, iCelPlLayer* pl, MainApp* app)
{
    SCF_CONSTRUCT_IBASE (0);
    BehaviourCommon::app = app;
    BehaviourCommon::entity = entity;
    BehaviourCommon::bl = bl;
    BehaviourCommon::pl = pl;
}

BehaviourCommon::~BehaviourCommon ()
{
    SCF_DESTRUCT_IBASE ();
}

bool BehaviourCommon::SendMessage (const char* msg_id,
                                   iCelPropertyClass* pc,
                                   celData& ret, iCelParameterBlock* params, ...)
{
    va_list arg;
    va_start (arg, params);
    bool rc = SendMessageV (msg_id, pc, ret, params, arg);
    va_end (arg);

    return rc;
}

bool BehaviourCommon::SendMessageV (const char* msg_id,
                                    iCelPropertyClass* pc,
                                    celData& ret, iCelParameterBlock* params, va_list arg)
{
    csStringID id = pl->FetchStringID (msg_id);
    return SendMessage (id, pc, ret, params, arg);
}

bool BehaviourCommon::SendMessage (csStringID,
                                   iCelPropertyClass*,
                                   celData&, iCelParameterBlock*, va_list)
{
    return false;
}
