/*

--------
|SKRUZD|
--------

The MIT License

Copyright (c) 2006 Inko Illarramendi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef APP_H
#define APP_H

#include <physicallayer/entity.h>
#include <physicallayer/pl.h>

/*
 * Our main application class inherits from csApplicationFramework
 * and csBaseEventHandler.
 */
class MainApp : public csApplicationFramework,
            public csBaseEventHandler
{
private:
    // References to modules from Crystal Space.
    csRef<iGraphics3D> g3d;
    csRef<iGraphics2D> g2d;
    csRef<iEngine> engine;
    csRef<iLoader> loader;
    csRef<iVFS> vfs;
    csRef<iVirtualClock> vc;
    csRef<iKeyboardDriver> kbd;

    // References to modules from Crystal Entity Layer.
    csRef<iCelPlLayer> pl;
    csRef<iCelBlLayer> bl;

    // Our level and player entity.
    csRef<iCelEntity> level_entity;
    csRef<iCelEntity> player_entity;

    // Menu
    csRef<iCelEntity> menu_entity;
 	csRef<iPluginManager> plugin_mgr;

    // sound system
    csRef<iSndSysRenderer> sndrdr;
    csRef< iSndSysSource > sndsrc;
    csRef<iSndSysWrapper> w_music;

    // to print a pixmap
    csSimplePixmap* pixmap;

    //Game status: "game 2", "menu 1", "exit 0"
    long int status;

    // Inherited from csBaseEventHandler: handle a keyboard event.
    bool OnKeyboard (iEvent&);

    // Inherited from csBaseEventHandler: handle a single frame.
    void PreProcessFrame ();
    // Inherited from csBaseEventHandler: handle a single frame.
    void FinishFrame ();

    bool LoadLoadingMessage();

    bool LoadMenu();
    // Create the level entity and load the level in it.
    // Returns false on failure. The error has been already reported to
    // the reporter in that case.
    bool LoadLevel ();

    // Create the player.
    // Returns false on failure. The error has been already reported to
    // the reporter in that case.
    bool CreatePlayer ();

    // Create the spawner.
    // Returns false on failure. The error has been already reported to
    // the reporter in that case.
    bool CreateBad();

    // Create the weapon.
    // Returns false on failure. The error has been already reported to
    // the reporter in that case.
    bool CreateWeapon();

    // Create the music loop.
    // Returns false on failure. The error has been already reported to
    // the reporter in that case.
    bool CreateMusic();

public:

    MainApp ();
    virtual ~MainApp ();

    // Inherited from csApplicationFramework: initialization.
    virtual bool OnInitialize (int argc, char* argv[]);

    // Inherited from csApplicationFramework: initialization.
    virtual bool Application ();

};

#endif
