        DEVICE  ZXSPECTRUM128

                org     #6400

VPage           equ     #01af
VConfig         equ     #00af
XOffsL          equ     #02af
XOffsH          equ     #03af
RAMPage3        equ     #13af
FMAddr          equ     #15af
SysConfig       equ     #20af

;-----------------------------------------
startCode
 ld sp,$5Fe0
;ABSPOS equ $6100
sqrtab equ $6100

; ld hl,ABSPOS
;lut1:
; LD A,L:BIT 7,A:JR Z,DROK
; NEG
;DROK: LD (HL),A
; INC L:JR NZ,lut1

 ld hl,sqrtab
lut2:
 push hl
 ld e,l,h,l
 call mul_he
 ex de,hl
 pop hl
 ld (hl),e:inc h
 ld (hl),d:dec h
 inc l:jr nz,lut2

 DI
 ld sp,$5EE0
 LD A,#5E,I,A:IM 2
 LD HL,INTVEC,(#5EFF),HL
 ei
;        ld      bc,SysConfig      ; 砥 14Mhz
;        ld      a,%00000010
;        out     (c),a

        ld a,$20
       ld      bc,VPage      ; 뢠 ⥬,   稭  ...
        out     (c),a

        ld      bc,VConfig    ; 砥 ०: %01-360x288, %010-256 梥⮢
        ld      a,%11000010
        out     (c),a
runpart:
        ld      ix,0;XY
drlp1:
bank:   ld      a,#20           ;  
        cp      #29
        jp      z,stub

        ld      bc,RAMPage3     ; 砥  #20   #C000
        out     (c),a

        inc     a
        ld      (bank+1),a

        ld      c,32
        ld      hl,#bf00
drlp2:
lp1:    inc     h
        push    hl
callv1:        call pat1

        pop     hl
        set     0,h
        ld      (hl),a
        res     0,h
        ld      (hl),a
        inc     hl
        inc     ixh
        jr      nz,lp1

        dec     ixl
        dec     c
        jr      nz,drlp2
        jp      drlp1

pat4:; perfect circles        x*x + y*y
;ixl=X,ixh=Y
        ld a,ixh;x
        ld l,a
        ld h,sqrtab/256;x*x
        
        ld e,(hl):inc h
        ld d,(hl):dec h
        
        ld a,ixl,l,a;y*y
        ld a,(hl):inc h
        ld h,(hl)
        ld l,a
        add hl,de
        ld a,l
        ret

pat3:; distoreted oval  x*y + x*x + y*y
        push bc
        ld      a,ixh
        ld      h,a
        ld      e,ixl   ;y*x
        call    mul_he
        push    hl      ;y*x

        ld a,ixh;x
        ld l,a
        ld h,sqrtab/256;x*x
        
        ld e,(hl):inc h
        ld d,(hl):dec h
        
        ld      a,ixl,l,a;y*y
        ld c,(hl):inc h
        ld b,(hl);;:dec h

        pop hl
        add hl,de
        add hl,bc
        ld a,l
        pop bc:ret

pat2:; cross                  x*x - y*y
;ixl=X,ixh=Y
        ld a,ixh;x
        ld l,a
        ld h,sqrtab/256;x*x
        
        ld e,(hl):inc h
        ld d,(hl):dec h
        
        ld a,ixl,l,a;y*y
        ld a,(hl):inc h
        ld h,(hl)
        ld l,a
        ex de,hl
        or a:sbc hl,de
        ld a,l
        ret
pat1:; distorted cross  x*y + x*x - y*y
        push bc

        ld      a,ixh
        ld      h,a
        ld      e,ixl   ;y*x
        call    mul_he
        push    hl      ;y*x

        ld a,ixh;x
        ld l,a
        ld h,sqrtab/256;x*x
        
        ld e,(hl):inc h
        ld d,(hl):dec h
        
        ld      a,ixl,l,a;y*y
        ld c,(hl):inc h
        ld b,(hl);;:dec h
        
        pop hl;y*x
        
        add hl,de
        or a:sbc hl,bc
        ld a,l

        pop bc
      ret

;-----------------------------------------
;newpattern:
; ld (dev+1),de
; ld (bcv+1),bc
;np1:ld a,0:inc a:and 3:ld (np1+1),a
; ld l,a,h,0
; add hl,hl
; ld de,calctab
; add hl,de
; ld e,(hl):inc hl:ld d,(hl)
; ld (callv1+1),de
; ld a,$20,(bank+1),a
; jp runpart
calctab: dw pat1,pat3,pat2,pat4
stub:
; ld (dev+1),de
; ld (bcv+1),bc
np1:ld a,0:inc a:and 3:ld (np1+1),a
 ld l,a,h,0
 add hl,hl
 ld de,calctab
 add hl,de
 ld e,(hl):inc hl:ld d,(hl)
 ld (callv1+1),de
 ld a,$20,(bank+1),a
 jp runpart

; jr $
mkpal:
        ld      bc,FMAddr
        exx

bcv:        ld      bc,0
dev:       ld      de,0
palroll:;ei:halt

;?cntr:ld a,0:inc a:ld (cntr+1),a:or a:jr z,newpattern
;open FMAddr access from #8000
        exx
        ld      a,#18
        out     (c),a
        exx
;load CRAM
        push    bc
        push    de
        ld      ix,#8000
        ld      b,0
;HIGH:0RRrrrGG  LOW:gggBBbbb
pal:
        ld      a,c
        rlca
        jr      c,$+3
        cpl
        rlca
        rlca
        push    af
        and     %11100000
        ld      l,a
        ld      a,e
        rlca
        jr      c,$+3
        cpl
        rrca
        rrca
        rrca
        and     %00011111
        or      l
        ld      (ix),a
        inc     ix
        ld      a,d
        rlca
        jr      c,$+3
        cpl
        rrca
        and     %01111100
        ld      l,a
        pop     af
        and     %00000011
        or      l
        ld      (ix),a
        inc     ix
        dec     c
        dec     d
        dec     e
        djnz    pal

;close FMAddr
        ld      bc,FMAddr
        xor     a
        out     (c),a

        pop     de
        pop     bc

        dec     c
        ld      a,c
        cp      7
        jr      nz,$+3
        dec     c
        cp      199
        jr      nz,$+3
        dec     c
        and     $1f
        jr      nz,$+3
        dec     c

        dec     d

        dec     e
        ld      a,e
        cp      7
        jr      nz,$+3
        dec     e
        cp      199
        jr      nz,$+3
        dec     e
        and     $0f
        jr      nz,$+3
        dec     e
 ld (dev+1),de
 ld (bcv+1),bc
 ret
;        jr      palroll
;----------------------interrupt---------------------------
INTVEC  PUSH AF,BC,DE,HL,IX,IY
        EXX:PUSH AF,BC,DE,HL
        EXA:PUSH AF
        
        call mkpal
;?        call psgplay
;// kkapret - 256 byte intro - spc 4 raww orgy 2008
;thank you, pcndcj!
mus_play:
;//output to ay-ports
	ld hl,ay_data:xor a
	ld c,$FD
musout:	ld b,#ff:out (c),a
		ld b,#bf:outi
		inc a
musend:	cp 14:jr nz,musout
;// music
	ld hl,ay_data+9
	ld a,(hl):and a:jr z,$+2+1:dec (hl)
	
	ld hl,ay_data+2
	ld a,8:add (hl):ld (hl),a
	inc hl
	ld a,1:adc (hl):and #0f:ld (hl),a
	ld a,10,(musend+1),a

;// music-beat =)
timer:	ld a,24:dec a:jr nz,timer_e
		ld a,#f,(ay_data+9),a
		ld hl,#03a0,(ay_data+2),hl
		ld a,24
timer_e:	ld (timer+1),a

        POP AF:EXA
        POP HL,DE,BC,AF:EXX
        POP IY,IX,HL,DE,BC,AF
        EI:RETI
ay_data:;	//playing sound
	db #10,#0D,#A0,#03,#88,#06,#00,#38,#10,#0E,#10,#34,#00,#0E
 ld (0),a


;-----------------------------------------
;1.1 Restoring 8-bit * 8-bit Unsigned
;Input: H = Multiplier, E = Multiplicand, L = 0, D = 0
;Output: HL = Product
mul_he:
        ld      l,0
        ld      d,l
        sla     h               ; optimised 1st iteration
        jr      nc,$+3
        ld      l,e
        dup 7
        add     hl,hl           ; unroll 7 times
        jr      nc,$+3          ; ...
        add     hl,de           ; ...
        edup
        ret
;-----------------------------------------
endCode:;nop
        display /d,endCode-startCode
        SAVESNA "keft.sna", startCode
        EMPTYTRD "keft.trd" ;create empty TRD image
        SAVETRD "keft.trd","k256.C",startCode,endCode-startCode
