from bge import logic, events
import validKeys

def detectTab( ):
    keyboard = logic.keyboard
    JUST_ACTIVATED = logic.KX_INPUT_JUST_ACTIVATED

    if keyboard.events[events.TABKEY] == JUST_ACTIVATED:
        changeInput()
        
def mouseClickIp( ):
    resetSelection()
    scene = logic.getCurrentScene()
    ipT = scene.objects["TextIp"]
    ipT["active"] = True
    
def mouseClickPort( ):
    resetSelection()
    scene = logic.getCurrentScene()
    portT = scene.objects["TextPort"]
    portT["active"] = True
    
def mouseClickName( ):
    resetSelection()
    scene = logic.getCurrentScene()
    nameT = scene.objects["TextName"]
    nameT["active"] = True
    
    
def resetSelection( ):
    scene = logic.getCurrentScene()
    
    ipT = scene.objects["TextIp"]
    portT = scene.objects["TextPort"]
    nameT = scene.objects["TextName"]
    
    ipT["active"] = False
    portT["active"] = False
    nameT["active"] = False
        
def changeInput( ):
    scene = logic.getCurrentScene()
    
    ipT = scene.objects["TextIp"]
    portT = scene.objects["TextPort"]
    nameT = scene.objects["TextName"]
    
    if ipT["active"] == True:
        ipT["active"] = False
        portT["active"] = True
        
    elif portT["active"] == True:
        portT["active"] = False
        nameT["active"] = True
        
    elif nameT["active"] == True:
        nameT["active"] = False
        ipT["active"] = True


def printSelection( ):
    scene = logic.getCurrentScene()
    
    ipT = scene.objects["TextIp"]
    portT = scene.objects["TextPort"]
    nameT = scene.objects["TextName"]
    
    print(ipT["active"])
    print(portT["active"])
    print(nameT["active"])
    print("-")
    
    
def getActiveField( ):
    scene = logic.getCurrentScene()
    
    ipT = scene.objects["TextIp"]
    portT = scene.objects["TextPort"]
    nameT = scene.objects["TextName"]
    
    if ipT["active"] == True:
        return ipT
        
    elif portT["active"] == True:
        return portT
        
    elif nameT["active"] == True:
        return nameT
    
def detectKeyStroke( ):
    activeField = getActiveField()
    
    if activeField.name == "TextIp":
        keys = validKeys.validKeysIp
    elif activeField.name == "TextPort":
        keys = validKeys.validKeysPort
    elif activeField.name == "TextName":
        keys = validKeys.validKeysName
        

    key_events = logic.keyboard.events
    
    keyboard = logic.keyboard
    JUST_ACTIVATED = logic.KX_INPUT_JUST_ACTIVATED

    if keyboard.events[ events.BACKSPACEKEY ] == JUST_ACTIVATED:
        prevText = activeField["Text"]
        if len( prevText ) > 0:
            activeField["Text"] = prevText[:-1]
        return
    
    if isAtMaxLength( activeField ):
        return

    for key in key_events:
        event = key_events[ key ]
        if event == JUST_ACTIVATED and key in keys:
            prevText = activeField["Text"]

            newChar = events.EventToCharacter( key, False )
            activeField["Text"] = prevText + newChar

def isAtMaxLength( activeField ):
    if activeField.name == "TextIp":
        return len( activeField["Text"] ) >= 15
    elif activeField.name == "TextPort":
        return len( activeField["Text"] ) >= 5
    elif activeField.name == "TextName":
        return len( activeField["Text"] ) >= 16