if (typeof AnalogStick === 'undefined') {
	var AnalogStick = function(dom) {
		var id = dom.id,
			mouseDown = false,
			identifier = null,
			container = {
				size: null,
				x: null,
				y: null
			},
			active = dom.getAttribute("active") == 1 || dom.getAttribute("active") == "true",
			length = 1,
			maxLength = (Number(dom.getAttribute("maxlength")) || 1),
			atLimit = false,
			input = {
				x: null,
				y: null
			},
			limit = {
				x: 0,
				y: 0
			},
			normal = {
				x: 0,
				y: 0
			},
			circle = document.createElement("DIV"),
			getRadians = function(x, y) {
				return Math.atan2(x, -y);
			},
			getVectorFromRadians = function(radians, len) {
				len = (Number(len) || 1);
				return {
					x: Math.sin(radians) * len,
					y: -Math.cos(radians) * len
				};
			},
			getVectorLength = function(vector) {
				return Math.sqrt(Math.pow(vector.x, 2) + Math.pow(vector.y, 2));
			},
			getVectorNormalized = function(vector) {
				var len = getVectorLength(vector);
				if (len !== 0) {
					vector.x *= 1 / len;
					vector.y *= 1 / len;
				}
				return vector;
			},
			setLimit = function(x, y) {
				limit = {x: x, y: y};
			},
			setInput = function(x, y) {
				limit = {x: x, y: y};
			},
			subtractVectors = function(v1, v2) {
				return {
					x: v1.x - v2.x,
					y: v1.y - v2.y
				};
			},
			update = function(vector) {
				if (vector.x == 0 && vector.y == 0) {
					input.x = 0;
					input.y = 0;
					length = len;
					drawCircle();
					dom.onchange(input.x, input.y);
				} else if (vector.x != input.x || vector.y != input.y) {
					var diff = subtractVectors(vector, limit),
						len = getVectorLength(diff),
						radians;
					if (len >= maxLength) {
						len = maxLength;
						radians = getRadians(diff.x, diff.y);
						atLimit = true;
						input = getVectorFromRadians(radians, len);
						input.x += limit.x;
						input.y += limit.y;
					} else {
						atLimit = false;
						input.x = diff.x;
						input.y = diff.y; 
					}
					length = len;
					drawCircle();
					dom.onchange(input.x, input.y);
				}
			},
			normalizeData = function(clientX, clientY) {
				var x = clientX - container.x,
					y = clientY - container.y,
					half = container.size / 2;
				x = (x - half) / half;
				y = (y - half) / half;
				return {x: x, y: y};
			},
			flush = function() {
				input.x = null;
				input.y = null;
			},
			onchange = function(_x, _y) {
			},
			onmousedown = function(e) {
				mouseDown = true;
				update(
					normalizeData(
						e.clientX + document.body.scrollLeft,
						e.clientY+document.body.scrollTop
					)
				);
			},
			onmousemove = function(e) {
				if (mouseDown) {
					update(
						normalizeData(
							e.clientX + document.body.scrollLeft,
							e.clientY+document.body.scrollTop
						)
					);
				}
			},
			onmouseup = function(e) {
				mouseDown = false;
				update({x: 0, y: 0 });
			},
			touchstart = function(e) {
				var touchObject = e.changedTouches[0];
				if (identifier == null) {
					identifier = touchObject.identifier;
					update(
						normalizeData(
							touchObject.clientX + document.body.scrollLeft,
							touchObject.clientY + document.body.scrollTop
						)
					);
				}
				e.preventDefault();
			},
			touchmove = function(e) {
				var touchObject,
					i;
				if (identifier != null) {
					for (i = 0; i < e.changedTouches.length; i++) {
						touchObject = e.changedTouches[i];
						if (touchObject.identifier == identifier) {
							update(
								normalizeData(
									touchObject.clientX + document.body.scrollLeft,
									touchObject.clientY + document.body.scrollTop
								)
							);
						}
					}
				}
				e.preventDefault();
			},
			touchend = function(e) {
				var touchObject,
					i;
				if (identifier != null) {
					for (i = 0; i < e.changedTouches.length; i++) {
						touchObject = e.changedTouches[i];
						if (touchObject.identifier == identifier) {
							update({x: 0, y: 0 });
							identifier = null;
						}
					}
				}
				e.preventDefault();
			},
			resize = function() {
				var size = Math.min(dom.parentNode.offsetWidth, dom.parentNode.offsetHeight);
				dom.style.width = size + 'px';
				dom.style.height = size + 'px';
				container.size = size;
				container.x = dom.getPosX();
				container.y = dom.getPosY();
				drawCircle();
			},
			drawCircle = function() {
				var size = circle.offsetHeight,
					x = ((1 + input.x) / 2 * (container.size - size)),
					y = ((1 + input.y) / 2 * (container.size - size));
				circle.style.left = x + 'px';
				circle.style.top = y + 'px';
			};
		dom.appendChild(circle);
		circle.className = "thumb";
		resize();
		if (isTouch) {
			dom.addListener('touchstart', touchstart, false);
			circle.addListener('touchstart', touchstart, false);
			window.addListener('touchmove', touchmove, false);
			window.addListener('touchend', touchend, false);
			window.addListener('touchleave', function(e) { alert("left"); touchend(e); }, false);
		} else {
			dom.addListener('onmousedown', onmousedown, false);
			circle.addListener('onmousedown', onmousedown, false);
			window.addListener('onmousemove', onmousemove, false);
			window.addListener('onmouseup', onmouseup, false);
		}
		dom.input = input;
		dom.parentNode.addListener('resize', resize, false);
		window.addListener('resize', resize, false);

		dom.onchange = onchange;
		dom.flush = flush;
		return dom;
	}
}