/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.pbuffers;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.test.opengl.pbuffers.TextureRenderer;
import org.lwjgl.test.opengl.pbuffers.UniqueRenderer;
import org.lwjgl.test.opengl.pbuffers.UniqueRendererRTT;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;

public final class PbufferTest {
    private static final int TEXTURE_SIZE = 512;
    private static final int QUAD_SIZE = 64;
    private TextureRenderer texRenderer;
    private DisplayMode mode;
    private Vector2f quadPosition;
    private float texScaleX;
    private float texScaleY;
    private Vector2f quadVelocity;
    private float angle;
    private float angleRotation = 1.0f;
    private static final float MAX_SPEED = 20.0f;
    private static int texID;

    public PbufferTest(int renderMode) {
        try {
            this.mode = this.findDisplayMode(800, 600, 16);
            Display.setDisplayMode(this.mode);
            Display.create(new PixelFormat(16, 0, 0, 0, 0));
            this.glInit();
            if ((Pbuffer.getCapabilities() & 1) == 0) {
                System.out.println("No Pbuffer support!");
                System.exit(-1);
            }
            System.out.println("Pbuffer support detected. Initializing...\n");
            switch (renderMode) {
                case 1: {
                    System.out.print("Creating pbuffer with unique context...");
                    this.texRenderer = new UniqueRenderer(512, 512, texID);
                    break;
                }
                case 2: {
                    System.out.print("Creating render-to-texture pbuffer with unique context...");
                    this.texRenderer = new UniqueRendererRTT(512, 512, texID);
                }
            }
            System.out.println("OK");
            this.quadPosition = new Vector2f(100.0f, 100.0f);
            this.quadVelocity = new Vector2f(1.0f, 1.0f);
            this.texScaleX = 512.0f / (float)this.mode.getWidth();
            this.texScaleY = 512.0f / (float)this.mode.getHeight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute() {
        this.mainLoop();
        this.cleanup();
    }

    private void mainLoop() {
        while (!Keyboard.isKeyDown(1) && !Display.isCloseRequested()) {
            if (Display.isVisible()) {
                this.processKeyboard();
                this.logic();
                this.render();
            } else {
                if (Display.isDirty()) {
                    this.render();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Display.update();
            Display.sync(100);
        }
    }

    private void logic() {
        this.angle += this.angleRotation;
        if (this.angle > 360.0f) {
            this.angle -= 360.0f;
        }
        this.quadPosition.x += this.quadVelocity.x;
        this.quadPosition.y += this.quadVelocity.y;
        if (this.quadPosition.x + 64.0f >= (float)this.mode.getWidth() || this.quadPosition.x - 64.0f <= 0.0f) {
            this.quadVelocity.x *= -1.0f;
        }
        if (this.quadPosition.y + 64.0f >= (float)this.mode.getHeight() || this.quadPosition.y - 64.0f <= 0.0f) {
            this.quadVelocity.y *= -1.0f;
        }
    }

    private void render() {
        this.texRenderer.enable();
        GL11.glClear(16384);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.quadPosition.x * this.texScaleX, this.quadPosition.y * this.texScaleY, 0.0f);
        GL11.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        GL11.glVertex2i(-64, -64);
        GL11.glVertex2i(64, -64);
        GL11.glColor3f(0.0f, 0.0f, 1.0f);
        GL11.glVertex2i(64, 64);
        GL11.glVertex2i(-64, 64);
        GL11.glEnd();
        GL11.glPopMatrix();
        this.texRenderer.updateTexture();
        try {
            Display.makeCurrent();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        GL11.glClear(16384);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.quadPosition.x, this.quadPosition.y, 0.0f);
        GL11.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2i(-64, -64);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2i(64, -64);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2i(64, 64);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2i(-64, 64);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void processKeyboard() {
        Keyboard.poll();
        if (Keyboard.isKeyDown(33)) {
            try {
                Display.setDisplayMode(this.mode);
                Display.setFullscreen(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown(17)) {
            try {
                Display.setFullscreen(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown(200)) {
            this.quadVelocity.y += 0.1f;
        }
        if (Keyboard.isKeyDown(208)) {
            this.quadVelocity.y -= 0.1f;
        }
        if (Keyboard.isKeyDown(205)) {
            this.quadVelocity.x += 0.1f;
        }
        if (Keyboard.isKeyDown(203)) {
            this.quadVelocity.x -= 0.1f;
        }
        if (Keyboard.isKeyDown(78)) {
            this.angleRotation += 0.1f;
        }
        if (Keyboard.isKeyDown(74)) {
            this.angleRotation -= 0.1f;
        }
        if (this.quadVelocity.x < -20.0f) {
            this.quadVelocity.x = -20.0f;
        }
        if (this.quadVelocity.x > 20.0f) {
            this.quadVelocity.x = 20.0f;
        }
        if (this.quadVelocity.y < -20.0f) {
            this.quadVelocity.y = -20.0f;
        }
        if (this.quadVelocity.y > 20.0f) {
            this.quadVelocity.y = 20.0f;
        }
        if (this.angleRotation < 0.0f) {
            this.angleRotation = 0.0f;
        }
        if (this.angleRotation > 20.0f) {
            this.angleRotation = 20.0f;
        }
    }

    private void cleanup() {
        IntBuffer buffer = BufferUtils.createIntBuffer(1);
        buffer.put(0, texID);
        GL11.glDeleteTextures(buffer);
        this.texRenderer.destroy();
        Display.destroy();
    }

    private DisplayMode findDisplayMode(int width, int height, int bpp) throws LWJGLException {
        DisplayMode[] modes;
        for (DisplayMode mode : modes = Display.getAvailableDisplayModes()) {
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getBitsPerPixel() < bpp) continue;
            return mode;
        }
        return null;
    }

    static void initGLState(int width, int height, float color) {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D(0.0f, width, 0.0f, height);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, width, height);
        GL11.glClearColor(color, color, color, 0.0f);
    }

    private void glInit() {
        Display.setVSyncEnabled(true);
        IntBuffer buffer = BufferUtils.createIntBuffer(1);
        GL11.glGenTextures(buffer);
        texID = buffer.get(0);
        GL11.glTexEnvf(8960, 8704, 8448.0f);
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, texID);
        GL11.glTexParameteri(3553, 10242, 10496);
        GL11.glTexParameteri(3553, 10243, 10496);
        GL11.glTexParameteri(3553, 10241, 9729);
        GL11.glTexParameteri(3553, 10240, 9729);
        PbufferTest.initGLState(this.mode.getWidth(), this.mode.getHeight(), 0.0f);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            PbufferTest.kill("Invalid arguments length.");
        }
        int mode = -1;
        try {
            mode = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            PbufferTest.kill("Invalid mode.");
        }
        if (mode != 1 && mode != 2) {
            PbufferTest.kill("Invalid mode.");
        }
        System.out.println("Change between fullscreen and windowed mode, by pressing F and W respectively");
        System.out.println("Move quad using arrowkeys, and change rotation using +/-");
        PbufferTest test = new PbufferTest(mode);
        test.execute();
        System.exit(0);
    }

    private static void kill(String msg) {
        System.out.println(msg);
        System.out.println("-------");
        System.out.println("Usage: java org.lwjgl.test.opengl.pbuffer.PbufferTest <mode>");
        System.out.println("\n<mode>.");
        System.out.println("\t1: no render-to-texture");
        System.out.println("\t2: with render-to-texture");
        System.exit(-1);
    }
}

