/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import java.io.IOException;
import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.examples.spaceinvaders.TextureLoader;
import org.lwjgl.opengl.GL11;

public class Sprite {
    private Texture texture;
    private int width;
    private int height;

    public Sprite(TextureLoader loader, String ref) {
        try {
            this.texture = loader.getTexture("spaceinvaders/" + ref);
            this.width = this.texture.getImageWidth();
            this.height = this.texture.getImageHeight();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public int getWidth() {
        return this.texture.getImageWidth();
    }

    public int getHeight() {
        return this.texture.getImageHeight();
    }

    public void draw(int x, int y) {
        GL11.glPushMatrix();
        this.texture.bind();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, this.texture.getHeight());
        GL11.glVertex2f(0.0f, this.height);
        GL11.glTexCoord2f(this.texture.getWidth(), this.texture.getHeight());
        GL11.glVertex2f(this.width, this.height);
        GL11.glTexCoord2f(this.texture.getWidth(), 0.0f);
        GL11.glVertex2f(this.width, 0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

