/**
 * ...
 * @author Henri Sarasvirta
 */
wideload.NoiseShader =
{
	attributes:{
		
	},
	
	uniforms:{
		zoom: {type:"f", value: 0.6},
		resolution: {type:"v2", value: new THREE.Vector2(8,8)},
		time: {type:"f", value: 164.0},
		ttime: {type:"f", value: 0.0},
	},
	
	vertex: [
		"varying vec3 vNormal;",
		"varying vec2 vUv;",
		
		"void main() {",
			'vUv = uv;',
			"vNormal = normal;",
			"vec3 p = position;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
		"varying vec3 vNormal;",
		"varying vec2 vUv;",
	"uniform vec2 resolution;",
		"uniform float time;",
		"uniform float ttime;",
		"float rand(vec2 co){",
			"return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);",
		"}",
		"void main() {",
			"vec2 uv = gl_FragCoord.xy;",
			"float rnd = rand(vec2(time*0.5*uv.x, time*uv.y*1.2));",
			"float ad = sin(uv.x*time);",
			"float mp = ttime > 4.0 ? (3.0-(ttime-4.0))/3.0 : 1.0;",
			"gl_FragColor = mp*(0.7+0.3*rand(uv))* vec4(ad+sin(uv.x/time + uv.y/time)+sin(uv.x/time - uv.y/time) , ad+sin(uv.x/time + uv.y/time)+sin(uv.x/time - uv.y/time), ad+sin(uv.x/time + uv.y/time)+sin(uv.x/time - uv.y/time),  1.0);",
		"}"
	].join("\n")
}