//Namespace
var timeDirection=1;

this.wideload = this.wideload || {};

(function(){
	
	var skipToTime = 0;
	
	//Constructor
	var Main = function(){
		
		//we can start after the sound is loaded and we are in fullscreen
		Main.LOAD_COMPLETED = {sound: false, fullScreen: false};
		
		this.parts = {
			Day: new wideload.DayAndNight(this, "DayAndNight"),
			//Tree: new wideload.Tree(this, "Tree"),
			Butterflies: new wideload.Butterflies(this,"Butterflies"), 
			WalkingMan: new wideload.WalkingMan(this,"WalkingMan"),
			Earth: new wideload.Earth(this, "Earth"),
			City: new wideload.City(this,"City"),
			//CitySkyBox: {Part:new wideload.CitySkyBox(this,"CitySkyBox"),Position:1500},
			Clock: new wideload.Clock(this,"Clock"),
		//	Hay: new wideload.Hay(this, "Hay"),
			Brickroad: new wideload.Brickroad(this,"Brickroad"),
			Forest: new wideload.Forest(this,"Forest"),
		//	Glass: new wideload.Glass(this, "Glass"),
		//	DreamWord: new wideload.DreamWord(this,"DreamWord"),
			Dream:new wideload.Dream(this,"Dream"),
			Water:new wideload.Water(this, "Water"),
			Noise:new wideload.Noise(this, "Noise"),
//			Water:new wideload.Grass(this, "Grass"),
		};
		
		//Add listeners for windowed & fullscreen
		document.getElementById("fullscreen").addEventListener('click', createjs.proxy(this.handleStart, this), false);
		document.getElementById("windowed").addEventListener('click', createjs.proxy(this.handleStart, this), false);
		
		//Add listener for bg music.
		createjs.Sound.addEventListener("fileload", createjs.proxy(this.soundLoaded, this));
		createjs.Sound.alternateExtensions=["mp3"];
		createjs.Sound.registerSound("bin/bg.ogg", "bg");
		this.drumDelta = 0;
		this.otherDelta = 0;
		this.drumIndex = 0;
		this.otherIndex = 0;
		this.drumSync = [
		];
		
		
		this.otherSync = [

		];
		
		this.partialTime = 0;

		this.clock = new THREE.Clock();
		
	}

	//Prototype reference.
	var p = Main.prototype;
	
	/**
	* Mode selection handler.
	*/
	p.handleStart = function(e)
	{
		//Check if target is fullscreen-button
		this.fullscreen = e.target == document.getElementById("fullscreen");
		
		//Initialize the program.
		this.initialize();
		
		//Set element states
		var element = this.renderer.domElement;
		var demoEl = document.getElementById("demo");
		if(this.fullscreen)
		{
			if (demoEl.requestFullscreen) {
				demoEl.requestFullscreen();
			} else if (demoEl.mozRequestFullScreen) {
				demoEl.mozRequestFullScreen();
			} else if (demoEl.webkitRequestFullscreen) {
				demoEl.webkitRequestFullscreen();
			} else{
				console.log("fail");
			}
		}
		document.getElementById("fullscreen").style.display = "none";
		document.getElementById("windowed").style.display = "none";
		Main.LOAD_COMPLETED.fullScreen = true;
		//Add delay if going to fullscreen.
		if(e.target == document.getElementById("fullscreen"))
		{ 
			window.setTimeout( createjs.proxy(this.checkStart,this),5000);
		}
		else
		{
			element.style.position="absolute";
			element.style.top = "50%";
			element.style.left = "50%";
			element.style.marginTop = "-360px";
			element.style.marginLeft= "-640px";

			this.checkStart();
		}
	}
	
	/**
	* Sound loaded -handler
	*/
	p.soundLoaded = function(){
		Main.LOAD_COMPLETED.sound = true;
		this.checkStart();
	}

	/**
	* Check if the demo can be started.
	*/
	p.checkStart = function(){
		if(Main.LOAD_COMPLETED.sound && Main.LOAD_COMPLETED.fullScreen){
			//Start the sound if not playing
			
			var ss = this;
			setTimeout(function(){
				if(!this.soundPlaying){
					ss.soundPlaying = true;
					ss.bgSound = createjs.Sound.play("bg");
					ss.bgSound.setPosition(skipToTime);
					ss.bgSound.setVolume(1);
				}
				ss.mainLoop();
			},1000);
			ss.mainLoop();
		}
	}
	
	/**
	* Initialize the main scene & other related stuff.
	*/
	p.initialize = function() {
		//because demo is in fullscreen mode setting width and height according to
		//screen property should work. 
		if(this.fullscreen)
		{
			var w = screen.width;
			var h = screen.height;
			//TODO - calculate the dimensions so that black borders can be applied
			this.width = w;
			this.height = h;
		}
		else
		{
			this.width = 1280;
			this.height = 720;
		}
		this.screenResolution = {width:this.width, height: this.height};
	    //Main render targets resolution. Parts can have different targets.
	    this.resolution = { width: 256, height: 256 };
		this.camIndex = 0;
		if(this.fullscreen)
		{
			var w = screen.width;
			var h = screen.height;
			//TODO - calculate the dimensions so that black borders can be applied
			this.width = w;
			this.height = h;
		}
		else
		{
			this.width = 1280;
			this.height = 720;
		}
		this.renderTarget = new THREE.WebGLRenderTarget( this.width, this.height, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat } );	
		
		
		
		//Build the renderer.
		this.renderer = new THREE.WebGLRenderer({antialias:true,alpha:true});
		this.renderer.setSize(this.width, this.height);
		this.renderer.setClearColor(0x000000);
		this.renderer.gammaInput = true;
		this.renderer.gammaOutput = true;
		
		this.renderer.domElement.style.width = this.width;
		this.renderer.domElement.style.height = this.height;
		
		//Add the renderer element.
		document.getElementById("demo").appendChild( this.renderer.domElement );		
		
		this.currentPart = 0;
		this.frameCount = 0;
		this.timeCount = 0;
		
		this.initializeScene();		
		this.InitializeComposer();
		
		// Creating containers for each part
		for (var partKey in this.parts) {
		    var part = this.parts[partKey];
			var object = new THREE.Object3D();
			part.preInitialize(object);	
		}
		
	    // Initializing configuration for master

		this.InitializeConfiguration();

		// Part initialization
		for (var partKey in this.parts) {
		    var part = this.parts[partKey];
		    part.width = this.width;
		    part.height = this.height;
			var object = new THREE.Object3D();
			part.initialize(this.scene);	
		}

	}
	
	p.InitializeComposer = function(){
		this.effectBloom = new THREE.BloomPass( 2.5, 20, 18 , 512)
	    var copyPass = new THREE.ShaderPass(THREE.CopyShader);
	    copyPass.renderToScreen = true;
	
		
		
		var renderModel = new THREE.RenderPass(this.scene, this.camera);
	    this.composer = new THREE.EffectComposer(this.renderer);
	    this.composer.renderTarget1.format=THREE.RGBAFormat;
	    this.composer.renderTarget2.format=THREE.RGBAFormat;
	    this.composer.addPass(renderModel);
	    this.composer.addPass(this.effectBloom);
		this.composer.addPass(copyPass);
		
	}
	
    p.InitializeConfiguration = function() {
        var configuration = new wideload.Configuration();
        this.configuration = configuration;        
        configuration.init();
        this.soundPlaying = false;
        for(var i = 0; i < configuration.parts.length; ++i){
        	var partConfiguration = configuration.parts[i];
        	var part = this.parts[partConfiguration.part];
        	if(part == null){
        		console.log("Configuration error in part configuration by id: " + configuration.part);
				continue;
        	}
        	part.configuration = partConfiguration;
        	part.container.position.z = partConfiguration.position;
        }
    }
    
	p.initializeScene = function(){
		this.scene = new THREE.Scene();
		this.scene.fog = new THREE.Fog( 0x000000, 1, 50000 );
		this.camera = new THREE.PerspectiveCamera( 55, this.width / this.height, 0.5, 3000000  );
		//this.camera.position.z = 10;
		//this.camera.position.y = 604;
		//this.camera.originalposition = this.camera.position.clone();
		//this.camera.lookAt(new THREE.Vector3(-5,20,0));
	//	this.camera.position.z = -0;
	//	this.camera.lookAt(new THREE.Vector3(0,0,0));
	
	    // Oclusion:
		this.scene.autoUpdate = true;

		// Camera drives

		var camera = this.camera;
		var scope = this;
		document.addEventListener('keydown',function(event){
		
		if(event.keyCode == "17")
		{
			scope.ctrlDown = true;
			document.addEventListener("keyup", function(event){
				if(event.keyCode == "17")
					scope.ctrlDown = false;
			});
		}
			
		var camdir = new THREE.Vector3(0,0,-1*(scope.ctrlDown?10:1));
		var left = new THREE.Vector3(-1*(scope.ctrlDown?10:1),0,0);
		var right = new THREE.Vector3(1*(scope.ctrlDown?10:1),0,0);
		var up = new THREE.Vector3(0,1*(scope.ctrlDown?10:1),0);
		var down = new THREE.Vector3(0,-1*(scope.ctrlDown?10:1),0);
		var forward = new THREE.Vector3(0,0,-1*(scope.ctrlDown?10:1));
		var back = new THREE.Vector3(0,0,1*(scope.ctrlDown?10:1));
		
		var rotLeft = new THREE.Vector3(0,0,0.1*(scope.ctrlDown?10:1));
		var rotRight = new THREE.Vector3(0.1*(scope.ctrlDown?10:1),0,0);
		var rotUp = new THREE.Vector3(0,0.1*(scope.ctrlDown?10:1),0);
		var rotDown = new THREE.Vector3(0,-0.1*(scope.ctrlDown?10:1),0);
		
		camdir.applyQuaternion(camera.quaternion);
		left.applyQuaternion(camera.quaternion);
		right.applyQuaternion(camera.quaternion);
		up.applyQuaternion(camera.quaternion);
		down.applyQuaternion(camera.quaternion);
		forward.applyQuaternion(camera.quaternion);
		back.applyQuaternion(camera.quaternion);
		rotLeft.applyQuaternion(camera.quaternion);
		rotRight.applyQuaternion(camera.quaternion);
		rotUp.applyQuaternion(camera.quaternion);
		rotDown.applyQuaternion(camera.quaternion);
		
		if(event.keyCode == '37'){
			camera.position.add(left);
		}
		if(event.keyCode == '39'){
			camera.position.add(right);
		}
		if(event.keyCode == '38'){
			camera.position.add(up);
		}
		if(event.keyCode == '40'){
			camera.position.add(down);
		}
		if(event.keyCode == '79'){
			camera.position.add(forward);
		}
		if(event.keyCode == '76'){
			camera.position.add(back);
		}
		if(event.keyCode == '65')
		{
			camera.rotateOnAxis(new THREE.Vector3(0,1,0), 0.01*(scope.ctrlDown?10:1));
		}
		if(event.keyCode == '68')
		{
			camera.rotateOnAxis(new THREE.Vector3(0,1,0), -0.01*(scope.ctrlDown?10:1));
		}
		if(event.keyCode == '87')
		{
			camera.rotateOnAxis(new THREE.Vector3(1,0,0), 0.01*(scope.ctrlDown?10:1));
		}
		if(event.keyCode == '83')
		{
			camera.rotateOnAxis(new THREE.Vector3(1,0,0), -0.01*(scope.ctrlDown?10:1));
		}
		if(event.keyCode == '81')
		{
			camera.rotateOnAxis(new THREE.Vector3(0,0,1), 0.01*(scope.ctrlDown?10:1));
		}
		if(event.keyCode == '69')
		{
			camera.rotateOnAxis(new THREE.Vector3(0,0,1), -0.01*(scope.ctrlDown?10:1));
		}
		if(event.keyCode == '80')
		{
			scope.stopCamera = true;
			console.log(camera.position);
			console.log(camdir);
			console.log("Camera rotations: x " + camera.rotation.x + " y " + camera.rotation.y + " z " + camera.rotation.z+ " Array ( " + camera.rotation.x + ","+camera.rotation.y+","+camera.rotation.z+ " )");
		}
		if(event.keyCode == "109"){
			// minus
			scope.bgSound.setPosition(scope.bgSound.getPosition()-5000);
		}
		if(event.keyCode == "107"){
			// pluss
			scope.bgSound.setPosition(scope.bgSound.getPosition()+5000);
		}
	}, false);
	
	}
	
	p.mainLoop = function(){
		var time = 0;
		if(this.bgSound != null)
			time = this.bgSound.getPosition()-500;
		//if(time < 0)
		//	return;
		var frameTime = time - this.previous;
		var td = frameTime / 1000;
		
		if(this.stopCamera)
		{
			time = this.previous;
		}
		this.previous = time;
		if(time == 0)
			td = 1;
		if(time == 0 && this.currentPart > 0)
			time = this.bgSound.length;
		if(this.camerarotation == null){
			this.camerarotation = 0.00;
		}
		if(this.bgSound && time >= this.bgSound.length)
			return;
		
//		this.camerarotation += 0.015*td;
	//	this.camera.position.z += 0.5*td;
	//	this.camera.position.y = this.camera.originalposition.y + Math.sin(this.camerarotation)*2;
	//	this.camera.position.x = this.camera.originalposition.x + Math.sin(this.camerarotation)*6;
	//	this.camera.lookAt(new THREE.Vector3(this.camera.originalposition.x-20,this.camera.originalposition.y+5,0));
		createjs.Tween.tick(frameTime, false);
		requestAnimationFrame( createjs.proxy(this.mainLoop, this) );
		++this.frameCount;
		
		var camsetup = this.configuration.cameraDrive[this.camIndex];
		if(time > camsetup.end)
		{
			this.camIndex++;
			if(this.camIndex >= this.configuration.cameraDrive.length)
				this.camIndex = this.configuration.cameraDrive.length-1;
			camsetup = this.configuration.cameraDrive[this.camIndex];
		}
		
		if(time > 153200 && !this.endd)
		{
			this.endd = true;
			$(".hilight").addClass("active");
		}
		if(time > 153400 && !this.eeff)
		{
			console.log("removeAttribute hi");
			this.eeff = true;
			$(".hilight").removeClass("active");
			$(".darken").addClass("active");
			$("#creds").css("display", "").animate({opacity:1},500);
			//.wait(1000).animate({opacity:0});
			
		}
		
		if(!this.stopCamera)
		{
			if(camsetup.handled)
				this.parts.WalkingMan.container.position.z = camsetup.charpos + (time - camsetup.begin)/1000*this.configuration.charSpeed;
			else if(camsetup.charpos)
			{
				camsetup.handled = true;
				this.parts.WalkingMan.container.position.z = camsetup.charpos;
			}
			else
				camsetup.handled = true;
			if(camsetup.charSpeed)
				this.configuration.charSpeed = camsetup.charSpeed;
			if(camsetup.action == "static")
			{
				this.camera.position.x = camsetup.position.x;
				this.camera.position.y = camsetup.position.y;
				this.camera.position.z = camsetup.position.z;
				this.camera.lookAt(camsetup.lookAt);
			} else if(camsetup.action == "follow")
			{
				this.camera.position.x = this.parts.WalkingMan.container.position.x + camsetup.position.x;
				this.camera.position.y = this.parts.WalkingMan.container.position.y + camsetup.position.y;
				this.camera.position.z = this.parts.WalkingMan.container.position.z + camsetup.position.z;
				this.camera.rotation.x = camsetup.rotation.x;
				this.camera.rotation.y = camsetup.rotation.y;
				this.camera.rotation.z = camsetup.rotation.z;
			} else if(camsetup.action == "bezier")
			{
				if(camsetup.addCharPos)
				{
					for(var i = 0; i < camsetup.positions.length; i++)
					{
						camsetup.positions[i].x += this.parts.WalkingMan.container.position.x;
						camsetup.positions[i].y += this.parts.WalkingMan.container.position.y;
						camsetup.positions[i].z += this.parts.WalkingMan.container.position.z;
					}
					camsetup.addCharPos = false;
					camsetup.path = new THREE.SplineCurve3(camsetup.positions);
				//	camsetup.rotPath = new THREE.SplineCurve3(camsetup.rotations);
				}
				
				var partial = (time - camsetup.begin)/(camsetup.end - camsetup.begin);
				if(partial > 1)
					partial = 1;
				var p = camsetup.path.getPoint(partial);
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
				
				var rotTarget = camsetup.rotPath.getPoint(partial);
				
				this.camera.rotation.x = rotTarget.x;
				this.camera.rotation.y = rotTarget.y;
				this.camera.rotation.z = rotTarget.z;
			}
			
		}
		
		for (var partKey in this.parts) {
		    var part = this.parts[partKey];
		    part.update(time, (time - part.configuration.startTime)/(part.configuration.endTime - part.configuration.startTime) );
		    if(part.configuration != null)
		    {
		    	if(time >= part.configuration.startTime && !part.isActive){
		    		this.scene.add(part.container);
		    		part.start(time);

		    	}
		    	if(time >= part.configuration.endTime && part.isActive){
		    		part.stop();
		    	}
		    }
		}
		
		if(time > 141734)
		{
			this.parts.WalkingMan.container.position.y-=.06;
		}
		
		
		//Brightness
		this.phaseCount = this.phaseCount || 1;
		var fadeTime = 300;
		if(time > musicDreamEnd-584*barLength-fadeTime && this.phaseCount <= 1) //Clock
		{
			$(".darken").addClass("active");		
		}
		if(time >= musicDreamEnd-584*barLength && this.phaseCount <= 1)
		{
			this.phaseCount++;
			$(".darken").removeClass("active");//this.bcShader.uniforms.brightness.value = -1+(time-40100)/fadeTime;
		}
		if(time >= 4550*barLength+488*barLength+musicDreamEnd-fadeTime && this.phaseCount <= 2) //Run
		{
			$(".darken").addClass("active");
		}
		if(time >= 4550*barLength+488*barLength+musicDreamEnd && this.phaseCount <= 2)
		{
			this.phaseCount++;
			$(".darken").removeClass("active");//this.bcShader.uniforms.brightness.value = -1+(time-40100)/fadeTime;
		}
		
		if(time > musicDreamEnd +barLength*9912-fadeTime && this.phaseCount <= 3) //move to road.
		{
			console.log("add darken");
			$(".darken").addClass("active");
		}
		if(time >musicDreamEnd +barLength*9912 && this.phaseCount == 3)
		{
			this.phaseCount++;
			$(".darken").removeClass("active");
		}
		//console.log(this.bgSound);
		this.renderer.autoClear =true;
		this.renderer.setClearColor(0x000000,1);
	//	this.renderer.render(this.scene,this.camera);
		//this.renderer.clear();
	     // This renders the actual camera image from stage to rendertarget
	    //this.renderer.render(this.finalScene,this.finalCamera);
		this.renderer.autoClear =false;
		this.renderer.shadowMapEnabled = true;
		this.composer.render();	 // Composer finally adds postprocessing effects and renders the final image to screen.
		$("#timestamp").html(Math.round(time));
};

	//Expose the class
	wideload.Main = Main;
}())

setTimeout(function(){
//var stats = new Stats();
//stats.setMode(0); // 0: fps, 1: ms

// Align top-left
//stats.domElement.style.position = 'absolute';
//stats.domElement.style.left = '0px';
//stats.domElement.style.top = '0px';

//document.body.appendChild( stats.domElement );

//setInterval( function () {

   // stats.begin();

    // your code goes here

 //   stats.end();

//}, 1000 / 60 );
},100);