/**
 * ...
 * @author Henri Sarasvirta
 */
wideload.GrassShader =
{
	attributes:{
		
	},
	
	uniforms:{
		time: {type:"f", value: 164.0},
		"normal":	{ type: "t", value: null },
		"grass":	{ type: "t", value: null },
	},
	
	vertex: [
		"varying vec3 vNormal;",
		"varying vec2 vUv;",
		"varying vec3 vPosition;",
		"void main() {",
			'vUv = uv;',
			"vNormal = normal;",
			"vec3 p = position;",
			"vPosition = p;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
		"#extension GL_OES_standard_derivatives : enable",
		"varying vec3 vPosition;",
		"varying vec2 vUv;",
		"varying vec3 vNormal;",
		"uniform vec3 uLight;",
		"uniform vec2 resolution;",
		"uniform float time;",
		"uniform sampler2D grass;",
		"uniform sampler2D grassNormal;",
		
		'vec3 getNormal() {',
		  '// Differentiate the position vector',
		  'vec3 dPositiondx = dFdx(vPosition);',
		  'vec3 dPositiondy = dFdy(vPosition);',
		  'float depth = texture2D(grassNormal, vUv*10.0).r;',
		  'float dDepthdx = dFdx(depth);',
		  'float dDepthdy = dFdy(depth);',
		  'dPositiondx -= 10.0 * dDepthdx * vNormal;',
		  'dPositiondy -= 10.0 * dDepthdy * vNormal;',

		  // The normal is the cross product of the differentials
		  'return normalize(cross(dPositiondx, dPositiondy));',
		'}',
		
		"void main() {",
			"vec2 uv = gl_FragCoord.xy;",
			'vec4 color = texture2D(grass, vUv*10.0);',
			'vec4 dark = vec4(0, 0, 0, 1.0);',
			'vec3 normal = getNormal();',
			
			'// Mix in diffuse light',
			'float diffuse = dot(normalize(uLight - vPosition), normal);',
			'diffuse = max(0.0, diffuse);',
			'color = mix(dark, color, 0.5 + 0.5 * diffuse);',
			
			'gl_FragColor = vec4(color);',
		"}"
	].join("\n")
}