/**
 * ...
 */

(function() {
	var City = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = City.prototype = new wideload.BasePart();
	wideload.City = City;
	
	p.superInitialize = p.initialize;

/*
	0 = highest, 4 = lowest, 99= empty
*/
	p.CityPopulationOrder=[
		[3,4,9,3,2],
		[2,3,9,4,1],
		[2,1,9,1,0],
		[3,0,9,3,2],
		[1,2,9,2,3],
		[0,2,9,0,2],
		[2,4,9,3,1],
		[1,2,9,3,4],
		[9,1,2,1,9]
	]
	p.tablePosition = new THREE.Vector3(-130.87749292742606, 295.61785925975232, 415.915447697259);

	p.initialize = function(scene, container){
		this.superInitialize(scene,container);
		this.lensFlareText0 = new THREE.Texture(Asset.getAsset("lensflare0"));
		this.lensFlareText1 = new THREE.Texture(Asset.getAsset("lensflare1"));
		this.lensFlareText2 = new THREE.Texture(Asset.getAsset("lensflare2"));
		this.lensFlareText0.needsUpdate = true;
		this.lensFlareText1.needsUpdate = true;
		this.lensFlareText2.needsUpdate = true;

		this.glassContainer = new THREE.Object3D();
		this.glassParticles = new wideload.Glass(this.main, "");
		this.glassParticles.initialize(scene, this.glassContainer);
		this.glassParticles.start();
		this.glassContainer.scale.set(1/20,1/20,1/20);
		this.glassContainer.visible = false;
		this.glassContainer.position.set(this.tablePosition.x, this.tablePosition.y, this.tablePosition.z - this.container.position.z);
		
		this.container.add(this.glassContainer);

		width = 2000;
		length = 5000;
		
		this.buildings = [];
		this.loadBuildings();
		var texture = new THREE.Texture(Asset.getAsset("street"));
		texture.needsUpdate = true;
		var road = new THREE.Mesh(new THREE.BoxGeometry(width,2,length),new THREE.MeshLambertMaterial({color:0x2f2f2f, map:texture}));
		

		road = new wideload.WMirror(this.main,"");
		road.initialize(scene, new THREE.Object3D(),new THREE.PlaneGeometry(width,length,100,100));
		this.road = road;
		road.start();
		//road.receiveShadow = true;
		road.container.position.z = length/2;
		//road.container.position.x = -width/2;
		road.container.position.y = 2;
		this.container.add(road.container);
		
		for(var i = 0; i <  this.CityPopulationOrder.length; ++i){
			for(var j = 0; j < this.CityPopulationOrder[i].length;++j){
				var position = this.CityPopulationOrder[i][j]
				if(position == 9){
					continue;
				}
				var building = this.buildings[position];
				//console.log(i + " and " + j);
				var mesh = new THREE.Mesh(building.geo,new THREE.MeshFaceMaterial(building.materials));
				mesh.scale.set(50,50 + wideload.Random.getRange(0,10),50);
				mesh.position.z = i*400;
				var jump = j;
				if(i > 4){
					jump-= 0.5; // this makes mid of the road narrow
				}
				mesh.position.x = -(this.CityPopulationOrder[i].length)*350/2+350 + jump*350;
				mesh.rotation.y = Math.PI/180*90*wideload.Random.getRange(0,3);
				//mesh.rotation.y = i*0.95;
				this.container.add(mesh);
			}
			
		}

		var texture = new THREE.Texture(Asset.getAsset("waterdroplet"));
		texture.needsUpdate = true;
		// create the particle variables
		var particleCount = 35800;
    	particles = new THREE.Geometry(),
   		pMaterial = new THREE.PointCloudMaterial({
      		//color: 0x8080bc,
      		size: Math.random()*2+1,
      		map:texture,
      		transparent:true,
    	});

		// now create the individual particles
		for (var p = 0; p < particleCount; p++) {

  			// create a particle with random
  			// position values, -250 -> 250
  			var pX = width/2 - Math.random()*width;
      		var pY = Math.random() * 2000;
     		var pZ = length - Math.random()*length - 500;

      		var particle = new THREE.Vector3(pX, pY, pZ);
      		particle.velocity = new THREE.Vector3(0,-11,0);
      		//particle.velocity.y = -Math.random()*.1;
  			// add it to the geometry
 		 	particles.vertices.push(particle);
		}

		// create the particle system
		this.waterDrops = new THREE.PointCloud(
    		particles,
    		pMaterial);

		this.container.add(this.waterDrops);
		
		//scene.add(man);
		this.container.add(new THREE.HemisphereLight( 0xffffff,0x8f8f8f ))	;
	}
	
	p.internalUpdate = function(elapsedtime,renderTarget){
		for(var i = 0; i < this.waterDrops.geometry.vertices.length; ++i){
			var vertex = this.waterDrops.geometry.vertices[i];
			
			vertex.add(vertex.velocity);
			if(vertex.y < 0){
				vertex.y = Math.random()*1000 + 1000;
			}
			this.waterDrops.geometry.verticesNeedUpdate = true;
		}
		this.road.update(elapsedtime);
		if((elapsedtime - this.startTime) > 6630*barLength && !this.table.handled){
			this.table.handled = true;
			var ss = this;
			var lamp = this.lampThatBends;
			this.glassContainer.visible = true;
			createjs.Tween.get(ss.table.position).to({x:ss.table.position.x + 145, y:0, z: ss.table.position.z+100}, 1138*barLength, createjs.Ease.quartOut);
			createjs.Tween.get(ss.table.rotation).to({x:Math.PI/3, y:Math.PI, z: Math.PI}, 1300*barLength, createjs.Ease.circOut);
			createjs.Tween.get(ss.glassContainer.position, {
				onChange:function(){
					ss.glassParticles.update(elapsedtime,renderTarget);
				}}).to({x:ss.glassContainer.position.x + 190, y:0, z: ss.glassContainer.position.z+40}, 1463*barLength, createjs.Ease.quartOut);
			setTimeout(function(){
				lamp.rotation.z=-Math.PI/4;lamp.flare.visible=false;
			}, 518*barLength);
			
		}
	}

	p.loadBuildings = function(){
		var loader = new THREE.OfflineJSONLoader();

		this.buildings.push(this.loadBuilding(loader,jsAsset_highRise3, "highRiseWalls3"));
		this.buildings.push(this.loadBuilding(loader,jsAsset_highRise, "highRiseWalls"));
		this.buildings.push(this.loadBuilding(loader,jsAsset_highRise4, "highRiseWalls")); // TODO:one bigger than highrise, but smaller than hr3
		this.buildings.push(this.loadBuilding(loader,jsAsset_highRise2, "highRiseWalls2"));

		this.buildings.push(this.loadBuilding(loader,jsAsset_octagon, "octagonWalls"));
		var container = this.container;
		var post;
		loader.load(jsAsset_lightPost, function(geo,materials){
			post = {geo:geo,materials:materials};
			//post.materials[2].side = THREE.DoubleSide;
			//post.materials[2].needsUpdate = true;
		})
		var postmaterial = new THREE.MeshFaceMaterial(post.materials);

		for(var i = 0; i < 20; ++i){
			var mesh = new THREE.Mesh(post.geo,postmaterial);
			mesh.position.z = i*250-250;
			mesh.position.x = -20;
			if(i == 6){
				this.lampThatBends = mesh;
			}	
			mesh.scale.set(3,3,3);
			container.add(mesh);
			this.createLamp(mesh);
		}
		


		var ss = this;
		loader.load(jsAsset_Table, function(geo,materials){
			var texture = new THREE.Texture(Asset.getAsset("greetwood"));
			texture.needsUpdate = true;
			materials[0].map = texture;

			var mesh = new THREE.Mesh(geo, new THREE.MeshFaceMaterial(materials));
			mesh.scale.set(3,3,3);
			mesh.position.set(ss.tablePosition.x
				,ss.tablePosition.y
				,ss.tablePosition.z-container.position.z);
			ss.table = mesh;
			container.add(mesh);
		});
		
	}

	p.loadBuilding = function(loader, asset, texture){
		var building;
		loader.load(asset, function(geo,materials){
  			//var materials = [];
  			materials[0].map = new THREE.Texture(Asset.getAsset(texture));
  			materials[1].map = new THREE.Texture(Asset.getAsset("highRiseRoof"),THREE.CubeReflectionMapping());
  			//materials[0].map.repeat.set(4,4);
  			materials[0].map.needsUpdate = true;
  			materials[1].map.needsUpdate = true;
  			
  			//materials.push(walls);
  			//materials.push(roof);
  			building = {geo:geo,materials:materials};  			
  		})
  		return building;
	}

	p.createLamp = function(mesh){
		var lampPosition = mesh.position;
		var spotLight = new THREE.SpotLight( 0x80aeae);
		spotLight.position.set(lampPosition.x+15,lampPosition.y+46.5,lampPosition.z);
		spotLight.castShadow = true;
		spotLight.shadowMapWidth = 1024; 
		spotLight.intensity=0.2;
		spotLight.shadowMapHeight = 1024; 
		spotLight.shadowCameraNear = 500; 
		spotLight.shadowCameraFar = 400; 
		spotLight.shadowCameraFov = 30;
//		this.container.add(spotLight);

		var flareColor = new THREE.Color( 0xffffff );
		flareColor.setHSL( 0.9, 0.5, 0.9 + 0.5 );
		var lensFlare = new THREE.LensFlare( this.lensFlareText0, 220, 0.0, THREE.AdditiveBlending  , flareColor );
		lensFlare.intensity =0.0;
		lensFlare.add( this.lensFlareText1, 80, 0.0, THREE.AdditiveBlending  );
		lensFlare.add( this.lensFlareText1, 80, 0.0, THREE.AdditiveBlending  );
		lensFlare.add( this.lensFlareText1, 80, 0.0, THREE.AdditiveBlending  );

		lensFlare.add( this.lensFlareText2, 40, 0.1, THREE.AdditiveBlending  );
		lensFlare.add( this.lensFlareText2, 50, 0.12, THREE.AdditiveBlending  );
		lensFlare.add( this.lensFlareText2, 64, 0.15, THREE.AdditiveBlending  );
		lensFlare.add( this.lensFlareText2, 50, 0.20, THREE.AdditiveBlending  );
		
		lensFlare.customUpdateCallback =createjs.proxy(lensFlareUpdateCallback, this);
		lensFlare.position.copy( spotLight.position );
		mesh.flare = lensFlare;
		this.container.add( lensFlare );

		//var mesh = new THREE.Mesh(new THREE.BoxGeometry(10,10,10),new THREE.MeshBasicMaterial({color:0xff0000}));
		//mesh.position.set(spotLight.position.x,spotLight.position.y,spotLight.position.z);
		//this.scene.add(mesh);
	}
	
	function lensFlareUpdateCallback( object ) {

				var f, fl = object.lensFlares.length;
				var flare;
				var vecX = -object.positionScreen.x * 2;
				var vecY = -object.positionScreen.y * 2;


				for( f = 0; f < fl; f++ ) {

					   flare = object.lensFlares[ f ];

					   flare.x = object.positionScreen.x + vecX * flare.distance;
					   flare.y = object.positionScreen.y + vecY * flare.distance;

					   flare.rotation = 0;

					   var zdif = Math.abs(object.position.z + this.container.position.z - this.main.camera.position.z); 

						if(zdif > 1000){
							flare.opacity = 0;
						}
						else{
							if(object.position.y - this.main.camera.position.y < -4){
								flare.opacity = 0;
								flare.visible = false;
							}
							else{
								flare.opacity = 1;
								flare.visible = true;
							}
						}

						flare.scale = ((1000-zdif)/(1000));
						flare.visible = true;
						if(zdif > 200 && f > 3){
							flare.scale = 0;
							flare.visible = false;
						}
						
						//flare.scale = Math.min(1/(450-(Math.abs(object.position.z - globalMain.camera.position.z))),0.2);
						//flare.scale = 1;
				}
				

				object.lensFlares[ 2 ].y += 0.025;
				object.lensFlares[ 3 ].rotation = object.positionScreen.x * 0.5 + THREE.Math.degToRad( 45 );

			}
})();

