/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	
	var butterfly = new Image();
	butterfly.src = "data:image/png;base64,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"
	window.Asset.register("butterfly", butterfly);	
		
	
})();