//Particle shapes part by rimina

var Name = function(){
  PartBase.call(this);
  this.initScene();
}

Name.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Name.prototype.initScene = function(){
  
  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera(TDEMO.fov, TDEMO.aspect, TDEMO.near, TDEMO.far);
  this.camera.position.z = 400;
  this.scene.add(this.camera);
  
  var ambient = new THREE.AmbientLight(0xF8F8FF);
  
  var directionalLight = new THREE.DirectionalLight( 0xD9D9F3, 0.5 );
  directionalLight.position.set( 0, -1, 1 );
  directionalLight.position.normalize();
  this.scene.add( directionalLight );

  pointLight = new THREE.PointLight( 0xBF5FFF, 5, 300 );
  this.scene.add(pointLight);
  
  this.texts = new THREE.Object3D();
  this.createText();
  this.scene.add(this.texts);
  
  this.createSurroundings();
}

//prepare is called just before first rendering
Name.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
  
  this.transformations = [
    {
      start: this.startTime + 2*TDEMO.barLength,
      end : this.startTime + 10*TDEMO.barLength,
      position : 400,
      vz : (-400 - 400)/(8*TDEMO.barLength),
      vy : -130/(8*TDEMO.barLength),
      callback : function(transform, time){
        var t = time - transform.start;
        var sz = transform.vz * t;
        var sy = transform.vy * t;
        this.camera.position.z = transform.position + sz;
        this.camera.position.y = sy;
      },
      done : false
    },
  ];
}

//rendering function
Name.prototype.render = function(elapsedTime, rtt){
  TDEMO.renderer.render(this.scene, this.camera, rtt);
}

//Operations tahta takes place before rendering in every cycle
Name.prototype.animate = function(elapsedTime){
  for(var i = 0; i < this.transformations.length; ++i){
    var transform = this.transformations[i];
    if(!transform.done && elapsedTime >= transform.start && elapsedTime <= transform.end){
      transform.callback.call(this, transform, elapsedTime);
    }
    else if(!transform.done && elapsedTime >= transform.end){
      transform.done = true;
    }
  }
}

Name.prototype.createText = function(){
  
  var material = new THREE.MeshFaceMaterial( [
    new THREE.MeshLambertMaterial( { color: 0x8F8FBC, shading: THREE.FlatShading, opacity: 0.8 } ),
    new THREE.MeshLambertMaterial( { color: 0xF8F8FF } )
  ] );
  
  var options = {
    size: 70,
    height: 25,
    curveSegments: 16,
    font: "helvetiker",
    
    bevelEnabled: true,
    bevelThickness: 2,
    bevelSize: 2,

    material: 0,
    extrudeMaterial: 1
  };
  
 var name = "Paraguay";
  
  var hash = document.location.hash.substr( 1 );
  if ( hash.length !== 0 ) {
    name = hash;
  } 
  var text3d = new THREE.TextGeometry( name, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  
  this.name = new THREE.Mesh(text3d, material);
  
  var centerOffset = -0.5*(text3d.boundingBox.max.x - text3d.boundingBox.min.x );
  this.name.position.x = centerOffset;
  this.name.position.y = 50;
  
  this.texts.add(this.name);
  
  var presents = "presents";
  var hash = document.location.hash.substr( 1 );
  if ( hash.length !== 0 ) {
    presents = hash;
  }  
  
  text3d = new THREE.TextGeometry( presents, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  
  this.presents = new THREE.Mesh(text3d, material);
  
  var centerOffset = -0.5*(text3d.boundingBox.max.x - text3d.boundingBox.min.x );
  this.presents.position.x = centerOffset;
  this.presents.position.y = -60;
  this.presents.position.z = -200;
  
  this.texts.add(this.presents);
  
  var lastDay = "Last Day";
  var hash = document.location.hash.substr( 1 );
  if ( hash.length !== 0 ) {
    presents = hash;
  }  
  
  text3d = new THREE.TextGeometry( lastDay, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  
  this.lastDay = new THREE.Mesh(text3d, material);
  
  var centerOffset = -0.5*(text3d.boundingBox.max.x - text3d.boundingBox.min.x );
  this.lastDay.position.x = centerOffset;
  this.lastDay.position.y = -20;
  this.lastDay.position.z = -450;
  
  this.texts.add(this.lastDay);
  
  var of = "of";
  var hash = document.location.hash.substr( 1 );
  if ( hash.length !== 0 ) {
    presents = hash;
  }  
  
  text3d = new THREE.TextGeometry( of, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  
  this.of = new THREE.Mesh(text3d, material);
  
  var centerOffset = -0.5*(text3d.boundingBox.max.x - text3d.boundingBox.min.x );
  this.of.position.x = centerOffset;
  this.of.position.y = -100;
  this.of.position.z = -450;
  
  this.texts.add(this.of);
  
  var escapism = "Escapism";
  var hash = document.location.hash.substr( 1 );
  if ( hash.length !== 0 ) {
    presents = hash;
  }  
  
  text3d = new THREE.TextGeometry( escapism, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  
  this.escapism = new THREE.Mesh(text3d, material);
  
  var centerOffset = -0.5*(text3d.boundingBox.max.x - text3d.boundingBox.min.x );
  this.escapism.position.x = centerOffset;
  this.escapism.position.y = -180;
  this.escapism.position.z = -450;
  
  this.texts.add(this.escapism);
  
};

Name.prototype.createSurroundings = function(){

  this.scene.fog = new THREE.Fog(0xCDCCFF, 200, 600);
  var material = new THREE.MeshPhongMaterial({
    color : 0x5D478B,
    ambient : 0x304132,
    emissive : 0x1C1C1C,
    specular : 0x483D8B,
    side : THREE.BackSide
  });
  this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(600, 16, 16), material);
  this.scene.add(this.skySphere);
}