﻿//Variables related to audio
var Music = function(){

  var m = {
    //beats per minute
    bpm : 170,
    //seconds per beat
    spb : 1/(170/60),
    //how many seconds per bar
    barLength : 4 * (1/(170/60)),
    beats_per_bar : 4,
    bars_total : 118,
    currentBeat : 0,
    
    tics_per_beat : 4,
  };
  m.duration = m.bars_total * m.barLength;
  
  m.syncPoints ={
    verse1 : m.barLength * 9, //the first verse starts 
    bridge1 : m.barLength * 25, //bridge
    fill1 : m.barLength * 29, //drum fill
    verse2 : m.barLength * 30, // second verse 
    bridge2 : m.barLength * 46, //bridge 
    verse3 : m.barLength * 50, //third verse 
    bridge3 : m.barLength * 66, //bridge
    fill2 : m.barLength * 70,//drum fill
    slow : m.barLength * 71, //slow thing 
    slowBridge: m.barLength * 95, //ending of the slow 
    fill3 : m.barLength * 98,
    verse4 : m.barLength * 99, //last verse
    bridge4 : m.barLength * 115, //Ending
    lastBeat: m.barLength * 117 + m.spb
  };
  
  var beats = new Array(m.bars_total*m.beats_per_bar);
  var tics = new Array(m.bars_total*m.beats_per_bar*m.tics_per_beat);
  
  var createBeats = function(){
    for(var i = 0; i < beats.length; ++i){
      beats[i] = i*m.spb;
    }
  };
  
  var createTics = function(){
    for(var j = 0; j < tics.length; ++j){
      tics[j] = j*(m.spb/m.tics_per_beat);
    }
  }
  createBeats();
  createTics();
  
  
  var currentTic = 0;
  var prevTic = 0;
  var onTic = function(time){
    if(currentTic < tics.length){
      if(time >= tics[currentTic]){
        prevTic = currentTic;
        currentTic++;
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return false;
    }
  };
  
  var currentBeat = 0;
  var prevBeat = 0;
  m.onBeat = function(time){
    if(currentBeat < beats.length){
      var tic = onTic(time);
      if(time >= beats[currentBeat]){
        prevBeat = currentBeat;
        currentBeat++;
        return {on: true, beat : prevBeat%4, count: prevBeat, onTic: tic, tic: prevTic%4};
      }
      else{
        return {on: false, beat : prevBeat%4, count: prevBeat, onTic : tic, tic: prevTic%4};
      }
    }
    else{
      return false;
    }
  };
  
  
  
  return m;
};

MUSIC = Music();