
var cat = function() {
  var catObject = new THREE.Object3D();
  catObject.position.z = 300;
  
  var material = new THREE.MeshPhongMaterial({
		color : 0x000000,
		ambient : 0x000000,
		emissive : 0x5D478B,
		specular : 0x5D478B
	});

  catHead(catObject, material);
  catBody(catObject, material);
  catTail(catObject, material);
  catLegs(catObject, material);
  catEars(catObject, material);
  
  return catObject;
}

var catHead = function(catObject, material) {
  var head = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32),  material);
  head.position.set(-10, 5, 0); 
  
  catObject.add(head);

  createEye(-13.5, 3, catObject);
  createEye(-14.5, -1.6, catObject);
  createNose(catObject);
}

var catBody = function(catObject, material) {
  var body = new THREE.Mesh( new THREE.CylinderGeometry( 5, 5, 14, 32 ), material );
  var end1 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), material);
  var end2 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), material);
    
  body.rotation.z = 1.55;
  end1.position.set(-5, 0, 0);
  end2.position.set(5, 0, 0);
  
  catObject.add(body);
  catObject.add(end1);
  catObject.add(end2);
}

var catTail = function(catObject, material) {

  var tail = new THREE.Mesh( new THREE.CylinderGeometry( 1.5, 1.5, 8, 32 ), material);
  
  var tailend = new THREE.Mesh(new THREE.SphereGeometry(1.5, 32, 32), material);
  tail.rotation.z = -1;
  tail.position.set(12,5,0);
  tailend.position.set(15, 7, 0);
  
  catObject.add(tail);
  catObject.add(tailend);
}

var catLegs = function(catObject, material) {
  createLeg(-5, -3, material, catObject);
  createLeg(-5, 3, material, catObject);
  createLeg(5, -3, material, catObject);
  createLeg(5, 3, material, catObject);
}

var catEars = function(catObject, material) {
  createEar(-10, 2.5, material, catObject);
  createEar(-10, -2.5, material, catObject);
}

var createLeg = function(posX, posZ, material, catObject) {
  var leg = new THREE.Mesh( new THREE.CylinderGeometry( 1.8, 1.7, 8, 32 ), material );
  var end2 = new THREE.Mesh(new THREE.SphereGeometry(1.9, 32, 32), material);
  leg.position.set(posX, -5, posZ);
  end2.position.set(posX-0.2, -9, posZ);
  
  catObject.add(leg);
  catObject.add(end2);  
}

var createEar = function(posX, posZ, material, catObject) {
  var ear = new THREE.Mesh( new THREE.CylinderGeometry(0, 1.5, 5, 32 ), material );
  ear.position.set(posX, 10, posZ);
  catObject.add(ear);
}

var createEye = function(posX, posZ, catObject) {
  var eyematerial = new THREE.MeshPhongMaterial({
		color : 0x909000,
		ambient : 0xffff00,
		// emissive : 0x5D478B,
		// specular : 0x5D478B
	});
  
  var eye = new THREE.Mesh( new THREE.SphereGeometry(0.8, 32, 32), eyematerial );
  eye.position.set(posX, 5, posZ);

  catObject.add(eye);
}

var createNose = function(catObject) {
  var nosematerial = new THREE.MeshPhongMaterial({
		color : 0x903030,
		ambient : 0xFF0066,
		// emissive : 0x5D478B,
		// specular : 0x5D478B
	});

  var nose = new THREE.Mesh( new THREE.SphereGeometry(0.5, 32, 32), nosematerial );
  nose.position.set(-15, 4, 1.3);

  catObject.add(nose);  
}