//
//  BouncingBallViewController.m
//  7dxBouncingBall
//
//  Created by Malcomic-XD on 5/3/14.
//  Copyright (c) 2014 Malcomic-XD. All rights reserved.
//

#import "BouncingBallViewController.h"

#define kStateStop 0
#define kStateRunning 1
#define kStateGameOver 2
#define kStateMenu 3
#define kStateSettings 4
#define kStateHowToPlay 5


#define kLeftDown 1
#define kRightDown 2
#define kTouchesEnded 3

#define kTouch 1
#define kTilt 2

#define kGravityMultiplier 10

#define kPlatformHeight 20
#define kPlatformWidth 50

#define kMaxEricSpeed 10

#define kGravity 0.195

#define kJumpPower 9

@interface BouncingBallViewController ()
// Here is functions and stuffs



@end

@implementation BouncingBallViewController
@synthesize bg,howToPlay,eric,platform1,platform2,platform3,platform4,platform5;
@synthesize gameState,score,previousState,controlType,touchState;
@synthesize ericVelocity,gravity;
@synthesize lblScore;
@synthesize btnHowToPlay,btnPlay,btnSettings,btnMenu,btnRestart,btnBack;
@synthesize scTouchTilt;
//@synthesize acceleration;

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    [NSTimer scheduledTimerWithTimeInterval:1.0/60 target:self selector:@selector(gameLoop) userInfo:nil repeats:YES];
    gameState = !kStateRunning;
    ericVelocity = CGPointMake(0, 0);
    gravity = CGPointMake(0, kGravity);
    
}

- (void) gameLoop{

    if(gameState == kStateRunning){
    
        if(previousState != kStateRunning){
            
            score = 0;
            
            NSString *nssScore = [NSString stringWithFormat:@"%li", (long)score];
            lblScore.text = nssScore;

            
            //lblMenu.hidden = 1;
            //lblRestart.hidden = 1;
            
            btnRestart.hidden = 1;
            btnMenu.hidden = 1;
        
      
        
            btnPlay.hidden = 1;
            btnSettings.hidden = 1;
            btnHowToPlay.hidden = 1;
           // btnBack.hidden = 1;
            
          //  scTouchTilt.hidden = 1;
            
            howToPlay.hidden = 1;
            eric.hidden = 0;
            platform1.hidden = 0;
            platform2.hidden = 0;
            platform3.hidden = 0;
            platform4.hidden = 0;
            platform5.hidden = 0;
            lblScore.hidden = 0;
            

        
        }
            
            
            
        [self gameStatePlayNormal];
        previousState = kStateRunning;
    
    } else if(gameState == kStateGameOver){
        
        if(previousState == kStateRunning){
        
            //lblMenu.hidden = 0;
            //lblRestart.hidden = 0;
            
            btnRestart.hidden = 0;
            btnMenu.hidden = 0;
            
        
        }
    
        previousState = kStateGameOver;
        
    }
    else if(gameState == kStateMenu){
    
        if(previousState != kStateMenu){
        
            btnPlay.hidden = 0;
            btnSettings.hidden = 0;
            btnHowToPlay.hidden = 0;
            
            eric.hidden = 1;
            howToPlay.hidden = 1;
            platform1.hidden = 1;
            platform2.hidden = 1;
            platform3.hidden = 1;
            platform4.hidden = 1;
            platform5.hidden = 1;
            lblScore.hidden = 1;
           // lblRestart.hidden = 1;
           // lblMenu.hidden = 1;
            btnMenu.hidden = 1;
            btnRestart.hidden = 1;
            
            btnBack.hidden = 1;
            scTouchTilt.hidden = 1;
            
            bg.hidden = 0;

        
        }
    
    }
    else if(gameState == kStateSettings){
    
        if(previousState != kStateSettings){
        
            btnPlay.hidden = 1;
            btnHowToPlay.hidden = 1;
            btnSettings.hidden = 1;
            
            btnBack.hidden = 0;
            scTouchTilt.hidden = 0;
        
        }
        
        previousState = kStateSettings;
    
    }
    else if (gameState == kStateHowToPlay){
    
        if(previousState != kStateHowToPlay){
        
            btnPlay.hidden = 1;
            btnBack.hidden = 0;
            btnHowToPlay.hidden = 1;
            btnMenu.hidden = 1;
            btnRestart.hidden = 1;
            btnSettings.hidden = 1;
            lblScore.hidden = 1;
            
            eric.hidden = 1;
            platform1.hidden = 1;
            platform2.hidden = 1;
            platform3.hidden = 1;
            platform4.hidden = 1;
            platform5.hidden = 1;
            
            scTouchTilt.hidden = 1;
            
            bg.hidden = 1;
            howToPlay.hidden = 0;
        
        }
        
        previousState = kStateHowToPlay;
    
    }

}

- (void)gameStatePlayNormal{

    ericVelocity.y += gravity.y;
    
    if(controlType == kTouch){
        //if the player is touch the screen, eric move to left or right
        if(touchState  == kLeftDown) {ericVelocity.x -= 0.2;}
        if(touchState == kRightDown) {ericVelocity.x += 0.2;}
    }
    
    if(controlType == kTilt){
    
        
        ericVelocity.x += gravity.x;
    
    }
    
    //Make sure the ball doesn't move fast
    if(ericVelocity.x > kMaxEricSpeed) {ericVelocity.x = kMaxEricSpeed;}
    if(ericVelocity.x < -kMaxEricSpeed) {ericVelocity.x = -kMaxEricSpeed;}
    
    
    //Make the ball loop to the other side of the screen if it goes off.
    if(eric.center.x > self.view.bounds.size.width){
        
        eric.center = CGPointMake(0, eric.center.y);
    
    }
    
    if(eric.center.x < 0){
        
        eric.center = CGPointMake(self.view.bounds.size.width, eric.center.y);
    
    }
    
    eric.center = CGPointMake(eric.center.x + ericVelocity.x, eric.center.y + ericVelocity.y);
    
    if(eric.center.y > self.view.bounds.size.height){
        
        gameState = kStateGameOver;
        
        ericVelocity.x=0;
        ericVelocity.y=0;
        
        //Reset the position
        
        eric.center = CGPointMake(185+16, 341+16);
        platform1.center = CGPointMake(95 + (kPlatformWidth/2),211 + (kPlatformHeight/2));
        platform2.center = CGPointMake(141 + (kPlatformWidth/2),45 + (kPlatformHeight/2));
        platform3.center = CGPointMake(257 + (kPlatformWidth/2),143 + (kPlatformHeight/2));
        platform4.center = CGPointMake(270 + (kPlatformWidth/2),275 + (kPlatformHeight/2));
        platform5.center = CGPointMake(185 + (kPlatformWidth/2),403 + (kPlatformHeight/2));

    
    }
    
    //If the eric has passed the 3/4 mark than move everything
    
    if(eric.center.y < (self.view.bounds.size.height/4)){
        
        float difference = (self.view.bounds.size.height/4) - eric.center.y;
        score +=(int)difference;
        NSString *nssScore = [NSString stringWithFormat:@"%li", (long)score];
        lblScore.text = nssScore;
        
        eric.center = CGPointMake(eric.center.x, eric.center.y + difference);
        
        platform1.center = CGPointMake(platform1.center.x, platform1.center.y + difference);
        platform2.center = CGPointMake(platform2.center.x, platform2.center.y + difference);
        platform3.center = CGPointMake(platform3.center.x, platform3.center.y + difference);
        platform4.center = CGPointMake(platform4.center.x, platform4.center.y + difference);
        platform5.center = CGPointMake(platform5.center.x, platform5.center.y + difference);
        
        float viewWidth = self.view.bounds.size.width;
        float fViewWidthMinusPlatformWidth = viewWidth - 55.0f;
        int iViewWidthMinusPlatformWidth = (int)fViewWidthMinusPlatformWidth;
        
        //if the platforms move off the screen , then reset them  at a random spot at the top
        if(platform1.center.y >= (self.view.bounds.size.height + 8)){
            
            float x = random() % iViewWidthMinusPlatformWidth;
            x = x + 22.5f;
            float y = (random() % 20)-8;
            platform1.center = CGPointMake(x,y);
        
        }
        if(platform2.center.y >= (self.view.bounds.size.height + 8)){
            
            float x = random() % iViewWidthMinusPlatformWidth;
            x = x + 22.5f;
            float y = (random() % 20)-8;
            platform2.center = CGPointMake(x,y);
            
        }

        if(platform3.center.y >= (self.view.bounds.size.height + 8)){
            
            float x = random() % iViewWidthMinusPlatformWidth;
            x = x + 22.5f;
            float y = (random() % 20)-8;
            platform3.center = CGPointMake(x,y);
            
        }

        if(platform4.center.y >= (self.view.bounds.size.height + 8)){
            
            float x = random() % iViewWidthMinusPlatformWidth;
            x = x + 22.5f;
            float y = (random() % 20)-8;
            platform4.center = CGPointMake(x,y);
            
        }

        if(platform5.center.y >= (self.view.bounds.size.height + 8)){
            
            float x = random() % iViewWidthMinusPlatformWidth;
            x = x + 22.5f;
            float y = (random() % 20)-8;
            platform5.center = CGPointMake(x,y);
            
        }

        
    
    }
    
    
    
    if(CGRectIntersectsRect(eric.frame, platform1.frame)){
        
        if(eric.center.y + 8 < platform1.center.y){
            
            if(ericVelocity.y > 0){
                
                ericVelocity.y = -kJumpPower;
            
            }
            
        }
    
    }
    
    if(CGRectIntersectsRect(eric.frame, platform2.frame)){
        
        if(eric.center.y + 8 < platform2.center.y){
            
            if(ericVelocity.y > 0){
                
                ericVelocity.y = -kJumpPower;
                
            }
        
        }
    
    }
    
    if(CGRectIntersectsRect(eric.frame, platform3.frame)){
        
        if(eric.center.y + 8 < platform3.center.y){
            
            if(ericVelocity.y > 0){
                
                ericVelocity.y = -kJumpPower;
            
            }
        
        }
    
    }
    
    if(CGRectIntersectsRect(eric.frame,platform4.frame)){
        
        if(eric.center.y + 8 < platform4.center.y){
            
            if(ericVelocity.y > 0){
                
                ericVelocity.y = -kJumpPower;
            
            }
        
        }
    
    }
    
    if(CGRectIntersectsRect(eric.frame  , platform5.frame)){
        
        if(eric.center.y + 8 < platform5.center.y){
            
            if(ericVelocity.y > 0){
                
                ericVelocity.y = -kJumpPower;
            
            }
        
        }
    
    }
    

}


- (void)accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration{
    
    if(controlType == kTilt){
    
        gravity.x = acceleration.x * kGravityMultiplier;
        
        
    }


}


- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event{
    
    UITouch *touch = [[event allTouches]anyObject];
    CGPoint location = [touch locationInView:touch.view];
    
    if(gameState == kStateRunning && controlType == kTouch){
        
       
        if(location.x < (self.view.bounds.size.width/2)){
            
            touchState = kLeftDown;
            ericVelocity.x -= 0.2;
        
        }
        else{
            touchState = kRightDown;
            ericVelocity.x += 0.2;
        }
    
    }
    
   /* if(gameState == kStateGameOver){
        
        
        if(location.x < (self.view.bounds.size.width/2)){
            
            gameState = kStateMenu;
            
        }
        else{
            gameState = kStateRunning;
            }
        
        
    }*/

}


- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{

    touchState = kTouchesEnded;

}

- (IBAction)buttonClickedPlay{

    gameState = kStateRunning;

}

- (IBAction)buttonClickedHowToPlay{

    gameState = kStateHowToPlay;

}

- (IBAction)buttonClickedSettings{

    gameState = kStateSettings;

}

- (IBAction)buttonClickedMenu{
    
    gameState = kStateMenu;
    
}

- (IBAction)buttonClickedRestart{
    
    gameState = kStateRunning;
    
}

- (IBAction)buttonClickedBack{

    gameState = kStateMenu;
    

}

- (IBAction)valueChanged{

    if(scTouchTilt.selectedSegmentIndex == 0){
    
        controlType = kTilt;
    }else{
    
        controlType = kTouch;
    }

}



- (void)viewDidUnload
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    self.bg = nil;
    self.eric = nil;
    self.platform1 = nil;
    self.platform2 = nil;
    self.platform3 = nil;
    self.platform4 = nil;
    self.platform5 = nil;
    self.lblScore = nil;
    
    
}


/*- (void)dealloc{
    [super dealloc];
    [bg release];
    [eric release];
    [platform1 release];
    [platform2 release];
    [platform3 release];
    [platform4 release];
    [platform5 release];

}*/

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
    
    
    
}

@end
