var Credits = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_preflightCallback;

	var _blackFade,
		_glow;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		initSync();

		_ctx = _model.twoDeeRenderer;

		_preflightCallback();
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(42424242, 8000085, 1333337, 4242424);

	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');
	}

	function render(row, sceneTime, frameDelta) {
		_ctx.fillStyle = '#f6c003';
		_ctx.fillRect(0, 0, _width, _height);

		_ctx.drawImage(Meat.credits, 0, 0, Meat.credits.width/1920 * _width, Meat.credits.height/1080*_height);

		var glow = _glow.getValue(row),
			bF = _blackFade.getValue(row);
/*
		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}*/

		if (glow > 0) {
			var glowScale = 1;

			for (var i = 0; i < 4; i++) {
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}

		_ctx.save();
		_ctx.globalCompositeOperation = "multiply";
		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
		_ctx.restore();
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());