var HopalongTunnel = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_btx,
		_preflightCallback,
		_zLayer,
		_hopalong;

	var _blackFade,
		_glow,
        _extraGlow,
		_varA,
		_varB,
        _colorFade;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		_ctx = _model.twoDeeRenderer;

		initSync();
		_preflightCallback();
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(42424242, 8000085, 1333337, 4242424);

		_btx = document.createElement('canvas').getContext('2d');
		_btx.canvas.width = _width;
		_btx.canvas.height = _height;

		_hopalong = new Hopalong();
		_hopalong.setContext(_btx);

		_zLayer = new ZLayerTiles();
		_zLayer.setContext(_ctx);
		_zLayer.setContextInput(_btx);
	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');
		_extraGlow = _sync.getTrack('extraGlow');

		_varA = _sync.getTrack('hopa_a');
		_varB = _sync.getTrack('hopa_b');

        _colorFade = _sync.getTrack('colorFade');
	}

	function render(row, sceneTime, frameDelta) {

		_btx.save();
		_btx.fillStyle = 'hsl('+ Math.round(47 + _colorFade.getValue(row)) +', 98%, 49%)';
		_btx.globalAlpha = 0.05;
		_btx.fillRect(0, 0, _width, _height);
		_btx.restore();

		//_ctx.fillStyle = '#ffd24d';
		//_ctx.fillRect(0, 0, _width, _height);

		_ctx.save();
		_hopalong.setParams(_varA.getValue(row), _varB.getValue(row), row * 0.05);
		_hopalong.render(row);
		_ctx.restore();

		_ctx.save();
		//_ctx.globalAlpha = .8;
		_ctx.drawImage(Meat.pattern, 0, (_height - (Meat.pattern.height / 1080 * _height)) * 0.5, Meat.pattern.width / 1920 * _width, Meat.pattern.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_zLayer.render(frameDelta * 0.009);
		_ctx.restore();

        var extraGlow = _extraGlow.getValue(row);
        if (extraGlow > 0) {
            var glowScale = 1;

            for (var i = 0; i < 4; i++) {
                glowScale += .01;
                var sW = _width * glowScale,
                    sH = _height * glowScale;
                _ctx.save();
                _ctx.globalCompositeOperation = 'color-dodge';
                _ctx.globalAlpha = extraGlow;
                _ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
                _ctx.restore();
            }
        }

		var glow = _glow.getValue(row),
			bF = _blackFade.getValue(row);

		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}

		if (glow > 0) {
			var glowScale = 1;

			for (var i = 0; i < 4; i++) {
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}

		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());