typedef struct LatticeData
{
	float4 pos;
	float4 dir;
} LatticeData;

__kernel void krnl( __global struct LatticeData *inLattice, 
				    __global struct LatticeData *outLattice, 
					__global float4 *curlNoiseData
					  )
{
	uint x = get_global_id(0);
	uint y = get_global_id(1);
    uint num_x = get_global_size(0);
	uint num_y = get_global_size(1);

	uint posCurr = x + y*num_x;
	uint posPrev = (x+1) + y*num_x;

	// last
	if ( x == num_x-1 )
	{
		outLattice[posCurr].dir.xyz = curlNoiseData[y].xyz;
		return;
	}

	// copy dir of previous
	outLattice[posCurr].dir.xyz = inLattice[posPrev].dir.xyz;
}