#version 120

uniform vec4 Color;
uniform vec4 MiscFP;

varying vec3 pos;


void main(void)
{
	vec4 color = Color;
	vec3 lightPos = vec3(0.0f);
	float shatterCoeff = MiscFP.x;
	
	float attenuation = 1.0f-smoothstep( 0.0f, 7.6f, length(pos - lightPos) );
	
	// shatter feeling
	float alpha = step( 1.0f-shatterCoeff, sin(pos.x*200.0f)*0.5f+0.5f );
	alpha *= step( 1.0f-shatterCoeff, sin(pos.z*200.0f)*0.5f+0.5f );
	alpha = mix( alpha, 1.0f, shatterCoeff);
	
	gl_FragColor = vec4(color.xyz, attenuation*Color.w*alpha);
}