/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import pw.svn.client.ChatClient;
import pw.svn.server.ChatServer;

public class Demo {
    private JFrame frame;
    private JButton btnAddClient;
    private JButton btnAddServer;
    private JLabel lblClient;
    private JLabel lblServer;
    private final String serverAddress = "localhost";
    private final int port;
    Locale currentLocale;
    ResourceBundle messages;

    public Demo(String language, String country) {
        this.port = 8000;
        this.currentLocale = new Locale(language, country);
        this.messages = ResourceBundle.getBundle("MessageBundle", this.currentLocale);
        this.initGUI();
        this.initListeners();
    }

    public void initGUI() {
        this.frame = new JFrame("Pointerless Admin");
        this.frame.setDefaultCloseOperation(1);
        this.frame.setLayout(new GridLayout(2, 2));
        this.btnAddClient = new JButton("Add client");
        this.btnAddServer = new JButton("Add server");
        this.lblClient = new JLabel("Legg til ny klient: ");
        this.lblServer = new JLabel("Legg til ny server: ");
        this.frame.add(this.lblServer);
        this.frame.add(this.btnAddServer);
        this.frame.add(this.lblClient);
        this.frame.add(this.btnAddClient);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public void initListeners() {
        this.btnAddClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new ChatClient("localhost", Demo.this.port, Demo.this.messages, new Point(520, 40));
            }
        });
        this.btnAddServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new ChatServer("localhost", Demo.this.port, Demo.this.messages);
            }
        });
    }

    public static void main(String[] args) {
        new Demo("no", "NO");
    }
}

