#!/usr/bin/env python2
import sys
import random
import socket
from socket import timeout
from math import *
import json
sys.path.append("../api/python/")
import skyport
from copy import copy, deepcopy

#assert(len(sys.argv) == 2)
ai_name="shad"

rangeDict = {"mortar":(0,2,3,4), "laser":(0,5,6,7), "droid":(0,3,4,5)}
dmgDict = {"mortar":(0,20,20,25), "laser":(0,16,18,22), "droid":(0,22,24,26)}

resource_map = [0,0]
res_exp = 0
res_rub = 0
res_scr = 0
enemy_pos = [0,0]

sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect(('127.0.0.1', 54321))
#sock.setblocking(0)
#sockfile = sock.makefile()

inputbuf = ""


#2do if two enemys are in range of one move, go to the one with fewer hp





def read_packet():
    global inputbuf
    try:
        inputbuf += sock.recv(1)
    except socket.timeout as e:
        return None
    except socket.error as e:
        return None
    try:
        characters_to_read = inputbuf.index("\n")
        line = inputbuf[0:characters_to_read] # removing the newline
        inputbuf = inputbuf[characters_to_read+1:len(inputbuf)]
        return line
    except ValueError as f:
        return None

def do_random_move():
    direction = random.choice(["up", "down", "left-down", "left-up", "right-down", "right-up"])
    print("moving %s-wards." % direction)
    transmitter.send_move(direction)

def send_line(line):
    print("sending: '%s'" % line)
    if sock.sendall(line + "\n") != None:
        print("Error sending data!")

def got_handshake():
    print("got handshake!")

def got_error(errmsg):
    print("Error: '%s'" % errmsg)

def string_to_position(positionstring):
    positionstring=positionstring.split(', ')
    positionstring[0]=int(positionstring[0])
    positionstring[1]=int(positionstring[1])
    return positionstring


def calc_dmg(weapon_damage, unused_turns):
    return weapon_damage + unused_turns*(0.2*weapon_damage)

def got_gamestate(turn, map_obj, player_list):
    print("got gamestate");
        
    if player_list[0]["name"] == ai_name:
        attack_done=False
        global resource_map
        #print("map_obj: '%s'" % map_obj)        
        mymap = get_mapstate(map_obj)
        #print("mymap: '%s'" % mymap)        
        mypos=player_list[0]["position"]
        mypos=string_to_position(mypos)
 
        for myturn in range(1, 4):
            if attack_done==False:
                #print("mypos: '%s'" % mypos)
                mypos_x = mypos[0]
                mypos_y = mypos[1]
                print("TURN: '%s'" % myturn)
                print("mypos: '%s'" % mypos)
                in_enemy_range_count=check_if_in_enemy_range(mymap,mypos,player_list)
                #2do real performance issue!!!!!


                #target = inRange_V3(mymap,mypos,player_list,myturn,False,"all")
                target_PW = inRange_V3(mymap,mypos,player_list,myturn,False,"PW")
                target_SW = inRange_V3(mymap,mypos,player_list,myturn,False,"SW")
                
                is_one_hit_PW = False
                is_one_hit_SW = False
                if target_PW != mypos:
                    is_one_hit_PW=one_hit(mymap,mypos,player_list,myturn,target_PW)
                if is_one_hit_PW==False:
                    if target_SW != mypos:
                        is_one_hit_SW=one_hit(mymap,mypos,player_list,myturn,target_SW)

                one_hit_in_range=False
                escape_move=False
                if is_one_hit_PW==False and is_one_hit_SW==False:
                    print("NO ONE HIT")
                    #up to 2 moves onehit search
                    target=one_hit_reachable(mymap,mypos,player_list,myturn)
                    if target != mypos:
                        print("ONEHIT IN RANGE")
                        one_hit_in_range=True
                if one_hit_in_range:
                    mypos=move_to(mymap,mypos,target,player_list, myturn)
                else:
                    print("NO ONE HIT IN RANGE")
                    if (myturn < 3 and(in_enemy_range_count >= 1) and is_one_hit_PW==False and is_one_hit_SW==False): #2do and none of them is on hit) or in_enemy_range >= 3
                        print("FIND BETTER POS")
                        betterpos=find_better_pos(mymap,mypos,player_list,myturn)
                        if betterpos!=mypos:
                            print("BETTER POS FOUND")
                            escape_move=True
                            
                    if escape_move:
                        print("escapemove to: '%s'" % betterpos)
                        mypos=move_to(mymap,mypos,betterpos,player_list, myturn)
                    else:
                        #check in range PW or SW and get best target back
                        print("mypos: '%s'" % mypos)
                        print("targetV3_PW: '%s'" % target_PW)
                        #not always calculated print("targetV3_SW: '%s'" % target_SW)
                            
                        #inRange_V2(mypos,player_list[0]["primary-weapon"]["name"],player_list[0]["primary-weapon"]["level"],player_list,mymap)
                        #somebody in range of PW
                        if (target_PW != mypos and mymap[mypos_x][mypos_y] != 'S' and is_one_hit_SW==False):
                            print("in range PW")
                            print("targetV2_PW: '%s'" % target_PW)

                            #if target==target_PW:
                            fire_on_enemy(mypos,player_list[0]["primary-weapon"]["name"],player_list[0]["primary-weapon"]["level"],target_PW,mymap)
                            attack_done=True
                        elif (target_SW != mypos and mymap[mypos_x][mypos_y] != 'S'):
                            
                            print("in range SW")
                            print("targetV2_SW: '%s'" % target_SW)
                            #if target==target_SW:
                                # somebody in range of SW
                            fire_on_enemy(mypos,player_list[0]["secondary-weapon"]["name"],player_list[0]["secondary-weapon"]["level"],target_SW,mymap)
                            attack_done=True
                        else:
                            print("not in range PW or SW")
                            #upgrade
                            if check_weaponupgrade(player_list[0]["primary-weapon"]["name"],player_list[0]["primary-weapon"]["level"]):
                                transmitter.upgrade(player_list[0]["primary-weapon"]["name"])
                                
                            elif check_weaponupgrade(player_list[0]["secondary-weapon"]["name"],player_list[0]["secondary-weapon"]["level"]):
                                transmitter.upgrade(player_list[0]["secondary-weapon"]["name"])
                                    #mining if on mine
                            elif resource_needed(player_list[0],mymap[mypos_x][mypos_y]) and resource_map[mypos[0]][mypos[1]]>0: 
                                  
                                print("MINE")
                                print("mypos: '%s'" % mypos)
                                print("Target: '%s'" % target)
                                print("minecount: '%s'" % resource_map[mypos_x][mypos_y])
                                transmitter.mine()
                                resource_map[mypos[0]][mypos[1]] = resource_map[mypos[0]][mypos[1]] - 1

                                print("minecount: '%s'" % resource_map[mypos_x][mypos_y])
                                if (mymap[mypos_x][mypos_y] == 'E' and (player_list[0]["primary-weapon"]["name"]=="mortar" or player_list[0]["secondary-weapon"]["name"]=="mortar")):
                                    global res_exp
                                    res_exp = res_exp + 1
                                elif (mymap[mypos_x][mypos_y] == 'R'and (player_list[0]["primary-weapon"]["name"]=="laser" or player_list[0]["secondary-weapon"]["name"]=="laser")):
                                    global res_rub
                                    res_rub = res_rub + 1
                                elif (mymap[mypos_x][mypos_y] == 'C'and (player_list[0]["primary-weapon"]["name"]=="droid" or player_list[0]["secondary-weapon"]["name"]=="droid")):
                                    global res_scr
                                    res_scr = res_scr + 1
                            else:
                                myactionmap = create_Actionmap(mymap)
                                #valid position will be marked with -1
                                myactionmap = get_resources(mymap,myactionmap,player_list[0])
                                #print("after resources: ")
                                myactionmap = marktargetpositions(mymap,myactionmap,player_list)
                                #print("after targets: ")    
                                #debug_printmap(myactionmap)
                                myactionmap[mypos_x][mypos_y]=0
                                #2do move to target with lowest hp
                                target = wayfind_to_whatever(mymap,myactionmap,mypos,player_list,myturn)
                                print("target: '%s'" % target)
                                #needed to check if to go to runawy mode, so stupid resource burning 2do
                                target=find_next_tilde_to_target_pos(mymap, mypos,target)
                                print("target: '%s'" % target)
                                if mypos == target and mymap[mypos[0]][mypos[1]]=='S':
                                    move_to(mymap,mypos,mypos,player_list, myturn)
                                elif False==moveablepos_forme(mymap,target,player_list):
                                    donothing=1
                                    #sys.exit()
                                #do not touch
                                #stop walking into enemy range
                                if myturn == 3 and (check_if_in_enemy_range(mymap,target,player_list)>0):
                                    if (check_if_in_enemy_range(mymap,mypos,player_list)>0):
                                        escape_tilde = get_tiled_away_from_enemy(mymap,mypos,player_list)
                                        if escape_tilde!=mypos: 
                                            mypos=move_to(mymap,mypos,escape_tilde,player_list, myturn)
                                else:
                                    mypos=move_to(mymap,mypos,target,player_list, myturn)
                                    if mypos!=target:
                                        runaway=True
                                            
                                #print("new: '%s'" % mypos)
                                
        print("PWL: '%s'" % player_list[0]["primary-weapon"]["level"])
        print("SWL: '%s'" % player_list[0]["secondary-weapon"]["level"])
        print("TURN: '%s'" % myturn)
        for player in player_list:
            print("score: '%s'" % player["score"])

        myscore = player_list[0]["score"]  
        ranking = 0
        for player in player_list:
            if player["name"] != ai_name:
                if player["score"] >= myscore:
                    ranking = ranking + 1
        if ranking == 0:
            print("   ##  ")   
            print(" ####  ")   
            print("   ##  ")  
            print("   ##  ")   
            print("   ##  ")   
            print("   ##  ")   
            print(" ######")
        elif ranking == 1:
            print("  ####### ")   
            print(" ##     ##")   
            print("        ##")  
            print("  ####### ")   
            print(" ##       ")   
            print(" ##       ")   
            print(" #########") 
        elif ranking == 2:
            print("  #######  ")   
            print(" ##     ## ")   
            print("        ## ")  
            print("  #######  ")   
            print("        ## ")   
            print(" ##     ## ")   
            print("  #######  ") 
    else:   #monitor enemy movement
        global enemy_pos
        enemy_pos = string_to_position(player_list[0]["position"])

def one_hit(mymap,mypos,player_list,myturn,target):
    result = False
    health=get_target_health(player_list,target)
    for player_bla in player_list:
        
        if target == string_to_position(player_bla["position"]):
            player=player_bla

            if target==inRange_V3(mymap,mypos,player_list,myturn,False,"PW") and health <= calc_dmg(dmgDict[player["primary-weapon"]["name"]][player["primary-weapon"]["level"]], 3-myturn):
                result=True
            elif target==inRange_V3(mymap,mypos,player_list,myturn,False,"SW") and health <= calc_dmg(dmgDict[player["secondary-weapon"]["name"]][player["secondary-weapon"]["level"]], 3-myturn):
                result=True
       
    return result

def one_hit_reachable(mymap,mypos,player_list,myturn):
    print("one_hit_reachable?");
    result = mypos
    xmax = len(mymap)
    ymax = len(mymap[0])

    found = False
    action_count = 0
    actionmap = create_Actionmap(mymap)
    actionmap[mypos[0]][mypos[1]] = 0
    didsomething = True   
    while(not found and didsomething and action_count<=(3-myturn)):
        didsomething = False
        for x in range(0, xmax):
            for y in range(0, ymax):
                if actionmap[x][y] == action_count:
                    
                    if x > 0 and y > 0:
                        if moveablepos_forme(mymap,[x-1,y-1],player_list):
                            actionmap[x-1][y-1] = set_actioncount(actionmap[x][y], actionmap[x-1][y-1], mymap[x-1][y-1])
                            didsomething=True
                    if x > 0:
                        if moveablepos_forme(mymap,[x-1,y],player_list):
                            actionmap[x-1][y] = set_actioncount(actionmap[x][y], actionmap[x-1][y], mymap[x-1][y])
                            didsomething=True
                    if y < ymax-1:
                        if moveablepos_forme(mymap,[x,y+1],player_list):
                            actionmap[x][y+1] = set_actioncount(actionmap[x][y], actionmap[x][y+1], mymap[x][y+1])
                            didsomething=True
                    if x < xmax-1 and y < ymax-1:
                        if moveablepos_forme(mymap,[x+1,y+1],player_list):
                            actionmap[x+1][y+1] = set_actioncount(actionmap[x][y], actionmap[x+1][y+1], mymap[x+1][y+1])
                            didsomething=True
                    if x < xmax-1:
                        if moveablepos_forme(mymap,[x+1,y],player_list):
                            actionmap[x+1][y] = set_actioncount(actionmap[x][y], actionmap[x+1][y], mymap[x+1][y])
                            didsomething=True
                    if y > 0:
                        if moveablepos_forme(mymap,[x,y-1],player_list):
                            actionmap[x][y-1] = set_actioncount(actionmap[x][y], actionmap[x][y-1], mymap[x][y-1])
                            didsomething=True
                    if actionmap[x][y] == action_count:
                        mypos_dummy=[x,y]
                        target=inRange_V3(mymap,mypos_dummy,player_list,myturn+action_count,False,"all")
                        if (target!=mypos_dummy and one_hit(mymap,mypos_dummy,player_list,myturn+action_count,target)):
                            result=[x,y]
                            found = True

        action_count=action_count+1
        
    return result


def resource_needed(player,resource):
    result = False
    if resource == 'E':
        if (player["primary-weapon"]["name"]=="mortar" and player["primary-weapon"]["level"] < 3):
            result=True
        if (player["secondary-weapon"]["name"]=="mortar" and player["secondary-weapon"]["level"] < 3):
            result=True
    elif resource == 'R':
        if (player["primary-weapon"]["name"]=="laser" and player["primary-weapon"]["level"] < 3):
            result=True
        if (player["secondary-weapon"]["name"]=="laser" and player["secondary-weapon"]["level"] < 3):
            result=True
    elif resource == 'C':
        if (player["primary-weapon"]["name"]=="droid" and player["primary-weapon"]["level"] < 3):
            result=True
        if (player["secondary-weapon"]["name"]=="droid" and player["secondary-weapon"]["level"] < 3):
            result=True
    return result


def find_better_pos(mymap,mypos,player_list,myturn):
    print("find_better_pos")
    x=mypos[0]
    y=mypos[1]
    xmax = len(mymap)
    ymax = len(mymap[0])
    result=mypos
    if mymap[mypos[0]][mypos[1]]=='S':
        in_range_of_enemy_count=9999
    else:
        in_range_of_enemy_count=check_if_in_enemy_range(mymap,[x,y],player_list)
    enemys_in_range=1
    if x > 0 and y > 0:
        print("check 1")
        dummy=[x-1,y-1]
        if moveablepos_forme(mymap,dummy,player_list):
            in_range_of_enemy_count_dummy=check_if_in_enemy_range(mymap,dummy,player_list)
            if in_range_of_enemy_count_dummy < in_range_of_enemy_count:
                enemys_in_range_dummy=inRange_V3(mymap,dummy,player_list,myturn,True,"all")
                if enemys_in_range_dummy >= enemys_in_range:
                    enemys_in_range = enemys_in_range_dummy
                    in_range_of_enemy_count = in_range_of_enemy_count_dummy
                    result=[x-1,y-1]
    if x > 0:
        dummy=[x-1,y]
        print("check 2")
        if moveablepos_forme(mymap,dummy,player_list):
            in_range_of_enemy_count_dummy=check_if_in_enemy_range(mymap,dummy,player_list)
            if in_range_of_enemy_count_dummy < in_range_of_enemy_count:
                enemys_in_range_dummy=inRange_V3(mymap,dummy,player_list,myturn,True,"all")
                if enemys_in_range_dummy >= enemys_in_range:
                    enemys_in_range = enemys_in_range_dummy
                    in_range_of_enemy_count = in_range_of_enemy_count_dummy
                    result=[x-1,y]
    if y < ymax-1:
        print("check 3")
        dummy=[x,y+1]
        if moveablepos_forme(mymap,dummy,player_list):
            in_range_of_enemy_count_dummy=check_if_in_enemy_range(mymap,dummy,player_list)
            if in_range_of_enemy_count_dummy < in_range_of_enemy_count:
                enemys_in_range_dummy=inRange_V3(mymap,dummy,player_list,myturn,True,"all")
                if enemys_in_range_dummy >= enemys_in_range:
                    enemys_in_range = enemys_in_range_dummy
                    in_range_of_enemy_count = in_range_of_enemy_count_dummy
                    result=[x,y+1]
    if x < xmax-1 and y < ymax-1:
        print("check 4")
        dummy=[x+1,y+1]
        if moveablepos_forme(mymap,dummy,player_list):
            in_range_of_enemy_count_dummy=check_if_in_enemy_range(mymap,dummy,player_list)
            if in_range_of_enemy_count_dummy < in_range_of_enemy_count:
                enemys_in_range_dummy=inRange_V3(mymap,dummy,player_list,myturn,True,"all")
                if enemys_in_range_dummy >= enemys_in_range:
                    enemys_in_range = enemys_in_range_dummy
                    in_range_of_enemy_count = in_range_of_enemy_count_dummy
                    result=[x+1,y+1]
    if x < xmax-1:
        print("check 5")
        dummy=[x+1,y]
        if moveablepos_forme(mymap,dummy,player_list):
            in_range_of_enemy_count_dummy=check_if_in_enemy_range(mymap,dummy,player_list)
            if in_range_of_enemy_count_dummy < in_range_of_enemy_count:
                enemys_in_range_dummy=inRange_V3(mymap,dummy,player_list,myturn,True,"all")
                if enemys_in_range_dummy >= enemys_in_range:
                    enemys_in_range = enemys_in_range_dummy
                    in_range_of_enemy_count = in_range_of_enemy_count_dummy
                    result=[x+1,y]
    if y > 0:
        print("check 6")
        dummy=[x,y-1]
        if moveablepos_forme(mymap,dummy,player_list):
            in_range_of_enemy_count_dummy=check_if_in_enemy_range(mymap,dummy,player_list)
            if in_range_of_enemy_count_dummy < in_range_of_enemy_count:
                enemys_in_range_dummy=inRange_V3(mymap,dummy,player_list,myturn,True,"all")
                if enemys_in_range_dummy >= enemys_in_range:
                    enemys_in_range = enemys_in_range_dummy
                    in_range_of_enemy_count = in_range_of_enemy_count_dummy
                    result=[x,y-1]
    print("mypos = %s" % mypos)
    print("result = %s" % result)
    return result

 




        
def get_target_health(player_list,target):
    health = 100
    for player in player_list:
        if target == string_to_position(player["position"]):
            health=player["health"]
    return health

def get_target_dmg(player_list,target,turn):
    dmg = 0
    for player in player_list:
        if target == string_to_position(player["position"]):
            dmg = calc_dmg(dmgDict[player["primary-weapon"]["name"]][player["primary-weapon"]["level"]], (3 - turn))
    return dmg
                            
def check_weaponupgrade(weapon,lvl):
    global res_exp
    global res_rub
    global res_scr

    possible = False
    if weapon == "mortar":
        if lvl==1 and res_exp >= 4:
            possible = True
        elif lvl==2 and res_exp >= 5:
            possible = True
        if possible:
            res_exp = 0
    elif weapon == "laser":
        if lvl==1 and res_rub >= 4:
            possible = True
        elif lvl==2 and res_rub >= 5:
            possible = True
        if possible:
            res_rub = 0
    elif weapon == "droid":
        if lvl==1 and res_scr >= 4:
            possible = True
        elif lvl==2 and res_scr >= 5:
            possible = True
        if possible:
            res_scr = 0
    return possible

def checklaser(position, target, weaponrange, wayx, wayy, mymap):
    print("check laser");
    inrange = False
    xmax = len(mymap)
    ymax = len(mymap[0])

    for i in range(1, weaponrange+1):
        if 0 <= position[0]+(i*wayx) and position[0]+(i*wayx) < xmax and 0 <= position[1]+(i*wayy) and position[1]+(i*wayy) < ymax:
            if position[0]+(i*wayx)==target[0] and position[1]+(i*wayy)==target[1]:
                inrange = True
                print("check laser inrange");

                break
            elif mymap[position[0]+(i*wayx)][position[1]+(i*wayy)]=='O':
                inrange = False
                break
        else:
            inrange = False
            break
        
    return inrange

def moveablepos(pos):
    moveable = False
    if pos == 'G' or pos == 'E' or pos == 'R' or pos == 'C':
        moveable = True

    return moveable

def moveablepos_forme(mymap,position,player_list):
    moveable = False
    pos=mymap[position[0]][position[1]]
    if pos == 'G' or pos == 'E' or pos == 'R' or pos == 'C':
        moveable = True
        for player in player_list:
            player_pos = string_to_position(player["position"])
            if player["name"] != ai_name:
                if player_pos==position:
                    moveable = False
    return moveable


    

def firedroid(position, target, weaponrange, mymap):
    #print("check droid");
    actionmap = create_Actionmap(mymap)
    xmax = len(mymap)
    ymax = len(mymap[0])
    found = False
    action_count = 0
    actionmap[position[0]][position[1]] = 0
    while(not found):
        for x in range(0, xmax):
            for y in range(0, ymax):
                if actionmap[x][y] == action_count:
                    if x == target[0] and y == target[1]:
                        found = True
                    if x > 0 and y > 0:
                        if moveablepos(mymap[x-1][y-1]):
                            actionmap[x-1][y-1] = set_actioncount(actionmap[x][y],actionmap[x-1][y-1],mymap[x-1][y-1])
                    if x > 0:
                        if moveablepos(mymap[x-1][y]):
                            actionmap[x-1][y] = set_actioncount(actionmap[x][y],actionmap[x-1][y],mymap[x-1][y])
                    if y < ymax-1:
                        if moveablepos(mymap[x][y+1]):
                            actionmap[x][y+1] = set_actioncount(actionmap[x][y],actionmap[x][y+1],mymap[x][y+1])
                    if x < xmax-1 and y < ymax-1:
                        if moveablepos(mymap[x+1][y+1]):
                            actionmap[x+1][y+1] = set_actioncount(actionmap[x][y],actionmap[x+1][y+1],mymap[x+1][y+1])
                    if x < xmax-1:
                        if moveablepos(mymap[x+1][y]):
                            actionmap[x+1][y] = set_actioncount(actionmap[x][y],actionmap[x+1][y],mymap[x+1][y])
                    if y > 0:
                        if moveablepos(mymap[x][y-1]):
                            actionmap[x][y-1] = set_actioncount(actionmap[x][y],actionmap[x][y-1],mymap[x][y-1])
                    if mymap[x][y] == 'V' or mymap[x][y] == 'S' or mymap[x][y] == 'O':
                        donothing = 0
        if action_count > weaponrange:
            print("position = %s" % position);
            print("target = %s" % target);
            print("actionmap = %s" % actionmap);
            #sys.exit()  #2do debug!
        action_count = action_count + 1
    action_count = action_count - 1
    x=target[0]
    y=target[1]
    sequenze=[]


    while(action_count>0):
        didsomething = False
        
        #print("result: '%s'" % result)
        if x > 0 and y > 0 and not didsomething:
            if actionmap[x-1][y-1] < action_count:
                x=x-1
                y=y-1
                sequenze.insert(0,"down")
                didsomething = True
        if x > 0 and not didsomething:
            if actionmap[x-1][y] < action_count:
                x=x-1
                sequenze.insert(0,"left-down")
                didsomething = True
        if y < ymax-1 and not didsomething:
            if actionmap[x][y+1] < action_count:
                y=y+1
                sequenze.insert(0,"left-up")
                didsomething = True
        if x < xmax-1 and y < ymax-1 and not didsomething:
            if actionmap[x+1][y+1] < action_count:
                x=x+1
                y=y+1
                sequenze.insert(0,"up")
                didsomething = True
        if x < xmax-1 and not didsomething:
            if actionmap[x+1][y] < action_count:
                x=x+1
                sequenze.insert(0,"right-up")
                didsomething = True
        if y > 0 and not didsomething:
            if actionmap[x][y-1] < action_count:
                y=y-1
                sequenze.insert(0,"right-down")
                didsomething = True
        action_count = action_count - 1
    print("sequenz = %s" % sequenze);
    return sequenze

#2do merge checkdroid and checkmortar
def checkdroid(position, weaponrange, mymap, player_list):
    print("check droid");
    actionmap = create_Actionmap(mymap)
    xmax = len(mymap)
    ymax = len(mymap[0])
    action_count = 0
    actionmap[position[0]][position[1]] = 0
    while(action_count <= weaponrange):
        for x in range(0, xmax):
            for y in range(0, ymax):
                if actionmap[x][y] == action_count:
                    if x > 0 and y > 0:
                        if moveablepos(mymap[x-1][y-1]):
                            actionmap[x-1][y-1] = set_actioncount(actionmap[x][y],actionmap[x-1][y-1],mymap[x-1][y-1])
                    if x > 0:
                        if moveablepos(mymap[x-1][y]):
                            actionmap[x-1][y] = set_actioncount(actionmap[x][y],actionmap[x-1][y],mymap[x-1][y])
                    if y < ymax-1:
                        if moveablepos(mymap[x][y+1]):
                            actionmap[x][y+1] = set_actioncount(actionmap[x][y],actionmap[x][y+1],mymap[x][y+1])
                    if x < xmax-1 and y < ymax-1:
                        if moveablepos(mymap[x+1][y+1]):
                            actionmap[x+1][y+1] = set_actioncount(actionmap[x][y],actionmap[x+1][y+1],mymap[x+1][y+1])
                    if x < xmax-1:
                        if moveablepos(mymap[x+1][y]):
                            actionmap[x+1][y] = set_actioncount(actionmap[x][y],actionmap[x+1][y],mymap[x+1][y])
                    if y > 0:
                        if moveablepos(mymap[x][y-1]):
                            actionmap[x][y-1] = set_actioncount(actionmap[x][y],actionmap[x][y-1],mymap[x][y-1])
                    if mymap[x][y] == 'V' or mymap[x][y] == 'S' or mymap[x][y] == 'O':
                        donothing = 0

        action_count = action_count + 1

    target = position
    target_hp = 99999
    for player in player_list:
        player_pos = string_to_position(player["position"])
        if player["name"] != ai_name:
            if player["health"] > 0:
                if 1 < actionmap[player_pos[0]][player_pos[1]] and actionmap[player_pos[0]][player_pos[1]] <= weaponrange and player["health"] < target_hp:
                    target_hp = player["health"]
                    target = player_pos
                                
    return target

def checkmortar(position, weaponrange, mymap, player_list):
    print("check mortar");
    actionmap = create_Actionmap(mymap)
    xmax = len(mymap)
    ymax = len(mymap[0])
    action_count = 0
    actionmap[position[0]][position[1]] = 0
    while(action_count <= weaponrange):
        for x in range(0, xmax):
            for y in range(0, ymax):
                if actionmap[x][y] == action_count:
                    if x > 0 and y > 0:
                        actionmap[x-1][y-1] = set_actioncount_mortar(actionmap[x][y],actionmap[x-1][y-1],mymap[x-1][y-1])
                    if x > 0:
                        actionmap[x-1][y] = set_actioncount_mortar(actionmap[x][y],actionmap[x-1][y],mymap[x-1][y])
                    if y < ymax-1:
                        actionmap[x][y+1] = set_actioncount_mortar(actionmap[x][y],actionmap[x][y+1],mymap[x][y+1])
                    if x < xmax-1 and y < ymax-1:
                        actionmap[x+1][y+1] = set_actioncount_mortar(actionmap[x][y],actionmap[x+1][y+1],mymap[x+1][y+1])
                    if x < xmax-1:
                        actionmap[x+1][y] = set_actioncount_mortar(actionmap[x][y],actionmap[x+1][y],mymap[x+1][y])
                    if y > 0:
                        actionmap[x][y-1] = set_actioncount_mortar(actionmap[x][y],actionmap[x][y-1],mymap[x][y-1])
        action_count = action_count + 1

    target = position
    target_hp = 99999
    for player in player_list:
        player_pos = string_to_position(player["position"])
        if player["name"] != ai_name:
            if player["health"] > 0:
                if 1 < actionmap[player_pos[0]][player_pos[1]] and actionmap[player_pos[0]][player_pos[1]] <= weaponrange and player["health"] < target_hp:
                    target_hp = player["health"]
                    target = player_pos

    return target


def inRange_V3(mymap,mypos,player_list,turn,count,weapon):
    #2do weapon performance tweak
    print("inrange V3");
    xmax = len(mymap)
    ymax = len(mymap[0])
    result = mymap

    targetmap_PW = create_Actionmap(mymap)
    targetmap_SW = create_Actionmap(mymap)
    targetmap_PW[mypos[0]][mypos[1]] = 0
    targetmap_SW[mypos[0]][mypos[1]] = 0
            
    PW_range = rangeDict[player_list[0]["primary-weapon"]["name"]][player_list[0]["primary-weapon"]["level"]]
    SW_range = rangeDict[player_list[0]["secondary-weapon"]["name"]][player_list[0]["secondary-weapon"]["level"]]
            
    if (weapon=="all" or weapon=="PW"):
        if player_list[0]["primary-weapon"]["name"] == "droid":
            targetmap_PW = markdroid_helper(mymap,targetmap_PW,PW_range)
        elif player_list[0]["primary-weapon"]["name"] == "mortar":
            targetmap_PW = markmortar_helper(mymap,targetmap_PW,PW_range)
        elif player_list[0]["primary-weapon"]["name"] == "laser":
            targetmap_PW = marklaser_helper(mymap, targetmap_PW, PW_range, mypos, -1, -1)
            targetmap_PW = marklaser_helper(mymap, targetmap_PW, PW_range, mypos, -1,  0)
            targetmap_PW = marklaser_helper(mymap, targetmap_PW, PW_range, mypos,  0, +1)
            targetmap_PW = marklaser_helper(mymap, targetmap_PW, PW_range, mypos, +1, +1)
            targetmap_PW = marklaser_helper(mymap, targetmap_PW, PW_range, mypos, +1,  0)
            targetmap_PW = marklaser_helper(mymap, targetmap_PW, PW_range, mypos,  0, -1)
    
    if (weapon=="all" or weapon=="SW"):
        if player_list[0]["secondary-weapon"]["name"] == "droid":
            targetmap_SW = markdroid_helper(mymap,targetmap_SW,SW_range)
        elif player_list[0]["secondary-weapon"]["name"] == "mortar":
            targetmap_SW = markmortar_helper(mymap,targetmap_SW,SW_range)
        elif player_list[0]["secondary-weapon"]["name"] == "laser":
            targetmap_SW = marklaser_helper(mymap, targetmap_SW, SW_range, mypos, -1, -1)
            targetmap_SW = marklaser_helper(mymap, targetmap_SW, SW_range, mypos, -1,  0)
            targetmap_SW = marklaser_helper(mymap, targetmap_SW, SW_range, mypos,  0, +1)
            targetmap_SW = marklaser_helper(mymap, targetmap_SW, SW_range, mypos, +1, +1)
            targetmap_SW = marklaser_helper(mymap, targetmap_SW, SW_range, mypos, +1,  0)
            targetmap_SW = marklaser_helper(mymap, targetmap_SW, SW_range, mypos,  0, -1)

    enemy_count=0
    enemy_hp=99999
    result=mypos
    print("CHECKPOS = %s" % mypos);
    #countplayers and target the one with the lowest hp
    for player in player_list:
        inrange=False
        if player["name"] != ai_name and player["health"] > 0:
            print("name = %s" % player["name"]);
            print("health = %s" % player["health"]);
            player_pos = string_to_position(player["position"])
            if mymap[player_pos[0]][player_pos[1]] != 'S':
                if targetmap_PW[player_pos[0]][player_pos[1]] <= -1 and (weapon=="all" or weapon=="PW"):
                    inrange=True
                elif targetmap_SW[player_pos[0]][player_pos[1]] <= -1 and (weapon=="all" or weapon=="SW"):
                    inrange=True

                if inrange:
                    enemy_count=enemy_count+1
                    if player["health"] < enemy_hp:
                        enemy_hp=player["health"]
                        result=player_pos
                        #debug_printmap(targetmap_PW)
                        #debug_printmap(targetmap_SW)

                        #sys.exit()
            print("player = %s" % player_pos);
            print("resulr = %s" % result);
 

                    
    if count==False:
        #check if a player will die if i hit him
        for player in player_list:
            if player["name"] != ai_name and player["health"] > 0:
                player_pos = string_to_position(player["position"])
                if mymap[player_pos[0]][player_pos[1]] != 'S':
                    if targetmap_PW[player_pos[0]][player_pos[1]] <= -1 and (weapon=="all" or weapon=="PW"):
                        my_dmg=calc_dmg(dmgDict[player_list[0]["primary-weapon"]["name"]][player_list[0]["primary-weapon"]["level"]], (3 - turn))
                        if player["health"] < my_dmg:
                            result=player_pos
         
                    if targetmap_SW[player_pos[0]][player_pos[1]] <= -1 and (weapon=="all" or weapon=="SW"):
                        my_dmg=calc_dmg(dmgDict[player_list[0]["secondary-weapon"]["name"]][player_list[0]["secondary-weapon"]["level"]], (3 - turn))
                        if player["health"] < my_dmg:
                            result=player_pos
                 
 
         
    else:                                           
        result=enemy_count
    print("result = %s" % result);
       
    return result

def fire_on_enemy(position, weapon, level, target, mymap):
    print("fire on enemy");
    #rangeDict = {"mortar":(0,2,3,4), "laser":(0,5,6,7), "droid":(0,3,4,5)}
    
    if weapon == "mortar":
        transmitter.attack_mortar(target[0]-position[0],target[1]-position[1])
    elif weapon == "laser":
        if checklaser(position, target, rangeDict[weapon][level], -1, -1, mymap):
            direction = "up";
        elif checklaser(position, target, rangeDict[weapon][level], -1,  0, mymap):
            direction = "right-up";
        elif checklaser(position, target, rangeDict[weapon][level],  0, +1, mymap):
            direction = "right-down";
        elif checklaser(position, target, rangeDict[weapon][level], +1, +1, mymap):
            direction = "down";
        elif checklaser(position, target, rangeDict[weapon][level], +1,  0, mymap):
            direction = "left-down";
        elif checklaser(position, target, rangeDict[weapon][level],  0, -1, mymap):
            direction = "left-up";            
        transmitter.attack_laser(direction)
    elif weapon == "droid":
        sequence = firedroid(position, target, rangeDict[weapon][level], mymap)
        transmitter.attack_droid(sequence)

def check_if_in_enemy_range(mymap,mypos,player_list):
    print("check if in enemy range");
    xmax = len(mymap)
    ymax = len(mymap[0])
    result = 0
    for player in player_list:
        enemytargetmap = create_Actionmap(mymap)
        player_pos = string_to_position(player["position"])
        if player["name"] != ai_name and player["health"] > 0 and mymap[player_pos[0]][player_pos[1]] != 'S':

            enemytargetmap_PW = create_Actionmap(mymap)
            enemytargetmap_SW = create_Actionmap(mymap)
            enemytargetmap_PW[player_pos[0]][player_pos[1]] = 0
            enemytargetmap_SW[player_pos[0]][player_pos[1]] = 0
            
            #print("name = %s" % player["name"]);
            #print("health = %s" % player["health"]);

            PW_range = rangeDict[player["primary-weapon"]["name"]][player["primary-weapon"]["level"]]
            SW_range = rangeDict[player["secondary-weapon"]["name"]][player["secondary-weapon"]["level"]]
            
            #print("PW = %s" % player["primary-weapon"]["name"]);
            #print("PWR = %s" % PW_range);
            #print("SW = %s" % player["secondary-weapon"]["name"]);
            #print("SWR = %s" % SW_range);

            if player["primary-weapon"]["name"] == "droid":
                enemytargetmap_PW = markdroid_helper(mymap,enemytargetmap_PW,PW_range)
            elif player["secondary-weapon"]["name"] == "droid":
                enemytargetmap_SW = markdroid_helper(mymap,enemytargetmap_SW,SW_range)
                
            if player["primary-weapon"]["name"] == "mortar":
                enemytargetmap_PW = markmortar_helper(mymap,enemytargetmap_PW,PW_range)
            elif player["secondary-weapon"]["name"] == "mortar":
                enemytargetmap_SW = markmortar_helper(mymap,enemytargetmap_SW,SW_range)
                
            if player["primary-weapon"]["name"] == "laser":
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, -1, -1)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, -1,  0)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos,  0, +1)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, +1, +1)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, +1,  0)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos,  0, -1)
            elif player["secondary-weapon"]["name"] == "laser":
                print("checking laser")
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, -1, -1)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, -1,  0)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos,  0, +1)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, +1, +1)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, +1,  0)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos,  0, -1)

            for x in range(0, xmax):
                for y in range(0, ymax):
                    if enemytargetmap_PW[x][y] <= -1: 
                        enemytargetmap[x][y] = enemytargetmap_PW[x][y]
                    if enemytargetmap_SW[x][y] <= -1:
                        enemytargetmap[x][y] = enemytargetmap_SW[x][y]

            x=mypos[0]
            y=mypos[1]
            if enemytargetmap[x][y]<=-1:
                result = result + 1

    print("count = %s" % result);
    return result


def get_tiled_away_from_enemy(mymap,mypos,player_list):
    print("get tiled_away_from_enemy");
    result = mypos
    enemytargetmap = create_Actionmap(mymap)
    enemymovmentmap = create_Actionmap(mymap)
    xmax = len(mymap)
    ymax = len(mymap[0])
    for player in player_list:
        player_pos = string_to_position(player["position"])
        if player["name"] !=ai_name and player["health"] > 0 and mymap[player_pos[0]][player_pos[1]] != 'S':
            
            enemymovmentmap[player_pos[0]][player_pos[1]]=0
            enemytargetmap_PW = create_Actionmap(mymap)
            enemytargetmap_SW = create_Actionmap(mymap)
            enemytargetmap_PW[player_pos[0]][player_pos[1]] = 0
            enemytargetmap_SW[player_pos[0]][player_pos[1]] = 0
            
            print("name = %s" % player["name"]);
            print("health = %s" % player["health"]);

            PW_range = rangeDict[player["primary-weapon"]["name"]][player["primary-weapon"]["level"]]
            SW_range = rangeDict[player["secondary-weapon"]["name"]][player["secondary-weapon"]["level"]]
            
            print("PW = %s" % player["primary-weapon"]["name"]);
            print("PWR = %s" % PW_range);
            print("SW = %s" % player["secondary-weapon"]["name"]);
            print("SWR = %s" % SW_range);

            if player["primary-weapon"]["name"] == "droid":
                enemytargetmap_PW = markdroid_helper(mymap,enemytargetmap_PW,PW_range)
            elif player["secondary-weapon"]["name"] == "droid":
                enemytargetmap_SW = markdroid_helper(mymap,enemytargetmap_SW,SW_range)
                
            if player["primary-weapon"]["name"] == "mortar":
                enemytargetmap_PW = markmortar_helper(mymap,enemytargetmap_PW,PW_range)
            elif player["secondary-weapon"]["name"] == "mortar":
                enemytargetmap_SW = markmortar_helper(mymap,enemytargetmap_SW,SW_range)
                
            if player["primary-weapon"]["name"] == "laser":
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, -1, -1)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, -1,  0)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos,  0, +1)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, +1, +1)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos, +1,  0)
                enemytargetmap_PW = marklaser_helper(mymap, enemytargetmap_PW, PW_range, player_pos,  0, -1)
            elif player["secondary-weapon"]["name"] == "laser":
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, -1, -1)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, -1,  0)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos,  0, +1)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, +1, +1)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos, +1,  0)
                enemytargetmap_SW = marklaser_helper(mymap, enemytargetmap_SW, SW_range, player_pos,  0, -1)

            #inverting because actioncounts higher means farer away
            for x in range(0, xmax):
                for y in range(0, ymax):
                    if enemytargetmap_PW[x][y] <= -1: 
                        enemytargetmap[x][y] = enemytargetmap_PW[x][y]*-1
                    if enemytargetmap_SW[x][y] <= -1:
                        enemytargetmap[x][y] = enemytargetmap_SW[x][y]*-1

            #debug_printmap(enemytargetmap)

    max_actioncount=enemymovmentmap[mypos[0]][mypos[1]]+1
    action_count = 1
    didsomething = True
    while(didsomething and action_count <= max_actioncount):
        didsomething = False
        for x in range(0, xmax):
            for y in range(0, ymax):
                if enemymovmentmap[x][y] == action_count:
                    
                    if x > 0 and y > 0:
                        enemymovmentmap[x-1][y-1] = set_actioncount(enemymovmentmap[x][y], enemymovmentmap[x-1][y-1], mymap[x-1][y-1])
                        didsomething=True
                    if x > 0:
                        enemymovmentmap[x-1][y] = set_actioncount(enemymovmentmap[x][y], enemymovmentmap[x-1][y], mymap[x-1][y])
                        didsomething=True
                    if y < ymax-1:
                        enemymovmentmap[x][y+1] = set_actioncount(enemymovmentmap[x][y], enemymovmentmap[x][y+1], mymap[x][y+1])
                        didsomething=True
                    if x < xmax-1 and y < ymax-1:
                        enemymovmentmap[x+1][y+1] = set_actioncount(enemymovmentmap[x][y], enemymovmentmap[x+1][y+1], mymap[x+1][y+1])
                        didsomething=True
                    if x < xmax-1:
                        enemymovmentmap[x+1][y] = set_actioncount(enemymovmentmap[x][y], enemymovmentmap[x+1][y], mymap[x+1][y])
                        didsomething=True
                    if y > 0:
                        enemymovmentmap[x][y-1] = set_actioncount(enemymovmentmap[x][y], enemymovmentmap[x][y-1], mymap[x][y-1])
                        didsomething=True

        action_count=action_count+1

    x=mypos[0]
    y=mypos[1]
    result = mypos
    action_count=0
    
    if x > 0 and y > 0:
        if enemytargetmap[x-1][y-1] > 0 and enemymovmentmap[x-1][y-1] > action_count:
            action_count=enemytargetmap[x-1][y-1]
            result=[x-1,y-1]
    if x > 0:
        if enemytargetmap[x-1][y] > 0 and enemymovmentmap[x-1][y] > action_count:
            action_count=enemytargetmap[x-1][y]
            result=[x-1,y]
    if y < ymax-1:
        if enemytargetmap[x][y+1] > 0 and enemymovmentmap[x][y+1] > action_count:
            action_count=enemytargetmap[x][y+1]
            result=[x,y+1]
    if x < xmax-1 and y < ymax-1:
        if enemytargetmap[x+1][y+1] > 0 and enemymovmentmap[x+1][y+1] > action_count:
            action_count=enemytargetmap[x+1][y+1]
            result=[x+1,y+1]
    if x < xmax-1:
        if enemytargetmap[x+1][y] > 0 and enemymovmentmap[x+1][y] > action_count:
            action_count=enemytargetmap[x+1][y]
            result=[x+1,y]
    if y > 0:
        if enemytargetmap[x][y-1] > 0 and enemymovmentmap[x][y-1] > action_count:
            action_count=enemytargetmap[x][y-1]
            result=[x,y-1]
          
    #debug_printmap(actionmap)
    #print("target: '%s'" % result)
    return result

def moveable_escape(mymap, actionmap, pos, player_list):
    result = False
    if moveablepos_forme(mymap,pos,player_list) and actionmap[pos[0]][pos[1]] > -1:
        result = True
    return result

    
def marktargetpositions(mymap,enemytargetmap,player_list):
    xmax = len(mymap)
    ymax = len(mymap[0])
    print("marktargetpositions");
    PW_range = rangeDict[player_list[0]["primary-weapon"]["name"]][player_list[0]["primary-weapon"]["level"]]
    SW_range = rangeDict[player_list[0]["secondary-weapon"]["name"]][player_list[0]["secondary-weapon"]["level"]]
    distance=999
    if player_list[0]["primary-weapon"]["name"] == "mortar":
        enemytargetmap = markmortar(mymap,enemytargetmap,player_list,PW_range)
    elif player_list[0]["secondary-weapon"]["name"] == "mortar":
        enemytargetmap = markmortar(mymap,enemytargetmap,player_list,SW_range)
    if player_list[0]["primary-weapon"]["name"] == "droid":
        enemytargetmap = markdroid(mymap,enemytargetmap,player_list,PW_range)
    elif player_list[0]["secondary-weapon"]["name"] == "droid":
        enemytargetmap = markdroid(mymap,enemytargetmap,player_list,SW_range)
    if player_list[0]["primary-weapon"]["name"] == "laser":
        enemytargetmap = marklaser(mymap,enemytargetmap,player_list,PW_range)
    elif player_list[0]["secondary-weapon"]["name"] == "laser":
        enemytargetmap = marklaser(mymap,enemytargetmap,player_list,SW_range)

    return enemytargetmap

def wayfind_to_whatever(mymap,enemytargetmap, mypos,player_list,myturn):
    print("wayfind_to_whatever");
    result = mypos
    xmax = len(mymap)
    ymax = len(mymap[0])

    found = False
    action_count = 0
    actionmap = create_Actionmap(mymap)
    actionmap[mypos[0]][mypos[1]] = 0
    didsomething = True
    #actual_target_prio = 0
    enemys_in_my_target=0
    enemys_that_have_me_in_target=99999
    target_hp=99999
    in_range_of_enemy_count=9999
   
    while(not found and didsomething):
        didsomething = False
        for x in range(0, xmax):
            for y in range(0, ymax):
                if actionmap[x][y] == action_count:
                    
                    if x > 0 and y > 0:
                        actionmap[x-1][y-1] = set_actioncount(actionmap[x][y], actionmap[x-1][y-1], mymap[x-1][y-1])
                        didsomething=True
                    if x > 0:
                        actionmap[x-1][y] = set_actioncount(actionmap[x][y], actionmap[x-1][y], mymap[x-1][y])
                        didsomething=True
                    if y < ymax-1:
                        actionmap[x][y+1] = set_actioncount(actionmap[x][y], actionmap[x][y+1], mymap[x][y+1])
                        didsomething=True
                    if x < xmax-1 and y < ymax-1:
                        actionmap[x+1][y+1] = set_actioncount(actionmap[x][y], actionmap[x+1][y+1], mymap[x+1][y+1])
                        didsomething=True
                    if x < xmax-1:
                        actionmap[x+1][y] = set_actioncount(actionmap[x][y], actionmap[x+1][y], mymap[x+1][y])
                        didsomething=True
                    if y > 0:
                        actionmap[x][y-1] = set_actioncount(actionmap[x][y], actionmap[x][y-1], mymap[x][y-1])
                        didsomething=True
                    if moveablepos_forme(mymap,[x,y],player_list) and enemytargetmap[x][y] <= -1: #and enemytargetmap[x][y] <= actual_target_prio:
                        enemys_that_have_me_in_target_dummy=check_if_in_enemy_range(mymap,[x,y],player_list)
                        if enemys_that_have_me_in_target_dummy <= enemys_that_have_me_in_target:
                            enemys_in_my_target_dummy=inRange_V3(mymap,[x,y],player_list,myturn,True,"all")
                            if enemys_in_my_target<=enemys_in_my_target_dummy:
                                enemys_that_have_me_in_target=enemys_that_have_me_in_target_dummy
                                enemys_in_my_target=enemys_in_my_target_dummy
                                #actual_target_prio = enemytargetmap[x][y]
                                result=[x,y]
                                found = True

        action_count=action_count+1
        
    #debug_printmap(actionmap)
    #print("target: '%s'" % result)
    return result
        
def markmortar(mymap,enemytargetmap,player_list,Weapon_range):
    print("mark mortar");
    for player in player_list:
        player_pos = string_to_position(player["position"])
        if player["name"] != ai_name and player["health"] > 0 and mymap[player_pos[0]][player_pos[1]] != 'S':
            enemytargetmap[player_pos[0]][player_pos[1]] = 0
    enemytargetmap = markmortar_helper(mymap,enemytargetmap,Weapon_range)
    return enemytargetmap

def markmortar_helper(mymap,enemytargetmap,Weapon_range):
    xmax = len(mymap)
    ymax = len(mymap[0])
    action_count = 0
    while(action_count < Weapon_range):  # because lastcycle+1 = weaponrange
        for x in range(0, xmax):
            for y in range(0, ymax):
                if enemytargetmap[x][y] == action_count:             
                    if x > 0 and y > 0:
                        enemytargetmap[x-1][y-1] = set_actioncount_mortar(enemytargetmap[x][y],enemytargetmap[x-1][y-1],mymap[x-1][y-1])
                    if x > 0:
                        enemytargetmap[x-1][y] = set_actioncount_mortar(enemytargetmap[x][y],enemytargetmap[x-1][y],mymap[x-1][y])
                    if y < ymax-1:
                        enemytargetmap[x][y+1] = set_actioncount_mortar(enemytargetmap[x][y],enemytargetmap[x][y+1],mymap[x][y+1])
                    if x < xmax-1 and y < ymax-1:
                        enemytargetmap[x+1][y+1] = set_actioncount_mortar(enemytargetmap[x][y],enemytargetmap[x+1][y+1],mymap[x+1][y+1])
                    if x < xmax-1:
                        enemytargetmap[x+1][y] = set_actioncount_mortar(enemytargetmap[x][y],enemytargetmap[x+1][y],mymap[x+1][y])
                    if y > 0:
                        enemytargetmap[x][y-1] = set_actioncount_mortar(enemytargetmap[x][y],enemytargetmap[x][y-1],mymap[x][y-1])
        action_count = action_count + 1
        
    for x in range(0, xmax):
        for y in range(0, ymax):
            if  0 <= enemytargetmap[x][y] and enemytargetmap[x][y] <= 1:
                enemytargetmap[x][y] = 0#-1 * enemytargetmap[x][y]
            elif  2 <= enemytargetmap[x][y] and enemytargetmap[x][y] <= Weapon_range:
                enemytargetmap[x][y] = -1 * enemytargetmap[x][y]
        
    return enemytargetmap

#same as checkmortar! only set_Actioncount instead of set_actioncount_mortar
def markdroid(mymap,enemytargetmap,player_list,Weapon_range):
    print("mark droid");
    for player in player_list:
        player_pos = string_to_position(player["position"])
        if player["name"] != ai_name and player["health"] > 0 and mymap[player_pos[0]][player_pos[1]] != 'S':
            enemytargetmap[player_pos[0]][player_pos[1]] = 0

    enemytargetmap = markdroid_helper(mymap,enemytargetmap,Weapon_range)
    return enemytargetmap


def markdroid_helper(mymap,enemytargetmap,Weapon_range):
    #print("mark droid helper");
    #print("Weapon_range = %s" % Weapon_range);
    xmax = len(mymap)
    ymax = len(mymap[0])
    action_count = 0
    #debug_printmap(enemytargetmap)

    while(action_count < Weapon_range):  # because lastcycle+1 = weaponrange
        for x in range(0, xmax):
            for y in range(0, ymax):
                if enemytargetmap[x][y] == action_count:             
                    if x > 0 and y > 0:
                        enemytargetmap[x-1][y-1] = set_actioncount(enemytargetmap[x][y],enemytargetmap[x-1][y-1],mymap[x-1][y-1])
                    if x > 0:
                        enemytargetmap[x-1][y] = set_actioncount(enemytargetmap[x][y],enemytargetmap[x-1][y],mymap[x-1][y])
                    if y < ymax-1:
                        enemytargetmap[x][y+1] = set_actioncount(enemytargetmap[x][y],enemytargetmap[x][y+1],mymap[x][y+1])
                    if x < xmax-1 and y < ymax-1:
                        enemytargetmap[x+1][y+1] = set_actioncount(enemytargetmap[x][y],enemytargetmap[x+1][y+1],mymap[x+1][y+1])
                    if x < xmax-1:
                        enemytargetmap[x+1][y] = set_actioncount(enemytargetmap[x][y],enemytargetmap[x+1][y],mymap[x+1][y])
                    if y > 0:
                        enemytargetmap[x][y-1] = set_actioncount(enemytargetmap[x][y],enemytargetmap[x][y-1],mymap[x][y-1])
        action_count = action_count + 1
    #debug_printmap(enemytargetmap)    
    for x in range(0, xmax):
        for y in range(0, ymax):
            if  0 <= enemytargetmap[x][y] and enemytargetmap[x][y] <= 1: 
                enemytargetmap[x][y] = 0#-1 * enemytargetmap[x][y]
            elif  2 <= enemytargetmap[x][y] and enemytargetmap[x][y] <= Weapon_range:
                enemytargetmap[x][y] = -1 * enemytargetmap[x][y]
    #debug_printmap(enemytargetmap)
    return enemytargetmap

def marklaser(mymap,enemytargetmap,player_list,Weapon_range):
    print("mark laser");
    xmax = len(mymap)
    ymax = len(mymap[0])
    action_count = 0
    for player in player_list:
        player_pos = string_to_position(player["position"])
        if player["name"] != ai_name and player["health"] > 0 and mymap[player_pos[0]][player_pos[1]] != 'S':
                enemytargetmap = marklaser_helper(mymap, enemytargetmap, Weapon_range, player_pos, -1, -1)
                enemytargetmap = marklaser_helper(mymap, enemytargetmap, Weapon_range, player_pos, -1,  0)
                enemytargetmap = marklaser_helper(mymap, enemytargetmap, Weapon_range, player_pos,  0, +1)
                enemytargetmap = marklaser_helper(mymap, enemytargetmap, Weapon_range, player_pos, +1, +1)
                enemytargetmap = marklaser_helper(mymap, enemytargetmap, Weapon_range, player_pos, +1,  0)
                enemytargetmap = marklaser_helper(mymap, enemytargetmap, Weapon_range, player_pos,  0, -1)
                         
    return enemytargetmap

def marklaser_helper(mymap,enemytargetmap,weaponrange,position,wayx,wayy):
    checkpos = [0,0]
    xmax = len(mymap)
    ymax = len(mymap[0])
                     
    for i in range(1, weaponrange+1):
        #position in array check
        checkpos[0] = position[0]+(i*wayx)
        checkpos[1] = position[1]+(i*wayy)
        if 0 <= checkpos[0] and checkpos[0] < xmax and 0 <= checkpos[1] and checkpos[1] < ymax:
            #print("checkpos = %s" % checkpos)
            #print("checkpos = %s" % mymap[checkpos[0]][checkpos[1]])
            
            if mymap[checkpos[0]][checkpos[1]]=='O':
                #print("break rock")
                break
            elif moveablepos(mymap[checkpos[0]][checkpos[1]]):
                enemytargetmap[checkpos[0]][checkpos[1]] = -1 * i
                #print("checkpos ok = %s" % checkpos)

    return enemytargetmap
        
    


def got_gamestart(turn, map_obj, player_list):
    print("got gamestart");
    mymap = get_mapstate(map_obj)
    j = map_obj["j-length"]
    k = map_obj["k-length"]
    #are the spawn point connected? if not dont use droids
    first_spawn = False
    for x in range(0, j):
        for y in range(0, k):
            if mymap[x][y]=='S':
                if not first_spawn:
                    mypos = [x,y]
                    first_spawn = True
                else:
                    target = [x,y]

    mymap[mypos[0]][mypos[1]] = 'G'
    mymap[target[0]][target[1]] = 'G'
    dummy = find_next_tilde_to_target_pos(mymap, mypos,target)
    mymap[mypos[0]][mypos[1]] = 'S'
    mymap[target[0]][target[1]] = 'S'
 

    if mypos == dummy:
        transmitter.send_loadout("mortar", "laser")
        print("pos1 = %s" % mypos);
        print("pos2 = %s" % target);
    else:
                    
        
        e = 0
        r = 0
        c = 0
        for x in range(0, j):
            for y in range(0, k):
                if mymap[x][y] == 'E':
                        e = e + 1
                elif mymap[x][y] == 'R':
                        r = r + 1
                elif mymap[x][y] == 'C':
                        c = c + 1
#                print("'%s':" % mymap[x][y])
#            print("")
#2do implement mortar if mortar can be upgraded 1 lvl more then droid!!!!
        if e > 2*c:
            transmitter.send_loadout("mortar", "laser")
        else:
            transmitter.send_loadout("droid", "laser")
    global resource_map
    resource_map = get_mapstate(map_obj)
    for x in range(0, j):
        for y in range(0, k):
            if mymap[x][y] == 'E' or mymap[x][y] == 'R' or mymap[x][y] == 'C':
                resource_map[x][y] = 2
            else:
                resource_map[x][y] = 0

                
def got_action(action_type, who, rest_data):
    print("got action!")
    print("rest_data = %s" % rest_data);
    if action_type == "move":
        global enemy_pos
        direction = rest_data["direction"]
        if direction == "down":
            enemy_pos = [enemy_pos[0]+1,enemy_pos[1]+1]
        elif direction == "left-down":
            enemy_pos = [enemy_pos[0]+1,enemy_pos[1]]
        elif direction == "left-up":
            enemy_pos = [enemy_pos[0],enemy_pos[1]-1]
        elif direction == "up":
            enemy_pos = [enemy_pos[0]-1,enemy_pos[1]-1]
        elif direction == "right-up":
            enemy_pos = [enemy_pos[0]-1,enemy_pos[1]]
        elif direction == "right-down":
            enemy_pos = [enemy_pos[0],enemy_pos[1]+1]       
    elif action_type == "mine" and who != ai_name:
        global resource_map
        resource_map[enemy_pos[0]][enemy_pos[1]] = int(resource_map[enemy_pos[0]][enemy_pos[1]]) - 1
        print("minecount: '%s'" % resource_map[enemy_pos[0]][enemy_pos[1]])
        
        #debug_printmap(resource_map)


def got_endturn():
    print("got endturn!")
    
def get_mapstate(map):
    print("get mapstate %s" % map);
    jmax = map["j-length"]
    kmax = map["k-length"]
    print("j = %s" % jmax);
    print("k = %s" % kmax);
    #mymap[jmax][kmax]
    mymap = map["data"]
    print("mymap = %s" % mymap);
    return mymap

def create_Actionmap(mymap):
    #print("create actionmap");
    #print("mymap[0] = %s" % len(mymap[0]));
    #print("mymap = %s" % len(mymap));
    xmax = len(mymap)
    ymax = len(mymap[0])
    actionmap=deepcopy(mymap)
    for x in range(0, xmax):
        for y in range(0, ymax):
            actionmap[x][y]=999
    return actionmap
                            
def find_next_tilde_to_target_pos(mymap, mypos,target):
    print("find next tilde to target position");
    myactionmap = create_Actionmap(mymap)
    myactionmap[mypos[0]][mypos[1]]=0
 
    xmax = len(mymap[0])
    ymax = len(mymap)

    found = False
    action_count = 0
    result = mypos

    print("mypos: '%s'" % mypos)
    print("target: '%s'" % target)
    
    while(not found):
        didsomething = False
        for x in range(0, xmax):
            for y in range(0, ymax):
                if myactionmap[x][y] == action_count:
                    #if moveablepos(mymap[x][y]):
                        if x > 0 and y > 0:
                            myactionmap[x-1][y-1] = set_actioncount(myactionmap[x][y], myactionmap[x-1][y-1], mymap[x-1][y-1])
                            didsomething = True
                        if x > 0:
                            myactionmap[x-1][y] = set_actioncount(myactionmap[x][y], myactionmap[x-1][y], mymap[x-1][y])
                            didsomething = True
                        if y < ymax-1:
                            myactionmap[x][y+1] = set_actioncount(myactionmap[x][y], myactionmap[x][y+1], mymap[x][y+1])
                            didsomething = True
                        if x < xmax-1 and y < ymax-1:
                            myactionmap[x+1][y+1] = set_actioncount(myactionmap[x][y], myactionmap[x+1][y+1], mymap[x+1][y+1])
                            didsomething = True
                        if x < xmax-1:
                            myactionmap[x+1][y] = set_actioncount(myactionmap[x][y], myactionmap[x+1][y], mymap[x+1][y])
                            didsomething = True
                        if y > 0:
                            myactionmap[x][y-1] = set_actioncount(myactionmap[x][y], myactionmap[x][y-1], mymap[x][y-1]) 
                            didsomething = True                       
                        if mymap[x][y] == 'V' or mymap[x][y] == 'S' or mymap[x][y] == 'O':
                            print("action equal but not a vaild position!!!!\n");                            
                        if x == target[0] and y == target [1]:
                            found = True
                #print("'%s':" % mymap[x][y])
        if didsomething:
            action_count=action_count+1
        else:
            break;

    if found:    
        #retour wegfindung
        action_count = myactionmap[target[0]][target[1]]
        print("target: '%s'" % target)
       
        x=target[0]
        y=target[1]
        while(action_count>0):
            found = False
            
            result = [x,y]
            #print("result: '%s'" % result)
            if x > 0 and y > 0 and not found:
                if myactionmap[x-1][y-1] < action_count:
                    x=x-1
                    y=y-1
                    direction = "down"
                    found = True
            if x > 0 and not found:
                if myactionmap[x-1][y] < action_count:
                    x=x-1
                    direction = "left-down"
                    found = True
            if y < ymax-1 and not found:
                if myactionmap[x][y+1] < action_count:
                    y=y+1
                    direction = "left-up"
                    found = True
            if x < xmax-1 and y < ymax-1 and not found:
                if myactionmap[x+1][y+1] < action_count:
                    x=x+1
                    y=y+1
                    direction = "up"
                    found = True
            if x < xmax-1 and not found:
                if myactionmap[x+1][y] < action_count:
                    x=x+1
                    direction = "right-up"
                    found = True
            if y > 0 and not found:
                if myactionmap[x][y-1] < action_count:
                    y=y-1
                    direction = "right-down"
                    found = True
            action_count = action_count - 1
            
    return result

def count_enemyplayers(player_list,mymap):
    enemy_player = 0
    for player in player_list:
        player_pos = string_to_position(player_list[0]["position"])
        if player["name"] != ai_name and (player["health"] > 0 and mymap[player_pos[0]][player_pos[1]] != 'S'):
            enemy_player = enemy_player+1
    return enemy_player
                                            #this will also be used in case of enemy in range!!!!!
def move_to(mymap, mypos,target,player_list, turn):
    xmax = len(mymap[0])
    ymax = len(mymap)
    
    print("move to")
    direction = "none"
    target=find_next_tilde_to_target_pos(mymap, mypos,target)
    print("target: '%s'" % target)
#    if turn == 3:
#        if check_if_in_enemy_range(mymap,target,player_list)>0:
#            target=get_tiled_away_from_enemy(mymap,mypos,player_list)

    
    print("target: '%s'" % target)

    if target[0] > mypos[0] and target[1] > mypos[1]:
        direction = "down"
    if target[0] > mypos[0] and target[1] == mypos[1]:
        direction = "left-down"
    if target[0] == mypos[0] and target[1] < mypos[1]:
        direction = "left-up"
    if target[0] < mypos[0] and target[1] < mypos[1]:
        direction = "up"
    if target[0] < mypos[0] and target[1] == mypos[1]:
        direction = "right-up"
    if target[0] == mypos[0] and target[1] > mypos[1]:
        direction = "right-down"
    print("direction: '%s'" % direction)

    print("mypos: '%s'" % mymap[mypos[0]][mypos[1]])

    #2do check this elsewhere
    if direction == "none":
        if mymap[mypos[0]][mypos[1]]=='S':
            x=mypos[0]
            y=mypos[1]
            if x > 0 and y > 0:
                if moveablepos_forme(mymap,[mypos[0]-1,mypos[1]-1],player_list):
                   direction = "up"
                   mypos[0]=mypos[0]-1
                   mypos[1]=mypos[1]-1
            if x > 0 and direction == "none":
                if moveablepos_forme(mymap,[mypos[0]-1,mypos[1]],player_list):
                    direction = "right-up"
                    mypos[0]=mypos[0]-1
                    mypos[1]=mypos[1]
            if y < ymax-1 and direction == "none":
                if moveablepos_forme(mymap,[mypos[0],mypos[1]+1],player_list):
                    direction = "right-down"
                    mypos[0]=mypos[0]
                    mypos[1]=mypos[1]+1
            if x < xmax-1 and y < ymax-1 and direction == "none":
                if moveablepos_forme(mymap,[mypos[0]+1,mypos[1]+1],player_list):
                    direction = "down"
                    mypos[0]=mypos[0]+1
                    mypos[1]=mypos[1]+1
            if x < xmax-1 and direction == "none":
                if moveablepos_forme(mymap,[mypos[0]+1,mypos[1]],player_list):
                    direction = "left-down"
                    mypos[0]=mypos[0]+1
                    mypos[1]=mypos[1]
            if y > 0 and direction == "none":
                if moveablepos_forme(mymap,[mypos[0],mypos[1]-1],player_list):
                    direction = "left-up"
                    mypos[0]=mypos[0]
                    mypos[1]=mypos[1]-1
 
            if direction != "none":
                transmitter.send_move(direction)
                result = mypos
                print("mypos: '%s'" % mymap[mypos[0]][mypos[1]])

        else:
            print("mypos: '%s'" % mymap[mypos[0]][mypos[1]])
            print("can not find way! nothing to do?")
            if turn==1:
                transmitter.attack_laser("down")                

        result = mypos
        print("direction: '%s'" % direction)
        
    else:
        #print("action_map: '%s'" % myactionmap)
        #print("target action count: '%s'" % myactionmap[target[0]][target[1]])   
        print("moving %s-wards." % direction)   #2do hier ist er mal abgepatzt, weil minen deaktiviert war
        transmitter.send_move(direction)
        result = target


    return result

def get_resources(mymap,mymap_res,player):
    print("get nearestresource");
    #debug_printmap(mymap)
    #debug_printmap(mymap_res)
    xmax = len(mymap)
    ymax = len(mymap[0])
    found = False
    for x in range(0, xmax):
        for y in range(0, ymax):
            if resource_map[x][y]>0:
                if (mymap[x][y] == 'E' and resource_needed(player,mymap[x][y])):
                    mymap_res[x][y] = -10
                elif (mymap[x][y] == 'R'and resource_needed(player,mymap[x][y])):
                    mymap_res[x][y] = -20
                elif (mymap[x][y] == 'C'and resource_needed(player,mymap[x][y])):
                    mymap_res[x][y] = -10
                    
    return mymap_res


def set_actioncount(source, target, target_info):
    #print("set actioncout");
    #print("source '%s':" % source)
    #print("target '%s':" % target)
    #print("target_info '%s':" % target_info)
    result = target
    if target_info == 'E' or target_info == 'R' or target_info == 'C' or target_info == 'G':
        if target > source+1:
            result=source+1
    return result


def set_actioncount_laser(source, target, target_info):
    #print("set actioncout");
    #print("source '%s':" % source)
    #print("target '%s':" % target)
    #print("target_info '%s':" % target_info)
    result = target
    if target_info == 'E' or target_info == 'R' or target_info == 'C' or target_info == 'G' or target_info == 'V':
        if target > source+1:
            result=source+1
    return result

def set_actioncount_mortar(source, target, target_info):
    #print("set actioncout");
    #print("source '%s':" % source)
    #print("target '%s':" % target)
    #print("target_info '%s':" % target_info)
    result = target
    if target > source+1:
        result=source+1
    return result

def debug_printmap(mymap):
    lines = len(mymap)
    print("=============================================")
    for i in range(0, lines):
        print("map: '%s'" % mymap[i])
        donohing=1
    print("=============================================")
    
    
receiver = skyport.SkyportReceiver()
transmitter = skyport.SkyportTransmitter(send_line)

receiver.handler_handshake_successful = got_handshake
receiver.handler_error = got_error
receiver.handler_gamestate = got_gamestate
receiver.handler_gamestart = got_gamestart
receiver.handler_action = got_action
receiver.handler_endturn = got_endturn

transmitter.send_handshake(ai_name)

while True:
    line = read_packet()
    if line != None:
        print("got line: '%s'" % line)
        receiver.parse_line(line)

