#!/usr/bin/env python2
import sys
import random
import socket
import math
from socket import timeout
import json
sys.path.append("../api/python/")
import skyport

def enum(**enums):
    return type('Enum', (), enums)

Directions = enum(UP = "up", DOWN = "down", LEFTDOWN = "left-down", LEFTUP = "left-up", RIGHTDOWN = "right-down", RIGHTUP = "right-up")

# An AI-player-class
# TODO: Maybe som inheritance from Tile here?
class AiOpponent:
    def __init__(self, name):
        self.name = name
        self.j = -1
        self.k = -1

    def manhattan_distance_to(self):
        return calculate_manhattan_distance_to(self.j, self.k)

    def get_name(self):
        return self.name

    def set_j(self, j):
        self.j = j

    def set_k(self, k):
        self.k = k

    def get_coordinate(self):
        return [self.j, self.k]

    def set_coordinate(self, coordinate):
        self.j = coordinate[0]
        self.k = coordinate[1]

# A tile-class
class Tile:
    def __init__(self, j, k, tiletype):
        self.j = j
        self.k = k
        self.tiletype = tiletype

    def manhattan_distance_to(self):
        return calculate_manhattan_distance_to(self.j, self.k)

    def get_tiletype(self):
        return self.tiletype

    def get_coordinate(self):
        return [self.j, self.k]

assert(len(sys.argv) == 2)

# We open the socket manually
sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect(('127.0.0.1', 54321))

inputbuf = "" # All received data goes in here
weapons_chosen = [] # remember the weapons we chose in the loadout
players = []
my_position = []
my_resources = []
tiles = []
closest_opponent = None

def read_packet(): # this AI takes a single-thread blocking-I/O approach
    global inputbuf
    try:
        ret = sock.recv(1)
        inputbuf += ret
        if not ret:
            print("Disconnected!")
            sys.exit(1)
    except socket.timeout as e:
        print("timeout!")
        return None
    except socket.error as e:
        print("error: %s" % e)
        sys.exit(1)
    try:
        characters_to_read = inputbuf.index("\n")
        line = inputbuf[0:characters_to_read] # removing the newline
        inputbuf = inputbuf[characters_to_read+1:len(inputbuf)]
        return line
    except ValueError as f:
        return None

def do_move(direction):
    print("moving %s-wards." % direction)
    transmitter.send_move(direction)

def shoot_mortar_in_random_direction():
    # Randomly performs invalid shots.
    # [-4, 4] x [-4, 4]
    j = random.randrange(-4, 5)
    k = random.randrange(-4, 5)
    if j == 0 and k == 0:
        j = 2 # don't hit ourselves -- we don't care about bias.
        k = 2
    transmitter.attack_mortar(j, k) # coordinates relative to us

def upgrade_random_weapon():
    #transmitter.upgrade("laser")
    transmitter.upgrade(random.choice(weapons_chosen))

def shoot_laser_in_random_direction():
    # requires you to select the laser as weapon, obviously
    direction = random.choice(["up", "down", "left-down", "left-up", "right-down", "right-up"])
    print("shooting %s-wards." % direction)
    transmitter.attack_laser(direction)

def shoot_droid_in_random_directions():
    directions = []
    for x in range(0, 8):
        directions.append(random.choice(["up", "down", "left-down", "left-up", "right-down", "right-up"]))
    print("shooting droid in sequence %r" % directions)
    transmitter.attack_droid(directions)

def send_line(line): # sends a line to the socket
    print("sending: '%s'" % line)
    if sock.sendall(line + "\n") != None:
        print("Error sending data!")

def got_handshake():
    print("got handshake!")

def got_error(errmsg):
    print("Error: '%s'" % errmsg)

def got_gamestate(turn, map_obj, player_list):
    if player_list[0]["name"] == sys.argv[1]: # its our turn
        print "\n--------- MY TURN ------------"
        # Refresh map to see if any resources have been mined off
        refresh_resources(map_obj)

        # Declare globals
        global my_position
        global closest_opponent
        global my_resources

        # Get the current player positions
        for player in player_list:
            if player["name"] != sys.argv[1]:
                for p in players:
                    if player["name"] == p.name:
                        p.set_coordinate([int(x.strip()) for x in player["position"].split(',')])
                        print "Updated coordinates for player %s to %i, %i" % (player["name"], p.get_coordinate()[0], p.get_coordinate()[1])
            else:
                my_position = [int(x.strip()) for x in player["position"].split(',')]
                print "My position: %s, %s" % (my_position[0], my_position[1])

        # Closest opponent?
        for player in players:
            new_distance = player.manhattan_distance_to()
            if closest_opponent is not None:
                if new_distance < closest_opponent.manhattan_distance_to():
                    closest_opponent = player
                    print "We have a closer one! Name: %s Distance: %i" % (player.get_name(), player.manhattan_distance_to())
            else:
                closest_opponent = player
        print " ===== Closest opponent ===== %s, distance: %i" % (closest_opponent.get_name(), closest_opponent.manhattan_distance_to())

        # TODO: Can they shoot me? Remember three step buffer on this

        # TODO: Can I shoot them?
        #range_of_weapons = get_current_range_of_weapons()

        # Closest resource that I need for upgrades? With directions
        closest_resource_tiles = calculate_closest_resource_tile(my_resources)
        closest_resource_tile = closest_resource_tiles[0]
        second_closest_resource_tile = closest_resource_tiles[1]
        print "Closest resource tile::: %s %s Distance: %i" % (closest_resource_tile.get_coordinate(), closest_resource_tile.get_tiletype(), closest_resource_tile.manhattan_distance_to())

        direction = get_direction(my_position, closest_resource_tile.get_coordinate())
        direction_second = get_direction(closest_resource_tile.get_coordinate(), second_closest_resource_tile.get_coordinate())

        # TODO: Add void and rock checks

        # TODO: 3 actions
        # Mine, if possible, else move towards/from resource/opponent
        # For now, we will mine and run for it
        if closest_resource_tile.manhattan_distance_to() == 0:
            transmitter.mine()
            do_move(direction_second)
        else:
            do_move(direction)

        print "--------- END MY TURN ------------\n"
        #do_random_move() # never do random move
        #do_random_move() # NEVER
        #transmitter.mine()
        # random.choice([transmitter.mine, shoot_mortar_in_random_direction,
        #                shoot_laser_in_random_direction, shoot_droid_in_random_directions,
        #                transmitter.mine, upgrade_random_weapon])()

def get_direction(from_coordinate, to_coordinate):
    # TODO: The direction checking could probably be improved
    # TODO: Check for voids
    j0 = from_coordinate[0]
    k0 = from_coordinate[1]

    j = to_coordinate[0]
    k = to_coordinate[1]
    direction = ""
    if (j > j0) & (k < k0):
        direction = random.choice([Directions.LEFTUP, Directions.LEFTDOWN])
    elif (j > j0) & (k == k0):
        direction = Directions.LEFTDOWN
    elif (j > j0) & (k > k0):
        direction = Directions.DOWN
    elif (j == j0) & (k == k0):
        # Stand still
        direction = ""
    elif (j == j0) & (k > k0):
        direction = Directions.RIGHTDOWN
    elif (j == j0) & (k < k0):
        direction = Directions.LEFTUP
    elif (j < j0) & (k == k0):
        direction = Directions.RIGHTUP
    elif (j < j0) & (k < k0):
        direction = Directions.UP
    elif (j < j0) & (k > k0):
        direction = random.choice([Directions.RIGHTUP, Directions.RIGHTDOWN])

    return direction

def calculate_manhattan_distance_to(j, k):
    k0 = my_position[1]
    j0 = my_position[0]

    dx = k-k0
    dy = j-j0

    distance = (abs(dx)+abs(dy)+abs(dx-dy))/2
    return distance

def calculate_closest_resource_tile(resources):
    global tiles
    interesting_tiles = []
    for outer in tiles:
        for tile in outer:
            if tile.get_tiletype() == resources[0] or tile.get_tiletype() == resources[1]:
                interesting_tiles.append(tile)

    min_distance = 9999
    closest_resource_tile = None
    second_closest_resource_tile  = None
    for tile in interesting_tiles:
        if tile.manhattan_distance_to() <= min_distance:
            if closest_resource_tile is None:
                closest_resource_tile = tile
                print "Closest first time %s" % closest_resource_tile.get_coordinate()
            else:
                second_closest_resource_tile = closest_resource_tile
                closest_resource_tile = tile
                print "Second closest: %s Closest: %s" % (second_closest_resource_tile.get_coordinate(), closest_resource_tile.get_coordinate())
            min_distance = tile.manhattan_distance_to()

    return [closest_resource_tile, second_closest_resource_tile]

def refresh_resources(map_obj):
    # Initalize tile-list
    global tiles
    tiles = []
    # TODO: In stead of running this every time a tile changes because of mining, we can
    # update the single tile.
    # TODO: Choose weapons based on resources, voids and rocks.
    # TODO: Scan the map to see what's there.
    E = 0 # Explosium
    C = 0 # Scrap
    R = 0 # Rubidium

    j = 0
    k = 0
    for key, value in map_obj.items():
        print "\n"
        if key == "data":
            for row in value:
                tiles.append([])
                for tiletype in row:
                    if tiletype == 'E':
                        E += 1
                    elif tiletype == 'R':
                        R += 1
                    elif tiletype == 'C':
                        C += 1
                    print j, k
                    tiles[j].append(Tile(j, k, tiletype))
                    k += 1
                j += 1
                k = 0
                print "\n"
        print "\n"
    return [E,C,R]

def got_gamestart(turn, map_obj, player_list):
    # Set up player list
    for player in player_list:
        # TODO: Add the weapons, to do other stuff if in range of his weapons
        if player["name"] != sys.argv[1]:
            players.append(AiOpponent(player["name"]))

    resources = refresh_resources(map_obj)
    select_weapons(resources)

def select_weapons(resources):
    global my_resources
    weapons = ["mortar", "droid", "laser"]
    for res in resources:
        print res
    if resources[0] >= resources[1]:
        primary_weapon = weapons[0]
        my_resources.append('E')
        if resources[1] > resources[2]:
            secondary_weapon = weapons[1]
            my_resources.append('C')
        else:
            secondary_weapon = weapons[2]
            my_resources.append('R')
    else:
        primary_weapon = weapons[1]
        my_resources.append('C')
        if resources[0] > resources[2]:
            secondary_weapon = weapons[0]
            my_resources.append('E')
        else:
            secondary_weapon = weapons[2]
            my_resources.append('R')

    global weapons_chosen
    weapons_chosen = [primary_weapon, secondary_weapon]

    print("chose loadout: %s and %s" % (primary_weapon, secondary_weapon))
    transmitter.send_loadout(primary_weapon, secondary_weapon)

def got_action(action_type, who, rest_data):
    print("got action!")

def got_endturn():
    print("\ngot endturn!")


receiver = skyport.SkyportReceiver()
transmitter = skyport.SkyportTransmitter(send_line)
# the SkyportTransmitter doesn't do networking on its own
# so you have to provide it with a send_line function that
# it can use to send data to the socket


# Register functions as callback, so that
# SkyportReceiver can call them when something happens
receiver.handler_handshake_successful = got_handshake
receiver.handler_error = got_error
receiver.handler_gamestate = got_gamestate
receiver.handler_gamestart = got_gamestart
receiver.handler_action = got_action
receiver.handler_endturn = got_endturn

# send the initial handshake
transmitter.send_handshake(sys.argv[1])

while True:
    line = read_packet() # try to read a line from the socket
    if line != None:
        #print("got line: '%r'" % line)
        receiver.parse_line(line) # hand the line to SkyportReceiver to process