package skyport.json;

import java.io.Serializable;

import skyport.Coordinate;

import com.fasterxml.jackson.annotation.JsonProperty;

public class PlayerBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private String name;
	private WeaponBean primaryWeapon;
	private WeaponBean secondaryWeapon;
	private int health;
	private int score;
	private Coordinate position;

	public PlayerBean() {
		name = null;
		primaryWeapon = null;
		secondaryWeapon = null;
		health = 0;
		score = 0;
		position = null;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@JsonProperty("primary-weapon")
	public WeaponBean getPrimaryWeapon() {
		return primaryWeapon;
	}

	@JsonProperty("primary-weapon")
	public void setPrimaryWeapon(final WeaponBean primaryWeapon) {
		this.primaryWeapon = primaryWeapon;
	}

	@JsonProperty("secondary-weapon")
	public WeaponBean getSecondaryWeapon() {
		return secondaryWeapon;
	}

	@JsonProperty("secondary-weapon")
	public void setSecondaryWeapon(final WeaponBean secondaryWeapon) {
		this.secondaryWeapon = secondaryWeapon;
	}

	public int getHealth() {
		return health;
	}

	public void setHealth(int health) {
		this.health = health;
	}

	public int getScore() {
		return score;
	}

	public void setScore(int score) {
		this.score = score;
	}

	public Coordinate getPosition() {
		return position;
	}

	public void setPosition(final String string) {
		position = new Coordinate(string);
	}

	@Override
	public String toString() {
		return "PlayerBean [name=" + name + ", primaryWeapon=" + primaryWeapon
				+ ", secondaryWeapon=" + secondaryWeapon + ", health=" + health
				+ ", score=" + score + ", position=" + position + "]";
	}
}
