package skyport.json;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MapBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private int jlength;
	private int klength;
	private char[][] data;

	public MapBean() {
		jlength = 0;
		klength = 0;
		data = null;
	}

	@JsonCreator
	public MapBean(@JsonProperty("j-length") int jlength,
			@JsonProperty("k-length") int klength,
			@JsonProperty("data") char[][] data) {

		this.jlength = jlength;
		this.klength = klength;
		this.data = data;
	}

	@JsonProperty("j-length")
	public int getJlength() {
		return jlength;
	}

	@JsonProperty("j-length")
	public void setJlength(int jlength) {
		this.jlength = jlength;
	}

	@JsonProperty("k-length")
	public int getKlength() {
		return klength;
	}

	@JsonProperty("k-length")
	public void setKlength(int klength) {
		this.klength = klength;
	}

	public char[][] getData() {
		return data;
	}

	public void setData(char[][] data) {
		this.data = data;
	}
}
