package skyport.algorithms.astar;

import java.util.ArrayList;
import java.util.List;

import skyport.Coordinate;
import skyport.Tilemap;
import skyport.enums.Direction;

public class Nodemap {

	private Node[][] nodes;

	public Nodemap(final Tilemap map) {
		nodes = new Node[map.getJLength()][map.getKLength()];

		for (int i = 0; i < nodes.length; ++i) {
			for (int j = 0; j < nodes[i].length; ++j) {
				nodes[i][j] = new Node(i, j);
			}
		}

		for (int i = 0; i < nodes.length; ++i) {
			for (int j = 0; j < nodes[i].length; ++j) {
				nodes[i][j]
						.setNeighbors(getNeighbors(map, new Coordinate(i, j)));
			}
		}
	}

	public List<Node> getRoute(final Coordinate from, final Coordinate to) {
		List<Node> nodes = AStar.findRoute(getNode(from), getNode(to));
		reset();

		return nodes;
	}

	private Node getNode(final Coordinate coordinate) {
		return nodes[coordinate.getX()][coordinate.getY()];
	}

	private void reset() {
		for (int i = 0; i < nodes.length; ++i) {
			for (int j = 0; j < nodes[i].length; ++j) {
				nodes[i][j].setCameFrom(null);
			}
		}
	}

	private List<Node> getNeighbors(final Tilemap map,
			final Coordinate coordinate) {
		List<Node> neighbors = new ArrayList<Node>();

		for (Direction dir : Direction.values()) {
			Coordinate newCoord = coordinate.getCoordinateInDirection(dir);

			if (map.legalCoordinate(newCoord)
					&& map.getTileAt(newCoord).isTraversable()) {

				neighbors.add(nodes[newCoord.getX()][newCoord.getY()]);
			}
		}

		return neighbors;
	}
}
