package skyport.algorithms.astar;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class AStar {

	private static final int COST = 1;

	private static int estimateDistance(Node node1, Node node2) {
		return Math.abs(node1.getX() - node2.getX())
				+ Math.abs(node1.getY() - node2.getY());
	}

	static LinkedList<Node> findRoute(Node start, Node goal) {
		boolean foundAPath = false;
		
		// The set of nodes already evaluated.
		Set<Node> closedSet = new HashSet<Node>();

		// The set of tentative nodes to be evaluated, initially containing the
		// start node
		Set<Node> openSet = new HashSet<Node>();
		openSet.add(start);

		// Cost from start along best known path.
		start.setG(0);

		// Estimated total cost from start to goal through y.
		start.setF(estimateDistance(start, goal));

		while (!openSet.isEmpty() && !foundAPath) {
			Node current = null;

			// Find the node in openset having the lowest f_score[] value
			for (Node node : openSet) {
				if (current == null || node.getF() < current.getF()) {
					current = node;
				}
			}

			foundAPath = current == goal;

			if (!foundAPath) {
				openSet.remove(current);
				closedSet.add(current);

				for (Node neighbor : current.getNeighbors()) {
					boolean isInOpenSet = openSet.contains(neighbor);
					int tentativeG = current.getG() + COST;

					if (!(isInOpenSet || closedSet.contains(neighbor))
							|| tentativeG < neighbor.getG()) {
						
						neighbor.setCameFrom(current);
						neighbor.setG(tentativeG);
						neighbor.setF(neighbor.getG()
								+ estimateDistance(neighbor, goal));

						if (!isInOpenSet) {
							openSet.add(neighbor);
						}
					}
				}
			}
		}

		if (foundAPath) {
			LinkedList<Node> nodes = new LinkedList<Node>();
			Node current = goal;

			while (current.getCameFrom() != null) {
				nodes.addFirst(current);
				current = current.getCameFrom();
			}

			return nodes;
		} else {
			return null;
		}
	}
}
