package skyport;

import java.util.HashMap;
import java.util.Map;

import skyport.constants.GameConstants;
import skyport.enums.Tile;
import skyport.enums.WeaponType;
import skyport.json.WeaponBean;

public class PlayerResources {

	private Map<Tile, Integer> resourceCount;

	public PlayerResources() {
		resourceCount = new HashMap<Tile, Integer>();

		for (Tile tile : Tile.values()) {
			if (tile.isMineable()) {
				resourceCount.put(tile, 0);
			}
		}
	}

	public int getResourceCount(Tile tile) {
		if (tile.isMineable()) {
			return resourceCount.get(tile);
		} else {
			return 0;
		}
	}

	public void incrementResourceCount(Tile tile) {
		if (tile.isMineable()) {
			Integer count = resourceCount.get(tile);
			++count;
			resourceCount.put(tile, count);
		}
	}

	public boolean upgradeWeaponIfPossible(final WeaponBean weapon) {
		WeaponType type = weapon.getType();
		int level = weapon.getLevel();

		if (level < GameConstants.MIN_WEAPON_LEVEL
				|| level >= GameConstants.MAX_WEAPON_LEVEL) {
			return false;
		}

		int resourceNeed = GameConstants.RESOURCES_TO_UPGRADE[level - 1];
		Tile resource = WeaponResource.getInstance().getResource(type);
		Integer count = resourceCount.get(resource);

		if (count >= resourceNeed) {
			count -= resourceNeed;
			resourceCount.put(resource, count);
			return true;
		} else {
			return false;
		}
	}

	public void upgradeWeapon(final WeaponBean weapon) {
		WeaponType type = weapon.getType();
		int level = weapon.getLevel();

		if (level < GameConstants.MIN_WEAPON_LEVEL
				|| level >= GameConstants.MAX_WEAPON_LEVEL) {
			return;
		}

		int resourceNeed = GameConstants.RESOURCES_TO_UPGRADE[level - 1];
		Tile resource = WeaponResource.getInstance().getResource(type);
		Integer count = resourceCount.get(resource);

		count -= resourceNeed;
		resourceCount.put(resource, count);
	}
}
