/*
 * Decompiled with CFR 0.152.
 */
package skyport.algorithms.astar;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import skyport.Coordinate;
import skyport.Tilemap;
import skyport.algorithms.astar.AStar;
import skyport.algorithms.astar.Node;
import skyport.enums.Direction;

public class Nodemap {
    private Node[][] nodes;

    public Nodemap(Tilemap map) {
        int j;
        this.nodes = new Node[map.getJLength()][map.getKLength()];
        int i = 0;
        while (i < this.nodes.length) {
            j = 0;
            while (j < this.nodes[i].length) {
                this.nodes[i][j] = new Node(i, j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nodes.length) {
            j = 0;
            while (j < this.nodes[i].length) {
                this.nodes[i][j].setNeighbors(this.getNeighbors(map, new Coordinate(i, j)));
                ++j;
            }
            ++i;
        }
    }

    public List<Node> getRoute(Coordinate from, Coordinate to) {
        LinkedList<Node> nodes = AStar.findRoute(this.getNode(from), this.getNode(to));
        this.reset();
        return nodes;
    }

    private Node getNode(Coordinate coordinate) {
        return this.nodes[coordinate.getX()][coordinate.getY()];
    }

    private void reset() {
        int i = 0;
        while (i < this.nodes.length) {
            int j = 0;
            while (j < this.nodes[i].length) {
                this.nodes[i][j].setCameFrom(null);
                ++j;
            }
            ++i;
        }
    }

    private List<Node> getNeighbors(Tilemap map, Coordinate coordinate) {
        ArrayList<Node> neighbors = new ArrayList<Node>();
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            Coordinate newCoord = coordinate.getCoordinateInDirection(dir);
            if (map.legalCoordinate(newCoord) && map.getTileAt(newCoord).isTraversable()) {
                neighbors.add(this.nodes[newCoord.getX()][newCoord.getY()]);
            }
            ++n2;
        }
        return neighbors;
    }
}

