/*
 * Decompiled with CFR 0.152.
 */
package skyport.ais;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import skyport.Coordinate;
import skyport.SkyportException;
import skyport.ais.Ai;
import skyport.enums.Direction;
import skyport.enums.Tile;
import skyport.json.PlayerBean;

public class IdleAi
extends Ai
implements Runnable {
    private static final int NUMBER_OF_AI = 2;
    private static final String NAME = "idleAI";
    private static int index = 0;

    public IdleAi() {
        super(IdleAi.getAiName());
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException | SkyportException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    protected void processTurn() throws JsonProcessingException {
        PlayerBean currentPlayer = this.game.getCurrentPlayer();
        if (this.aiName.equals(currentPlayer.getName())) {
            Direction dir;
            Coordinate pos = currentPlayer.getPosition();
            Tile tile = this.game.getTilemap().getTileAt(pos);
            if (tile != null && tile == Tile.SPAWN && (dir = this.getSafeDirectionFrom(pos)) != null) {
                this.client.send(this.message.move(dir));
            }
        }
    }

    private static synchronized String getAiName() {
        String ainame = NAME + index;
        ++index;
        return ainame;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 2) {
            new Thread(new IdleAi()).start();
            ++i;
        }
    }
}

