/*
 * Decompiled with CFR 0.152.
 */
package skyport;

import org.junit.Assert;
import org.junit.Test;
import skyport.Coordinate;
import skyport.enums.Direction;

public class CoordinateTest {
    @Test
    public void getCoordinateInDirectionDirectionInt() {
        Coordinate coord = new Coordinate(5, 5);
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            Coordinate newCoord = new Coordinate(coord);
            newCoord.changeToCoordinateInDirection(dir);
            newCoord.changeToCoordinateInDirection(dir);
            newCoord.changeToCoordinateInDirection(dir);
            Assert.assertEquals(newCoord, coord.getCoordinateInDirection(dir, 3));
            ++n2;
        }
    }

    @Test
    public void getDirectionTowards() {
        Coordinate coord = new Coordinate(5, 5);
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            Coordinate newCoord = new Coordinate(coord);
            newCoord.changeToCoordinateInDirection(dir);
            newCoord.changeToCoordinateInDirection(dir);
            newCoord.changeToCoordinateInDirection(dir);
            Assert.assertEquals((Object)dir, (Object)coord.getDirectionTowards(newCoord));
            ++n2;
        }
    }

    @Test
    public void getDirectionTowards2() {
        Coordinate coord = new Coordinate(5, 5);
        Coordinate otherCoord = new Coordinate(6, 4);
        Assert.assertNull((Object)coord.getDirectionTowards(otherCoord));
    }

    @Test
    public void hasDirectRangeTo() {
        Coordinate coord = new Coordinate(5, 5);
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            Coordinate newCoord = new Coordinate(coord);
            newCoord.changeToCoordinateInDirection(dir);
            newCoord.changeToCoordinateInDirection(dir);
            newCoord.changeToCoordinateInDirection(dir);
            Assert.assertTrue(coord.hasDirectRangeTo(newCoord, 5));
            ++n2;
        }
    }

    @Test
    public void hasRangeTo() {
        Coordinate[] targets;
        int x = 8;
        int y = 12;
        int r = 3;
        Coordinate pos = new Coordinate(x, y);
        Coordinate[] coordinateArray = targets = new Coordinate[]{new Coordinate(x + r, y + r), new Coordinate(x, y + r), new Coordinate(x + r, y), new Coordinate(x, y - r), new Coordinate(x - r, y), new Coordinate(x - r, y - r), new Coordinate(x - r, y - r + 1), new Coordinate(x - r, y - r + 2), new Coordinate(x - r + 1, y + r - 2), new Coordinate(x - r + 2, y + r - 1)};
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            Assert.assertTrue(pos.hasRangeTo(coord, r + 1));
            Assert.assertTrue(pos.hasRangeTo(coord, r));
            Assert.assertFalse(pos.hasRangeTo(coord, r - 1));
            ++n2;
        }
        Assert.assertFalse(pos.hasRangeTo(new Coordinate(x + r, y - r), r));
        Assert.assertFalse(pos.hasRangeTo(new Coordinate(x - r, y + r), r));
    }
}

