package aborysa.PowerShot.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;

public class Client {
	Socket ServerConnection;
	int port;
	String sAddr;
	InputStream InStream;
	OutputStream OutStream;
	
	public Client(String serverAddress, int PORT) throws UnknownHostException, IOException{
		port = PORT;
		sAddr = serverAddress;
		ConnectToServer();
	}
	
	public void ConnectToServer(){
		try {
			ServerConnection = new Socket(sAddr,port);
			System.out.println("Trying connection... WAIT");
			
			OutStream =ServerConnection.getOutputStream();
			OutStream.flush();
			InStream = ServerConnection.getInputStream();
			System.out.println("Connected to Server");
		} catch (UnknownHostException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		
	}
	public String receive(){
		String message = "";
		
			try {
				char[] mValue = Character.toChars(InStream.read());
				System.out.print(">");
				while (mValue[0] != -1){
					System.out.print(String.valueOf(mValue[0]));
					message += String.valueOf(mValue[0]);
					if (message.endsWith("\n")){
						break;
					}
					mValue = Character.toChars(InStream.read());
				}
					System.out.println("Done receiving!");
					return (String)message;
				//System.out.println(message);
			} catch (IOException e) {
				System.exit(0);
				e.printStackTrace();
			}
			
		return  message;
	}
	public void SendData(String s){
		try {
			String endMessage = "\n";
			char[] charEnd = endMessage.toCharArray();
			char[] mValue = s.toCharArray();
			System.out.print("<");
			for(int i=0;i<mValue.length;i++){
				System.out.print(mValue[i]);
				OutStream.write(mValue[i]);
			}
			for(int i=0;i<charEnd.length;i++){
				System.out.print(charEnd[i]);
				OutStream.write(charEnd[i]);
			}
			System.out.println("Done sending!");

			OutStream.flush();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
}
