/*
 * Decompiled with CFR 0.152.
 */
package aborysa.PowerShot.PathFinding;

import aborysa.PowerShot.Map.Map;
import aborysa.PowerShot.PathFinding.Node;
import java.util.ArrayList;

public class PathFinder {
    public static String[] findPath(Map map, int s_k, int s_j, int e_k, int e_j, int type, int max_steps) {
        String[] path = PathFinder.findPath(map.map, map.width, s_k, s_j, e_k, e_j, type, max_steps);
        return path;
    }

    public static String[] findPath(String[] mapData, int width, int s_k, int s_j, int e_k, int e_j, int type, int max_steps) {
        System.out.println("Start: (" + s_k + ", " + s_j + ")" + ", End: " + e_k + ", " + e_j);
        String[] path = null;
        boolean foundPath = false;
        Node parrent = new Node(null, s_k + s_j * width, 0, PathFinder.getDistance(s_k, s_j, e_k, e_j));
        int targetIndex = e_k + e_j * width;
        int parrentIndex = -1;
        ArrayList<Node> openList = new ArrayList<Node>();
        ArrayList<Node> closedList = new ArrayList<Node>();
        closedList.add(parrent);
        int sycles = 0;
        while (!foundPath) {
            if (++sycles >= max_steps) {
                foundPath = true;
                path = null;
                System.out.println("Could not find path!");
                break;
            }
            int MparrentK = parrent.index % width;
            int MparrentJ = (int)Math.floor(parrent.index / width);
            int[] at = PathFinder.getAdjacentTiles(width, mapData.length / width, MparrentK, MparrentJ);
            int i = 0;
            while (i < at.length) {
                boolean addToOpenList = true;
                boolean addToClosedList = false;
                System.out.println("Aindex: " + at[i]);
                int k = at[i] % width;
                int j = (int)Math.floor(at[i] / width);
                Node testNode = new Node(parrent, at[i], parrent.gValue + 1, PathFinder.getDistance(k, j, e_k, e_j));
                if (at[i] <= mapData.length - 1 && at[i] >= 0) {
                    if (mapData[at[i]].equals("O") || mapData[at[i]].equals("V") || mapData[at[i]].equals("S")) {
                        addToOpenList = false;
                        addToClosedList = true;
                    }
                    int l = 0;
                    while (l < closedList.size()) {
                        if (((Node)closedList.get((int)l)).index == at[i]) {
                            addToOpenList = false;
                            addToClosedList = false;
                        }
                        ++l;
                    }
                    if (!addToClosedList) {
                        l = 0;
                        while (l < openList.size()) {
                            Node tempNode = (Node)openList.get(l);
                            if (tempNode.index == at[i]) {
                                addToOpenList = false;
                                if (tempNode.gValue > testNode.gValue + 1) {
                                    tempNode.parrent = testNode;
                                    tempNode.gValue = testNode.gValue + 1;
                                }
                                break;
                            }
                            ++l;
                        }
                    } else {
                        closedList.add(testNode);
                    }
                    if (addToOpenList) {
                        openList.add(testNode);
                    }
                }
                ++i;
            }
            Node smallNode = null;
            int i2 = 0;
            while (i2 < openList.size()) {
                Node tempNode = (Node)openList.get(i2);
                if (smallNode == null || tempNode.getFvalue() < smallNode.getFvalue()) {
                    smallNode = tempNode;
                    parrentIndex = i2;
                }
                ++i2;
            }
            if (smallNode == null) continue;
            if (smallNode.hValue < 1) {
                Node[] nodes = smallNode.traceBack(targetIndex);
                int[] kV = new int[nodes.length - 1];
                int[] jV = new int[nodes.length - 1];
                int i3 = 0;
                while (i3 < kV.length) {
                    int kN = nodes[i3].index % width;
                    int jN = (int)Math.floor(nodes[i3].index / width);
                    if (nodes[i3].parrent != null) {
                        int parrentK = nodes[i3].parrent.index % width;
                        int parrentJ = (int)Math.floor(nodes[i3].parrent.index / width);
                        kV[i3] = kN - parrentK;
                        jV[i3] = jN - parrentJ;
                    }
                    ++i3;
                }
                path = PathFinder.moveSequence(kV, jV, type);
                System.out.println("Found path, steps: " + path.length);
                break;
            }
            parrent = smallNode;
            closedList.add(parrent);
            openList.remove(parrent);
        }
        return path;
    }

    public static int getDistance(int s_k, int s_j, int e_k, int e_j) {
        int dist = 0;
        int deltaK = e_k - s_k;
        int deltaJ = e_j - s_j;
        int maxJK = Math.max(Math.abs(deltaK), Math.abs(deltaJ));
        dist = deltaK > 0 && deltaJ > 0 || deltaK < 0 && deltaJ < 0 ? maxJK : Math.abs(deltaK) + Math.abs(deltaJ);
        return dist;
    }

    public static String[] moveSequence(int[] k, int[] j, int type) {
        String[] moveSequ = new String[j.length];
        int i = 0;
        while (i < j.length) {
            moveSequ[i] = k[i] == j[i] ? (k[i] < 0 ? "up" : "down") : (k[i] < 0 ? (type == 1 ? "left-up" : "leftUp") : (k[i] > 0 ? (type == 1 ? "right-down" : "rightDown") : (j[i] < 0 ? (type == 1 ? "right-up" : "rightUp") : (j[i] > 0 ? (type == 1 ? "left-down" : "leftDown") : null))));
            ++i;
        }
        return moveSequ;
    }

    public static String[] simpleMoveSequence(int s_k, int s_j, int e_k, int e_j) {
        int moveK = 0;
        int deltaK = e_k - s_k;
        int deltaJ = e_j - s_j;
        int minJK = Math.min(Math.abs(deltaK), Math.abs(deltaJ));
        String[] sequ = new String[minJK];
        if (deltaK <= 0 && deltaJ <= 0 || deltaK >= 0 && deltaJ >= 0) {
            int i;
            int moveDown = minJK;
            if (minJK == deltaK) {
                int moveJ = deltaJ - deltaK;
                i = 0;
                while (i < moveJ) {
                    if (moveJ < 0) {
                        sequ[i] = "right-up";
                    }
                    if (moveJ > 0) {
                        sequ[i] = "left-down";
                    }
                    ++i;
                }
            } else if (minJK == deltaJ) {
                moveK = deltaK - deltaJ;
                i = 0;
                while (i < moveK) {
                    if (moveK < 0) {
                        sequ[i] = "left-up";
                    }
                    if (moveK > 0) {
                        sequ[i] = "right-down";
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < moveDown) {
                if (minJK < 0) {
                    sequ[i] = "up";
                }
                if (minJK > 0) {
                    sequ[i] = "down";
                }
                ++i;
            }
        } else {
            moveK = deltaK;
            int moveJ = deltaJ;
            int i = 0;
            while (i < moveK) {
                if (moveK < 0) {
                    sequ[i] = "left-up";
                }
                if (moveK > 0) {
                    sequ[i] = "right-down";
                }
                ++i;
            }
            i = 0;
            while (i < moveJ) {
                if (moveJ < 0) {
                    sequ[i] = "right-up";
                }
                if (moveJ > 0) {
                    sequ[i] = "left-down";
                }
                ++i;
            }
        }
        return sequ;
    }

    private static int[] getAdjacentTiles(Map map, int s_k, int s_j) {
        int[] parents = PathFinder.getAdjacentTiles(map.width, map.height, s_k, s_j);
        return parents;
    }

    private static int[] getAdjacentTiles(int width, int height, int s_k, int s_j) {
        int[] parents = new int[6];
        int count = 0;
        int k = -1;
        while (k < 2) {
            int j = -1;
            while (j < 2) {
                if ((k >= 0 && j >= 0 || k <= 0 && j <= 0) && (k != 0 || j != 0)) {
                    parents[count] = s_k + k < width && (s_j + j) * width + (s_k + k) < width * height ? (s_k + k - s_k > -2 && (s_j + j) * width - s_j > -2 ? (s_j + j) * width + (s_k + k) : -1) : -1;
                    ++count;
                }
                ++j;
            }
            ++k;
        }
        return parents;
    }
}

