#include <stdlib.h>
#include <assert.h>

#include "weapon.h"
#include "map.h"
#include "main.h"
#include "player.h"

char *dir_to_string(dir_t dir)
{
    switch (dir) {
        case dir_none: return "NONE";
        case dir_up: return "up";
        case dir_down: return "down";
        case dir_right_up: return "right-up";
        case dir_right_down: return "right-down";
        case dir_left_up: return "left-up";
        case dir_left_down: return "left-down";
    }
}

dir_t coords_to_dir(int from, int to)
{
    int from_j = map_j_val(from),
        from_k = map_k_val(from),
        to_j = map_j_val(to),
        to_k = map_k_val(to);

    if (to_j > from_j) {
        if (to_k < from_k + (to_j - from_j)) {
            return dir_left_down;
        } else {
            return dir_down;
        }
    } else if (to_j == from_j) {
        if (to_k >= from_k) {
            return dir_right_down;
        } else {
            return dir_left_up;
        }
    } else {
        if (to_k > from_k + (to_j - from_j)) {
            return dir_right_up;
        } else {
            return dir_up;
        }
    }
}

int dir_dj(dir_t dir)
{
    switch (dir) {
        case dir_none:          return  0;
        case dir_up:            return -1;
        case dir_down:          return  1;
        case dir_right_up:      return -1;
        case dir_right_down:    return  0;
        case dir_left_up:       return  0;
        case dir_left_down:     return  1;
    }
}

int dir_dk(dir_t dir)
{
    switch (dir) {
        case dir_none:          return  0;
        case dir_up:            return -1;
        case dir_down:          return  1;
        case dir_right_up:      return  0;
        case dir_right_down:    return  1;
        case dir_left_up:       return -1;
        case dir_left_down:     return  0;
    }
}

dir_t laser_direction(int weapon, int from, int to)
{
    return coords_to_dir(from, to);
}

float laser_damage(int weapon, int from, int to)
{
    int level = weapon & 0x3;
    dir_t dir = laser_direction(weapon, from, to);
    int dj, dk;
    switch (dir) {
        case dir_up:            dk = -1;    dj = -1;    break;
        case dir_down:          dk =  1;    dj =  1;    break;
        case dir_right_up:      dk =  0;    dj = -1;    break;
        case dir_right_down:    dk =  1;    dj =  0;    break;
        case dir_left_up:       dk = -1;    dj =  0;    break;
        case dir_left_down:     dk =  0;    dj =  1;    break;
    }
    int length, dmg;
    switch (level) {
        case 1: length = 4; dmg = 16; break;
        case 2: length = 6; dmg = 18; break;
        case 3: length = 7; dmg = 22; break;
    }
    debug("Laser dj %d dk %d level %d, length %d, dmg %d\n", dj, dk, level, length, dmg);
    int j = map_j_val(from), k = map_k_val(from);
    int to_j = map_j_val(to), to_k = map_k_val(to);
    for (int i = 0; i < length; i++) {
        j += dj; k += dk;
        if (j < 0 || j >= map_j || k < 0 || k >= map_k) {
            break;
        }
        /* TODO: Check for rocks. */
        if (j == to_j && k == to_k) {
            return dmg;
        }
    }
    return 0;
}

int mortar_coords(int weapon, int from, int to)
{
    int dj = abs(map_j_val(from) - map_j_val(to)),
        dk = abs(map_k_val(from) - map_k_val(to));
    int moves = 0;
    while (dj != 0 || dk != 0) {
        moves++;
        /* FIXME: This is wrong. */
        if (dj >= 0 && dk >= 0) {
            dj--; dk--;
        } else if (dj <= 0 && dk <= 0) {
            dj++; dk++;
        } else if (dj <= 0 && dk >= 0) {
            dj++; dk--;
        } else if (dj >= 0 && dk <= 0) {
            dj--; dk++;
        } else {
            assert(0);
        }
    }
    int range = weapon_level(weapon) + 1;
    if (moves <= range) {
        return to;
    } else {
        /* Send the mortar far away. */
        return map_coords(
            map_j_val(from) + range,
            map_k_val(from) + range);
    }
}

float mortar_damage(int weapon, int from, int to)
{
    int coords = mortar_coords(weapon, from, to);
    int damage;
    switch (weapon_level(weapon)) {
        case 1: damage = 20; break;
        case 2: damage = 20; break;
        case 3: damage = 25; break;
    }
    if (coords == from) {
        return damage;
    } else {
        return 0;
    }
}
