StringParameter = {}
StringParameter_mt = { __index = StringParameter }
setmetatable(StringParameter, Control_mt)

-- Constants
StringParameter.kHeight = 30
StringParameter.kWidth = 400
StringParameter.valueOutline = ParameterList.kValueOutlineBig

function StringParameter.Create(root, parentObject, type, startValue, onChange)
	-- Create object
	local stringParameter = Control.Create(root, parentObject)
	setmetatable(stringParameter, StringParameter_mt)
	
	-- Set attributes
	stringParameter.type = type
	stringParameter.value = startValue
	stringParameter.onChange = onChange
	
	stringParameter.textEdit = nil

	-- Create parameter value surfaces
	stringParameter.valueSurface = GSurface(StringParameter.kWidth, StringParameter.kHeight)
	stringParameter:UpdateValueSurface()
	
	return stringParameter	
end
	
function StringParameter:HandleEvent(window, rect, event)
	window:PushScissor(rect)
		local rect = window.currentScissor
		
		local isHot = rect:IsPointInside(event.pos) and not self:IsOtherControlActive()
		
		if (self.isActive==false) then
			if (event.type==kGEventMouseMoved) then
				self:SetHot(isHot)
			elseif (event.type==kGEventMouseDown) then
				if (event.button==kGEventMouseButtonLeft) then
					if (self.isHot) then
						self:SetActive(true)
						self.textEdit = retain(intruder.GTextEdit(rect, self.value, 13, kGAlignCenter, kGVerticalAlignCenter))
					end
				end
			end
		end
		
		-- Check for text edit finish
		if (self.isActive and event.type==kGEventTextEditFinished) then
			if (self.textEdit) then
				if (self.textEdit.state==intruder.GTextEdit_kTextEditDone) then
					local str = self.textEdit.text
					
					-- Update value
					self.value = str
					self:UpdateValueSurface()
					
					if (self.onChange) then
						self.onChange(self.value)
					end
				end
				
				self.textEdit = nil
				self:SetActive(false)
			end
		end
	window:PopScissor()
end

function StringParameter:Draw(window, rect)
	window:PushScissor(rect)
		self.valueSurface:DrawTexture(rect:GetTopLeft())
		
		if (self.isHot) then
			self.valueOutline:DrawTexture(rect:GetTopLeft())
		end
	window:PopScissor()
end

function StringParameter:UpdateValueSurface()
	local str = self.value
	local surface = self.valueSurface
	surface:Clear(GColor(0, 0, 0, 0))
	surface:DrawTextAligned(intruder.kFontFaceEnvyBold, str, GColor(0, 0, 0), 13, kGAlignCenter, kGVerticalAlignCenter, GPoint(1,1));
	surface:DrawTextAligned(intruder.kFontFaceEnvyBold, str, GColor(255, 255, 255), 13, kGAlignCenter, kGVerticalAlignCenter, GPoint(0,0));
	surface:UpdateTexture()
end
