FileParameter = {}
FileParameter_mt = { __index = FileParameter }
setmetatable(FileParameter, Control_mt)

-- Constants
FileParameter.kHeight = 30
FileParameter.kWidth = 400
FileParameter.valueOutline = ParameterList.kValueOutlineBig

function FileParameter.Create(root, parentObject, type, startValue, onChange)
	-- Create object
	local fileParameter = Control.Create(root, parentObject)
	setmetatable(fileParameter, FileParameter_mt)
	
	-- Set attributes
	fileParameter.type = type
	fileParameter.value = startValue
	fileParameter.onChange = onChange
	
	-- Create parameter value surfaces
	fileParameter.valueSurface = GSurface(FileParameter.kWidth, FileParameter.kHeight)
	fileParameter:UpdateValueSurface()
	
	return fileParameter	
end
	
function FileParameter:HandleEvent(window, rect, event)
	window:PushScissor(rect)
		local rect = window.currentScissor
		
		local isHot = rect:IsPointInside(event.pos) and not self:IsOtherControlActive()
		
		if (self.isActive==false) then
			if (event.type==kGEventMouseMoved) then
				self:SetHot(isHot)
			elseif (event.type==kGEventMouseDown) then
				if (event.button==kGEventMouseButtonLeft) then
					if (self.isHot) then
						-- spawn load file dialog
						if (intruder.SpawnLoadFileDialog()==intruder.kDialogFileChosen) then
							local i = string.find(intruder.DialogResult():lower(), startDirectory:lower(), 1, true)
							if (i~=1) then
								print("Source file was not inside project directory")
							else
								local relString = intruder.DialogResult():sub(startDirectory:len()+1)
								self.value = relString
								self:UpdateValueSurface()
								
								if (self.onChange) then
									self.onChange(relString)
								end
							end
						end
					end
				end
			end
		end
	window:PopScissor()
end

function FileParameter:Draw(window, rect)
	window:PushScissor(rect)
		self.valueSurface:DrawTexture(rect:GetTopLeft():Plus(10, 0))
		
		if (self.isHot) then
			self.valueOutline:DrawTexture(rect:GetTopLeft())
		end
	window:PopScissor()
end

function FileParameter:UpdateValueSurface()
	local str = self.value
	local surface = self.valueSurface
	surface:Clear(GColor(0, 0, 0, 0))
	surface:DrawTextAligned(intruder.kFontFaceEnvyBold, str, GColor(0, 0, 0), 11, kGAlignLeft, kGVerticalAlignCenter);
	surface:UpdateTexture()
end
