EditableStringParameter = {}
EditableStringParameter_mt = { __index = EditableStringParameter }
setmetatable(EditableStringParameter, Control_mt)

-- Constants
EditableStringParameter.kHeight = 30
EditableStringParameter.kWidth = 400
EditableStringParameter.valueOutline = ParameterList.kValueOutlineBig

function EditableStringParameter.Create(root, parentObject, type, index, parameter, node, onChange)
	-- Create object
	local optionMenuParameter = Control.Create(root, parentObject)
	setmetatable(optionMenuParameter, EditableStringParameter_mt)
	
	-- Set attributes
	optionMenuParameter.type = type
	optionMenuParameter.index = index
	optionMenuParameter.parameter = parameter
	optionMenuParameter.node = node
	
	EditableStringParameter.currentOnChange = onChange
	
	optionMenuParameter.button = Button.Create(root, optionMenuParameter, EditableStringParameter.kWidth, EditableStringParameter.kHeight, "Edit String", function() intruder.OpenEditableStringWindow(index, parameter, node) end )
	
	return optionMenuParameter	
end

function EditableStringParameter:HandleEvent(window, rect, event)
	window:PushScissor(rect)
		self.button:HandleEvent(window, rect, event)	
	window:PopScissor()
end

function EditableStringParameter:Draw(window, rect)
	window:PushScissor(rect)
		self.button:Draw(window, rect)
	window:PopScissor()
end