Button = {}
Button_mt = { __index = Button }
setmetatable(Button, Control_mt)

function Button.Create(root, parentObject, width, height, caption, onClick)
	-- Create object
	local object = Control.Create(root, parentObject)
	setmetatable(object, Button_mt)
	
	-- Set attributes
	object.width = width
	object.height = height
	object.caption = caption
	object.onClick = onClick
	
	-- Create gradient
	local gradient = GGradient()
	gradient:InsertColor(0, GColor(200, 200, 200))
	gradient:InsertColor(0.499, GColor(180, 180, 180))
	gradient:InsertColor(0.500, GColor(160, 160, 160))
	gradient:InsertColor(1, GColor(140, 140, 140))
	
	-- Create surfaces
	object.normalSurface = GSurface(width, height)
	object.activeSurface = GSurface(width, height)
	
	local rect = GRect(0, 0, width-1, height-1)
	rect:Offset(0.5, 0.5)
	local textSize = 13
	
	object.normalSurface:Clear(GColor(0, 0, 0, 0))
	object.normalSurface:DrawRoundedRectVerticalGradient(rect:CloneWithInset(2), gradient, 5)
	object.normalSurface:DrawRoundedRectOutlined(rect:CloneWithInset(2), GColor(0, 0, 0), 5, 0.5)

	for x=-1,1 do
		for y=-1,1 do
			object.normalSurface:DrawTextAligned(intruder.kFontFaceEnvyBold, caption, GColor(0, 0, 0), textSize, kGAlignCenter, kGVerticalAlignCenter, GPoint(x,y));
		end
	end

	object.normalSurface:DrawTextAligned(intruder.kFontFaceEnvyBold, caption, GColor(255, 255, 130), textSize, kGAlignCenter, kGVerticalAlignCenter, GPoint(0,0));
	object.normalSurface:UpdateTexture()

	
	object.activeSurface:Clear(GColor(0, 0, 0, 0))
	object.activeSurface:DrawRoundedRectVerticalGradient(rect:CloneWithInset(2), gradient, 5)
	object.activeSurface:DrawRoundedRectOutlined(rect:CloneWithInset(2), GColor(0, 0, 0), 5, 2)

	for x=-1,1 do
		for y=-1,1 do
			object.activeSurface:DrawTextAligned(intruder.kFontFaceEnvyBold, caption, GColor(0, 0, 0), textSize, kGAlignCenter, kGVerticalAlignCenter, GPoint(x,y));
		end
	end
	object.activeSurface:DrawTextAligned(intruder.kFontFaceEnvyBold, caption, GColor(255, 255, 255), textSize, kGAlignCenter, kGVerticalAlignCenter, GPoint(0,0));
		
	object.activeSurface:UpdateTexture()
	
	return object
end

function Button:HandleEvent(window, rect, event)
	window:PushScissor(rect)
		-- Determine if point is inside
		self:SetHot((not self:IsOtherControlActive()) and window.currentScissor:IsPointInside(event.pos))
		
		if (self.isActive) then
			if event.type==kGEventMouseUp and event.button==kGEventMouseButtonLeft then
				if self.isHot then
					if self.onClick then
						self.onClick()
					end
				end

				self:SetActive(false)
			end
		elseif self.isHot then
			if event.type==kGEventMouseDown and event.button==kGEventMouseButtonLeft then
				self:SetActive(true)
			end
		end
	window:PopScissor()
end

function Button:Draw(window, rect)
	window:PushScissor(rect)
		if (self.isActive) then
			self.activeSurface:DrawTexture(rect:GetTopLeft():Plus(1, 1))	
		elseif (self.isHot) then
			self.activeSurface:DrawTexture(rect:GetTopLeft())	
		else
			self.normalSurface:DrawTexture(rect:GetTopLeft())	
		end
	window:PopScissor()
end