	/*
		"Stunnel" by Tick of Excess
		
		Contribution to Solskogen Shardertoy compo, Solskogen 2013
		
	*/
	vec4 tunnel(vec2 coor, vec3 origin, float d)
	{
		float rad = 1.0;
		vec2 uv;
		
		vec3 direction = vec3(coor.x, coor.y, 1.0);
		direction = normalize(direction);
			
		float a = pow(direction.x, 2.0) + pow(direction.y, 2.0);
		float b = 2.0 * (origin.x*direction.x + origin.y * direction.y);
		float c = pow(origin.x, 2.0) + pow(origin.y, 2.0) - pow(rad, 2.0);
		
		float delta = pow(b, 2.0) - 4.0 * a * c;
		
		if(delta < 0.0)
		{
			return texture2D(iChannel0, vec2(0.5, 0.5));
		}
		
		float t1 = (-b + sqrt(delta)) / (2.0 * a);
		float t2 = (-b - sqrt(delta)) / (2.0 * a);
		
		float t = min(t1, t2);
		
		vec3 intersection = origin + direction * t;
		
		float u = abs(intersection.z*0.2*sin(d/4.0)) + iGlobalTime;
		float v = abs(atan(intersection.y, intersection.x)/3.1415926);
		v = v + abs(sin(u));
		return texture2D(iChannel0, vec2(u, v));
	}
	
	void main(void)
	{
		float t = fract(iGlobalTime / 1.0);
		
		vec2 uv = gl_FragCoord.xy / iResolution.xy;
		
		vec2 n_pos = (gl_FragCoord.xy - iResolution.xy/2.0) / iResolution.xy;
		n_pos = n_pos + vec2(cos(iGlobalTime/1.1)/1.9, sin(iGlobalTime/1.3)/1.9);
	
		float d = distance(vec2(0.0, 0.0), n_pos);
		
		float a = atan(n_pos.y, n_pos.x)/(3.14159265*2.0) + sin(iGlobalTime);
		
		vec4 b = texture2D(iChannel0, vec2(d, a));
		gl_FragColor = tunnel(n_pos, vec3(sin(iGlobalTime/1.01)/1.5, cos(iGlobalTime/1.03)/1.5, -1.0), iGlobalTime);
	}
