#version 150 core

in vec4 in_Position;
in vec4 in_Color0;

uniform mat4 projM;
uniform mat4 cameraM;
uniform mat4 modelM;
uniform float row;

out vec4 color;
out float fade;

void main()
{
	// Fade in geometry
    const float frange = 25.0;
	fade =  1.0;
	fade -= max(0.0, row - 256.0 + frange) / frange;
	fade -= max(0.0f, frange - row) / frange;

	color = in_Color0;
    gl_Position = projM * cameraM * modelM * in_Position;;
}