#version 150 core
#include classicnoise2D.glsl

uniform sampler2D source;
uniform sampler2D vignett;
uniform sampler1D gradient;
uniform sampler1D gradient2;
//uniform sampler2D glow;
uniform sampler2D noise;

uniform float time;
uniform float rgb_separation;
uniform float distort_amount;
//uniform float noise_amount;
//uniform float distort_amount_small;
//uniform float distort_amount_big;
//uniform float bulge_amount;
//uniform float scanlines_size;
//uniform float scanlines_color;
uniform float fade_amount;
uniform vec3 fade_color;
uniform float img_bright;
uniform float img_contr;
uniform float noise_strength;
uniform float noise_offset;
uniform float colgrade_toggle;
uniform float palette_mix;

in vec2 uv;
out vec4 fragColor;


float PI = 3.14159265358979323846264;

vec3 brightnessContrast(vec3 color, float brightness, float contrast)
{
	if (brightness < 0.0)
	{
		color *= 1.0 + brightness;
	}
	else
	{
		color += (1.0 - color) * brightness;
	}
	color = (color - 0.5) * (tan((contrast + 1.0) * PI / 4.0)) + 0.5;
	return color;
}

vec4 screen(vec4 color0, vec4 color1)
{
    vec4 white = vec4(1.0, 1.0, 1.0, 1.0);
    return white - ((white - color0) * (white - color1));
}

void main()
{
    // Lens
    float xc = (uv.x - 0.5) * 0.65;
	float yc = (uv.y - 0.5) * 0.65;
    
	float dist = 1.0 - sqrt(pow(xc, 2.0) + pow(yc, 2.0));
    
	vec2 lenscoord;
	lenscoord.x = (xc / dist) + 0.5;
	lenscoord.y = (yc / dist) + 0.5;
	lenscoord = uv;

    
    // Noise values
	float n = cnoise(vec2(time * 3.0, uv.y * 10.0));
    float testn = n;
	n -= 0.6;
	n *= 3.0;
    float n2 = cnoise((time * 10000.0) + uv.xy * vec2(200.0, 600.0));

    
    // Distort
    lenscoord += (vec2(n2 / 150.0, 0.0) + vec2(testn / 200.0, 0.0)) / 4.0;
    

    // Distort Extreme
    float n3 = cnoise(vec2(time * 50.0, uv.y * 50.0));
    lenscoord.x += n3 * distort_amount;
    
    
    // Source color & rgb separation
    //vec3 color = texture(source, uv).rgb;
    
    vec3 color;
    color.r = texture(source, lenscoord + vec2(rgb_separation , 0.0)).r;
    color.g = texture(source, lenscoord                             ).g;
    color.b = texture(source, lenscoord - vec2(rgb_separation , 0.0)).b;
    //color = screen(vec4(color, 1.0), texture(glow, lenscoord)).xyz;
    //color += (texture(glow, uv).xyz) / 1.0;

    
    // Shadowmask
    //color -= texture(shadowmask, uv * 4.0).rgb / 2.0;
    
    
    // Beam
    //color += mod((1.0 - uv.y) - time, 1.0) / 8.0;
    

    // Color noise
	color += (clamp(n, 0.0, 1.0) * clamp(n2, 0.0, 1.0)) * 2.0;

    
    // Color grading
    if(colgrade_toggle > 1.0)
    {
        color.r = mix(texture(gradient, color.r).r, texture(gradient2, color.r).r, palette_mix);
        color.g = mix(texture(gradient, color.g).g, texture(gradient2, color.g).g, palette_mix);
        color.b = mix(texture(gradient, color.b).b, texture(gradient2, color.b).b, palette_mix);
    }
    
    // Brightness & ContraZt
    color = brightnessContrast(color, img_bright, img_contr);

    
    // Scanlines
    color -= abs(sin(uv.y * 450.0)) / 2.5;


    // TVnoise
	float r = mod((texture(noise, uv) + noise_offset).r * 15.0, 1.0);
	float g = mod((texture(noise, uv) + noise_offset + 0.5).g * 15.0, 1.0);
	float b = mod((texture(noise, uv) + noise_offset - 0.75).b * 15.0, 1.0);
	vec3 noise_value = vec3(r, g, b);
	color += (vec3(1.0) - color) * (noise_value * noise_strength);
    
    
    // Vignett
    lenscoord.x = (xc / dist) + 0.5;
    lenscoord.y = (yc / dist) + 0.5;
    color *= texture(vignett, lenscoord).rgb;
    
    
    // Final og fade
	fragColor = mix(vec4(color, 1.0), vec4(fade_color, 1.0), fade_amount);
//	fragColor = vec4(color, 1.0);

}
