#version 150

in vec3 in_Position;
in vec3 in_Normal;
in vec2 in_UV0;

out vec3 normal;
out vec3 dir;
out vec2 uv;

uniform mat4 ProjM;
uniform mat4 ViewM;
uniform mat3 NormalM;
uniform mat3 SkyM;

void main( void )
{
	normal = NormalM * in_Normal;
    uv = in_UV0;
	dir = SkyM * in_Position;
	gl_Position = ProjM * ViewM * vec4(in_Position, 1.0);
}
